<?php $year = date('Y'); ?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Quarter</title>
    <meta name="theme-color" content="#f9f0e6">
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Raleway:wght@300;400;500;600&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Raleway', sans-serif;
            background: linear-gradient(180deg, #f9f0e6 0%, #FFE5CC 25%, #FFD4A3 50%, #FFC78A 75%, #FFB366 100%);
            min-height: 100vh;
        }
    </style>
</head>
<body class="text-gray-800">
<?php include 'header.php'; ?>
    <div class="min-h-screen flex flex-col">
        <div class="flex-1 flex items-center justify-center px-6 md:px-4 py-12">
            <div class="w-full max-w-2xl">
                <h1 class="text-4xl md:text-6xl text-center mb-8 md:mb-6 font-light tracking-wide leading-tight">nos quartiers méritent une beauté</h1>
                
                <p class="text-center text-gray-700 mb-8 md:mb-6 text-base font-light">et nous la construisons ensemble</p>
                
                <p class="text-center text-gray-600 mb-12 text-sm font-light leading-relaxed max-w-xl mx-auto px-4">Quarter apporte de la nouveauté aux quartiers que nous aimons, en créant des espaces et des services qui rapprochent les communautés locales.</p>
                
                <div class="w-24 h-px bg-gray-300 mx-auto mb-12"></div>
                
                <div class="max-w-md mx-auto space-y-3 px-4">
                    <a href="https://vertchasseur.com" class="block text-center text-gray-800 hover:text-gray-600 font-light border-b border-gray-200 pb-3 transition-colors">
                        Vert Chasseur
                    </a>
                    <p class="block text-center text-gray-400 font-light border-b border-gray-200 pb-3">
                        bientôt disponible
                    </p>
                    <a href="https://monwaterloo.be" class="block text-center text-gray-800 hover:text-gray-600 font-light transition-colors">
                        Mon Waterloo
                    </a>
                </div>
            </div>
        </div>
        
        <footer class="text-center py-8 text-gray-500 text-xs border-t border-gray-200 bg-[#f9f0e6]/50 backdrop-blur-sm">
            <p>© <?php echo $year; ?> Quarter, tous droits réservés. Un projet membre du groupe aktascorp.</p>
        </footer>
    </div>
</body>
</html>