<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Connexion | AndWeare</title>
    <link rel="icon" type="image/png" href="logo.png">
    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+KR:wght@300;400;500;700&display=swap" rel="stylesheet">
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        body {
            font-family: 'Noto Sans KR', sans-serif;
            background-color: #ffffff;
        }
        
        .login-container {
            max-width: 400px;
            margin: 0 auto;
        }
        
        .form-control {
            width: 100%;
            padding: 0.75rem 1rem;
            border: 1px solid #e2e8f0;
            border-radius: 8px;
            transition: all 0.2s ease;
        }
        
        .form-control:focus {
            border-color: #000;
            box-shadow: 0 0 0 3px rgba(0, 0, 0, 0.1);
            outline: none;
        }
        
        .fade-in {
            animation: fadeIn 0.6s ease forwards;
            opacity: 0;
        }
        
        @keyframes fadeIn {
            from {
                opacity: 0;
                transform: translateY(20px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
        
        .delay-1 { animation-delay: 0.1s; }
        .delay-2 { animation-delay: 0.2s; }
        .delay-3 { animation-delay: 0.3s; }
        .delay-4 { animation-delay: 0.4s; }
        .delay-5 { animation-delay: 0.5s; }
    </style>
</head>
<body class="min-h-screen">
    <?php include 'header.php'; ?>
    
    <main class="flex-grow pt-32 px-4">
        <div class="login-container">
            <h1 class="text-3xl font-bold mb-8 text-center fade-in">Connexion</h1>
            
            <form action="Connect.php" method="post" class="space-y-6">
                <div class="fade-in delay-1">
                    <label for="email" class="block mb-2 text-sm font-medium text-gray-700">Email</label>
                    <input type="email" id="email" name="email" class="form-control" required>
                </div>
                
                <div class="fade-in delay-2">
                    <label for="password" class="block mb-2 text-sm font-medium text-gray-700">Mot de passe</label>
                    <input type="password" id="password" name="password" class="form-control" required>
                </div>
                
                <div class="flex items-center justify-between fade-in delay-3">
                    <div class="flex items-center">
                        <input type="checkbox" id="remember" name="remember" class="h-4 w-4 text-black border-gray-300 rounded">
                        <label for="remember" class="ml-2 block text-sm text-gray-700">Se souvenir de moi</label>
                    </div>
                    
                    <a href="#" class="text-sm text-gray-600 hover:text-black">Mot de passe oublié?</a>
                </div>
                
                <div class="fade-in delay-4">
                    <button type="submit" class="w-full bg-black text-white rounded-full py-3 font-medium hover:bg-gray-800 transition-colors">
                        Se connecter
                    </button>
                </div>
                
                <div class="text-center fade-in delay-5">
                    <p class="text-sm text-gray-600">
                        Vous n'avez pas de compte? <a href="register.php" class="text-black font-medium hover:underline">Créez-en un</a>
                    </p>
                </div>
            </form>
        </div>
    </main>
</body>
</html>