<?php
require 'db.php';

function sendWelcomeEmail($email) {
    $subject = 'Welcome to Imators';
    $message = '
 <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Welcome to Imators</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600&display=swap" rel="stylesheet">
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: {
                        poppins: ['Poppins', 'sans-serif'],
                    },
                }
            }
        }
    </script>
</head>
<body class="bg-black text-white font-poppins">
    <div class="container mx-auto px-4 py-8 max-w-xl">
        <div class="bg-black rounded-lg shadow-xl p-8 border border-gray-800">
            <div class="text-center mb-6">
                <img src="https://cdn.imators.com/logo.png" alt="Imators Logo" class="mx-auto mb-4">
            </div>
            
            <h1 class="text-3xl font-semibold mb-6 text-white text-center">Welcome to Imators</h1>
            
            <p class="mb-4 text-lg">Hello,</p>
            
            <p class="mb-4">Thank you for joining Imators. Your account has been successfully created.</p>
            
            <p class="mb-4">You can now access our services and start exploring the features we offer.</p>
            
            <p class="mb-6">If you have any questions, please don't hesitate to contact our support team.</p>
            
            <p class="mb-2">Best regards,</p>
            <p class="font-semibold">The Imators Team</p>
            
            <div class="mt-8 pt-6 border-t border-gray-800 text-sm text-gray-400 text-center">
                <p>&copy; 2024 Imators. All rights reserved.</p>
            </div>
        </div>
    </div>
</body>
    ';

    $headers = "MIME-Version: 1.0" . "\r\n";
    $headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
    $headers .= 'From: Imators <no-reply@imators.com>' . "\r\n";

    mail($email, $subject, $message, $headers);
}

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $username = $_POST['name'];
    $email = $_POST['email'];
    $password = $_POST['password'];
    $created_at = date("Y-m-d H:i:s");

    $hashed_password = password_hash($password, PASSWORD_DEFAULT);

    $sql = "INSERT INTO utilisateurs (username, email, password, created_at) VALUES (?, ?, ?, ?)";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("ssss", $username, $email, $hashed_password, $created_at);
    
    if ($stmt->execute()) {
        sendWelcomeEmail($email);
        echo "<script>alert('Account created successfully!'); window.location.href='index.php';</script>";
    } else {
        echo "<script>alert('Error: " . addslashes($stmt->error) . "');</script>";
    }
    
    $stmt->close();
}

$conn->close();
?>