<?php
require 'vendor/autoload.php';

use Dompdf\Dompdf;
use Dompdf\Options;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $options = new Options();
    $options->set('isHtml5ParserEnabled', true);
    $options->set('defaultFont', 'Helvetica');
    
    $dompdf = new Dompdf($options);
    
    $html = '
    <!DOCTYPE html>
    <html>
    <head>
        <meta charset="UTF-8">
        <style>
            @page { 
                margin: 20mm;
                size: A4 landscape;
            }
            body {
                font-family: Helvetica, Arial, sans-serif;
                color: #333;
                line-height: 1.4;
            }
            .container {
                display: grid;
                grid-template-columns: repeat(7, 1fr);
                gap: 15px;
            }
            .day {
                border: 1px solid #ddd;
                padding: 15px;
                page-break-inside: avoid;
                border-radius: 5px;
            }
            .day-header {
                font-size: 16px;
                font-weight: bold;
                color: #1a1a1a;
                padding-bottom: 10px;
                border-bottom: 2px solid #f0f0f0;
                margin-bottom: 10px;
            }
            .section {
                margin: 12px 0;
            }
            .section-title {
                font-size: 12px;
                color: #666;
                margin-bottom: 5px;
                text-transform: uppercase;
            }
            .checkbox {
                width: 15px;
                height: 15px;
                border: 1.5px solid #999;
                display: inline-block;
            }
            .note-box {
                border: 1px solid #ddd;
                border-radius: 4px;
                padding: 8px;
                min-height: 25px;
                background: #fafafa;
            }
            .mood {
                display: flex;
                gap: 10px;
            }
            .mood-option {
                width: 20px;
                height: 20px;
                border: 1px solid #ccc;
                border-radius: 50%;
            }
            .tasks {
                margin-top: 8px;
            }
            .task-item {
                display: flex;
                align-items: center;
                gap: 8px;
                margin: 4px 0;
            }
        </style>
    </head>
    <body>
        <div class="container">
            <div class="day">
                <div class="day-header">Lundi</div>
                <div class="section">
                    <div class="section-title">Rappel</div>
                    <div class="note-box"></div>
                </div>
                <div class="section">
                    <div class="section-title">Devoir</div>
                    <div class="checkbox"></div>
                </div>
                <div class="section">
                    <div class="section-title">Motivation</div>
                    <div class="note-box"></div>
                </div>
                <div class="section">
                    <div class="section-title">Humeur</div>
                    <div class="mood">
                        <div class="mood-option"></div>
                        <div class="mood-option"></div>
                        <div class="mood-option"></div>
                    </div>
                </div>
                <div class="section">
                    <div class="section-title">Tâches</div>
                    <div class="tasks">
                        <div class="task-item">
                            <div class="checkbox"></div>
                            <div class="note-box" style="flex-grow: 1;"></div>
                        </div>
                        <div class="task-item">
                            <div class="checkbox"></div>
                            <div class="note-box" style="flex-grow: 1;"></div>
                        </div>
                        <div class="task-item">
                            <div class="checkbox"></div>
                            <div class="note-box" style="flex-grow: 1;"></div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- Répéter pour les autres jours -->
        </div>
    </body>
    </html>';
    
    $dompdf->loadHtml($html);
    $dompdf->render();
    $dompdf->stream("MyDayBetter.pdf", ["Attachment" => true]);
    exit;
}
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>MyDayBetter - Impression</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-50 flex items-center justify-center min-h-screen">
    <div class="text-center p-8">
        <h1 class="text-4xl font-bold text-gray-900 mb-4">MyDayBetter</h1>
        <p class="text-gray-600 mb-8">Clique sur le bouton pour générer ton planning de la semaine à imprimer</p>
        <form method="POST">
            <button type="submit" class="bg-blue-600 text-white px-8 py-4 rounded-lg font-semibold text-lg hover:bg-blue-700 transition-colors focus:outline-none focus:ring-4 focus:ring-blue-500 focus:ring-opacity-50">
                Générer mon planning
            </button>
        </form>
    </div>
</body>
</html>