<!DOCTYPE html>

<html lang="en-GB">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Formore</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: {
                        'poppins': ['Poppins', 'sans-serif'],
                    }
                }
            }
        }
    </script>
</head>
<body class="bg-white font-poppins font-light">
    <section class="h-screen flex flex-col">
        <header class="py-6 px-6 md:px-12">
            <h1 class="text-2xl md:text-3xl font-medium text-black">formore</h1>
        </header>

    <main class="flex-1 container mx-auto px-6 md:px-12 max-w-7xl">
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-8 lg:gap-16 items-center h-full">
            <div class="order-2 lg:order-1">
                <div class="max-w-lg">
                    <h2 class="text-3xl md:text-4xl lg:text-5xl font-medium text-black mb-4">Welcome back to your entertainment</h2>
                    
                    <p class="text-gray-600 text-lg mb-8">Find movies and series, make in your favourite games with worldwide success, in an environment where anyone can be a director and present you their work, on formore.</p>
                    
                    <div class="space-y-3 mb-8">
                        <div class="flex items-center space-x-3">
                            <svg class="w-5 h-5 text-black" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
                            </svg>
                            <span class="text-gray-800">Unlimited streaming across all devices</span>
                        </div>
                        
                        <div class="flex items-center space-x-3">
                            <svg class="w-5 h-5 text-black" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
                            </svg>
                            <span class="text-gray-800">4K Ultra HD and HDR content</span>
                        </div>
                        
                        <div class="flex items-center space-x-3">
                            <svg class="w-5 h-5 text-black" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
                            </svg>
                            <span class="text-gray-800">Download content for offline viewing</span>
                        </div>
                        
                        <div class="flex items-center space-x-3">
                            <svg class="w-5 h-5 text-black" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
                            </svg>
                            <span class="text-gray-800">No subscription, it’s free.</span>
                        </div>
                    </div>

                    <a href="/home.php" class="bg-black text-white px-8 py-4 rounded-lg flex items-center space-x-3 hover:bg-gray-800 transition-colors w-full md:w-auto justify-center md:justify-start">
    <img src="https://cdn.imators.com/logo.png" alt="Login icon" class="w-5 h-5 rounded-full">
    <span class="font-medium">Sign in with Imators</span>
</a>
                </div>
            </div>

            <div class="order-1 lg:order-2">
                <div class="aspect-square lg:aspect-video bg-gray-100 rounded-2xl overflow-hidden h-full max-h-[500px]">
                    <img src="case2.png" class="w-full h-full object-cover">
                </div>
            </div>
        </div>
    </main>
</section>

</body>
</html>