<?php 
require_once 'includes/auth.php';

$stmt = $pdo->prepare("SELECT * FROM profiles WHERE user_id = ? ORDER BY is_main DESC, created_at ASC");
$stmt->execute([$current_user['id']]);
$profiles = $stmt->fetchAll(PDO::FETCH_ASSOC);

if (empty($profiles)) {
    $stmt = $pdo->prepare("INSERT INTO profiles (user_id, name, avatar, age_limit, is_main) VALUES (?, ?, ?, ?, 1)");
    $stmt->execute([
        $current_user['id'], 
        $current_user['username'], 
        $current_user['profile_picture'], 
        18
    ]);
    
    $stmt = $pdo->prepare("SELECT * FROM profiles WHERE user_id = ?");
    $stmt->execute([$current_user['id']]);
    $profiles = $stmt->fetchAll(PDO::FETCH_ASSOC);
}

$selected_profile_id = $_SESSION['selected_profile'] ?? $profiles[0]['id'];
$selected_profile = null;
foreach($profiles as $profile) {
    if($profile['id'] == $selected_profile_id) {
        $selected_profile = $profile;
        break;
    }
}

if (!$selected_profile) {
    $selected_profile = $profiles[0];
    $_SESSION['selected_profile'] = $selected_profile['id'];
}

$search = $_GET['search'] ?? '';

$stmt = $pdo->prepare("SELECT DISTINCT category FROM content WHERE status = 'approved' AND category IS NOT NULL AND category != '' ORDER BY category ASC");
$stmt->execute();
$categories = $stmt->fetchAll(PDO::FETCH_COLUMN);

$content_by_category = [];

if (!empty($search)) {
    $stmt = $pdo->prepare("SELECT * FROM content WHERE status = 'approved' AND age_rating <= ? AND (title LIKE ? OR description LIKE ? OR author LIKE ?) ORDER BY created_at DESC LIMIT 20");
    $search_term = "%$search%";
    $stmt->execute([$selected_profile['age_limit'], $search_term, $search_term, $search_term]);
    $search_results = $stmt->fetchAll(PDO::FETCH_ASSOC);
} else {
    foreach ($categories as $category) {
        $stmt = $pdo->prepare("SELECT * FROM content WHERE status = 'approved' AND age_rating <= ? AND category = ? ORDER BY created_at DESC LIMIT 12");
        $stmt->execute([$selected_profile['age_limit'], $category]);
        $content_by_category[$category] = $stmt->fetchAll(PDO::FETCH_ASSOC);
    }
}

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['select_profile'])) {
    $_SESSION['selected_profile'] = $_POST['profile_id'];
    header('Location: home.php');
    exit;
}

$all_content = [];
foreach ($content_by_category as $category => $contents) {
    $all_content = array_merge($all_content, $contents);
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Formore - Your Entertainment</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600&display=swap" rel="stylesheet">
    <link rel="icon" href="https://cdn.imators.com/logo.png" type="image/png">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        :root {
            --bg-primary: #fff;
            --bg-secondary: #f8f9fa;
            --text-primary: #333;
            --text-secondary: #666;
            --border-color: #e9ecef;
            --header-bg: rgba(255, 255, 255, 0.95);
        }

        html.dark {
            --bg-primary: #0d0d0d;
            --bg-secondary: #1a1a1a;
            --text-primary: #f0f0f0;
            --text-secondary: #b0b0b0;
            --border-color: #333;
            --header-bg: rgba(13, 13, 13, 0.95);
        }

        body {
            font-family: 'Poppins', sans-serif;
            font-weight: 300;
            background: var(--bg-primary);
            color: var(--text-primary);
            overflow-x: hidden;
            transition: background 0.3s ease, color 0.3s ease;
        }

        .header {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            z-index: 100;
            padding: 1rem 2rem;
            background: var(--header-bg);
            backdrop-filter: blur(20px);
            border-bottom: 1px solid var(--border-color);
        }

        .header-content {
            display: flex;
            justify-content: space-between;
            align-items: center;
            max-width: 1400px;
            margin: 0 auto;
            gap: 1rem;
        }

        .logo {
            font-size: 1.5rem;
            font-weight: 500;
            color: var(--text-primary);
            text-decoration: none;
        }

        .header-center {
            flex: 1;
            display: flex;
            justify-content: center;
            max-width: 400px;
            margin: 0 2rem;
        }

        .search-container {
            position: relative;
            width: 100%;
        }

        .search-input {
            width: 100%;
            background: var(--bg-secondary);
            border: 1px solid var(--border-color);
            border-radius: 25px;
            padding: 0.75rem 1.5rem;
            font-size: 0.9rem;
            outline: none;
            color: var(--text-primary);
            transition: all 0.3s ease;
        }

        .search-input::placeholder {
            color: var(--text-secondary);
        }

        .search-input:focus {
            border-color: var(--text-primary);
            box-shadow: 0 0 0 3px rgba(0, 0, 0, 0.1);
        }

        html.dark .search-input:focus {
            box-shadow: 0 0 0 3px rgba(255, 255, 255, 0.1);
        }

        .header-actions {
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }

        .icon-btn {
            background: none;
            border: none;
            color: var(--text-primary);
            cursor: pointer;
            width: 40px;
            height: 40px;
            display: flex;
            align-items: center;
            justify-content: center;
            border-radius: 50%;
            transition: all 0.3s ease;
            font-size: 1.1rem;
        }

        .icon-btn:hover {
            background: var(--bg-secondary);
        }

        .menu-toggle {
            display: none;
        }

        .profile-btn {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            overflow: hidden;
            cursor: pointer;
            border: 2px solid var(--border-color);
            transition: all 0.3s ease;
            background: none;
            padding: 0;
        }

        .profile-btn:hover {
            border-color: var(--text-primary);
            transform: scale(1.05);
        }

        .profile-btn img {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }

        .header-btn {
            background: none;
            color: var(--text-primary);
            border: none;
            padding: 0.5rem 1rem;
            cursor: pointer;
            font-size: 0.9rem;
            text-decoration: none;
            transition: all 0.3s ease;
            font-weight: 400;
            border-radius: 6px;
        }

        .header-btn:hover {
            background: var(--bg-secondary);
        }

        .header-btn.primary {
            background: var(--text-primary);
            color: var(--bg-primary);
            border-radius: 50%;
            width: 40px;
            height: 40px;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 0;
            font-size: 1.2rem;
        }

        .header-btn.primary:hover {
            opacity: 0.8;
        }

        /* Search Overlay */
        .search-overlay {
            position: fixed;
            inset: 0;
            background: var(--bg-primary);
            z-index: 200;
            display: none;
            flex-direction: column;
        }

        .search-overlay.active {
            display: flex;
        }

        .search-overlay-header {
            padding: 1.5rem;
            border-bottom: 1px solid var(--border-color);
            display: flex;
            align-items: center;
            gap: 1rem;
        }

        .search-overlay-input {
            flex: 1;
            background: var(--bg-secondary);
            border: 1px solid var(--border-color);
            border-radius: 25px;
            padding: 0.75rem 1.5rem;
            font-size: 1rem;
            color: var(--text-primary);
            outline: none;
        }

        .search-overlay-close {
            background: none;
            border: none;
            color: var(--text-primary);
            cursor: pointer;
            font-size: 1.5rem;
            width: 40px;
            height: 40px;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .search-results {
            flex: 1;
            overflow-y: auto;
        }

        .search-result-item {
            padding: 1rem 1.5rem;
            border-bottom: 1px solid var(--border-color);
            cursor: pointer;
            transition: all 0.3s ease;
        }

        .search-result-item:hover {
            background: var(--bg-secondary);
        }

        .search-result-title {
            font-weight: 500;
            color: var(--text-primary);
            margin-bottom: 0.25rem;
        }

        .search-result-meta {
            font-size: 0.85rem;
            color: var(--text-secondary);
        }

        .main-content {
            margin-top: 80px;
            padding: 2rem;
            max-width: 1400px;
            margin-left: auto;
            margin-right: auto;
        }

        .content-section {
            margin-bottom: 3rem;
        }

        .section-title {
            font-size: 1.5rem;
            font-weight: 500;
            color: var(--text-primary);
            margin-bottom: 1.5rem;
        }

        .content-carousel {
            display: flex;
            gap: 1rem;
            overflow-x: auto;
            padding-bottom: 1rem;
        }

        .content-carousel::-webkit-scrollbar {
            height: 6px;
        }

        .content-carousel::-webkit-scrollbar-track {
            background: var(--bg-secondary);
        }

        .content-carousel::-webkit-scrollbar-thumb {
            background: var(--border-color);
            border-radius: 3px;
        }

        .content-card {
            flex: 0 0 280px;
            height: 160px;
            border-radius: 8px;
            overflow: hidden;
            cursor: pointer;
            transition: all 0.3s ease;
            border: 1px solid var(--border-color);
            position: relative;
        }

        .content-card:hover {
            transform: translateY(-4px);
            box-shadow: 0 8px 16px rgba(0, 0, 0, 0.1);
        }

        html.dark .content-card:hover {
            box-shadow: 0 8px 16px rgba(0, 0, 0, 0.3);
        }

        .content-card img {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }

        .age-badge {
            position: absolute;
            top: 8px;
            right: 8px;
            background: rgba(0, 0, 0, 0.7);
            color: white;
            padding: 0.25rem 0.75rem;
            border-radius: 12px;
            font-size: 0.75rem;
            font-weight: 600;
        }

        .content-overlay {
            position: absolute;
            bottom: 0;
            left: 0;
            right: 0;
            background: linear-gradient(to top, rgba(0, 0, 0, 0.8), transparent);
            padding: 1rem;
            color: white;
            opacity: 0;
            transition: opacity 0.3s ease;
        }

        .content-card:hover .content-overlay {
            opacity: 1;
        }

        .content-overlay-title {
            font-weight: 600;
            font-size: 0.95rem;
            margin-bottom: 0.25rem;
        }

        .content-overlay-meta {
            font-size: 0.8rem;
            opacity: 0.9;
        }

        .search-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(150px, 1fr));
            gap: 1rem;
        }

        .search-card {
            height: 225px;
            border-radius: 8px;
            overflow: hidden;
            cursor: pointer;
            position: relative;
            transition: all 0.3s ease;
            border: 1px solid var(--border-color);
        }

        .search-card:hover {
            transform: translateY(-4px);
            box-shadow: 0 8px 16px rgba(0, 0, 0, 0.1);
        }

        html.dark .search-card:hover {
            box-shadow: 0 8px 16px rgba(0, 0, 0, 0.3);
        }

        .search-card img {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }

        .search-overlay-card {
            position: absolute;
            bottom: 0;
            left: 0;
            right: 0;
            background: linear-gradient(to top, rgba(0, 0, 0, 0.8), transparent);
            padding: 1rem;
            color: white;
            opacity: 0;
            transition: opacity 0.3s ease;
        }

        .search-card:hover .search-overlay-card {
            opacity: 1;
        }

        .empty-state {
            text-align: center;
            padding: 4rem 2rem;
            color: var(--text-secondary);
        }

        .empty-icon {
            font-size: 4rem;
            margin-bottom: 1rem;
        }

        .empty-state h3 {
            font-size: 1.5rem;
            margin-bottom: 0.5rem;
            color: var(--text-primary);
        }

        .profile-modal {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(0, 0, 0, 0.5);
            display: flex;
            align-items: center;
            justify-content: center;
            z-index: 200;
            opacity: 0;
            visibility: hidden;
            transition: all 0.3s ease;
        }

        .profile-modal.active {
            opacity: 1;
            visibility: visible;
        }

        .profile-modal-content {
            background: var(--bg-primary);
            border-radius: 16px;
            padding: 2rem;
            max-width: 500px;
            width: 90%;
            max-height: 80vh;
            overflow-y: auto;
            box-shadow: 0 10px 40px rgba(0, 0, 0, 0.2);
        }

        html.dark .profile-modal-content {
            box-shadow: 0 10px 40px rgba(0, 0, 0, 0.5);
        }

        .modal-title {
            font-size: 1.5rem;
            font-weight: 600;
            margin-bottom: 1.5rem;
            color: var(--text-primary);
        }

        .profiles-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(100px, 1fr));
            gap: 1rem;
            margin-bottom: 1.5rem;
        }

        .profile-item {
            display: flex;
            flex-direction: column;
            align-items: center;
            gap: 0.75rem;
            cursor: pointer;
            background: none;
            border: none;
            transition: all 0.3s ease;
            padding: 0.5rem;
            border-radius: 12px;
        }

        .profile-item:hover {
            background: var(--bg-secondary);
        }

        .profile-item.active {
            background: var(--bg-secondary);
            border: 2px solid var(--text-primary);
        }

        .profile-avatar {
            width: 80px;
            height: 80px;
            border-radius: 50%;
            overflow: hidden;
            border: 2px solid var(--border-color);
            transition: all 0.3s ease;
        }

        .profile-item:hover .profile-avatar,
        .profile-item.active .profile-avatar {
            border-color: var(--text-primary);
        }

        .profile-avatar img {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }

        .profile-name {
            font-size: 0.9rem;
            font-weight: 500;
            color: var(--text-primary);
            text-align: center;
            word-break: break-word;
        }

        .add-profile {
            justify-content: center;
        }

        .add-profile-icon {
            width: 80px;
            height: 80px;
            border-radius: 50%;
            background: var(--bg-secondary);
            border: 2px dashed var(--border-color);
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 2rem;
            color: var(--text-secondary);
            transition: all 0.3s ease;
        }

        .profile-item:hover .add-profile-icon {
            background: var(--bg-secondary);
            border-color: var(--text-primary);
            color: var(--text-primary);
        }

        .close-modal {
            width: 100%;
            background: var(--text-primary);
            color: var(--bg-primary);
            border: none;
            padding: 0.75rem;
            border-radius: 8px;
            font-size: 1rem;
            font-weight: 500;
            cursor: pointer;
            transition: all 0.3s ease;
        }

        .close-modal:hover {
            opacity: 0.9;
        }

        .footer {
            background: var(--bg-secondary);
            border-top: 1px solid var(--border-color);
            padding: 2rem 2rem;
            margin-top: 4rem;
        }

        .footer-content {
            max-width: 1400px;
            margin: 0 auto;
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 2rem;
        }

        .footer-brand {
            font-size: 1.25rem;
            font-weight: 500;
            color: var(--text-primary);
            margin-bottom: 0.5rem;
        }

        .footer-text {
            font-size: 0.9rem;
            color: var(--text-secondary);
            margin: 0;
            font-weight: 300;
        }

        .footer-link {
            color: var(--text-primary);
            text-decoration: none;
            font-size: 0.9rem;
            font-weight: 300;
            transition: all 0.3s ease;
            display: block;
            margin-bottom: 0.5rem;
        }

        .footer-link:hover {
            color: var(--text-secondary);
            text-decoration: underline;
        }

        @media (max-width: 768px) {
            .menu-toggle {
                display: flex;
            }

            .header-center {
                display: none;
            }

            .header-content {
                gap: 0.5rem;
            }

            .header-btn {
                display: none;
            }

            .main-content {
                margin-top: 70px;
                padding: 1rem;
            }

            .content-card {
                flex: 0 0 150px;
                height: 90px;
            }

            .search-grid {
                grid-template-columns: repeat(auto-fill, minmax(120px, 1fr));
            }

            .search-card {
                height: 180px;
            }

            .section-title {
                font-size: 1.25rem;
            }
        }

        @media (max-width: 480px) {
            .header {
                padding: 0.75rem;
            }

            .header-content {
                gap: 0.25rem;
            }

            .logo {
                font-size: 1.1rem;
            }

            .main-content {
                padding: 0.75rem;
            }

            .content-card {
                flex: 0 0 120px;
                height: 70px;
            }

            .section-title {
                font-size: 1rem;
            }

            .footer {
                padding: 1rem;
            }

            .footer-content {
                gap: 1rem;
                grid-template-columns: 1fr;
            }

            .footer-brand {
                font-size: 1rem;
            }
        }
    </style>
</head>
<body>
    <header class="header">
        <div class="header-content">
            <a href="home.php" class="logo">formore</a>
            
            <div class="header-center">
                <div class="search-container">
                    <form method="GET">
                        <input type="search" name="search" class="search-input" placeholder="Search content..." 
                               value="<?php echo htmlspecialchars($search); ?>">
                    </form>
                </div>
            </div>
            
            <div class="header-actions">
                <button class="menu-toggle" onclick="openSearchOverlay()">
                    <i class="fas fa-search"></i>
                </button>
                <button class="icon-btn" onclick="toggleDarkMode()">
                    <i class="fas fa-moon" id="themeIcon"></i>
                </button>
                <button class="profile-btn" onclick="openProfileModal()">
                    <img src="<?php echo htmlspecialchars($selected_profile['avatar']); ?>" alt="Profile">
                </button>
                <a href="settings.php" class="header-btn">Settings</a>
                <a href="make.php" class="header-btn primary">+</a>
            </div>
        </div>
    </header>

    <div class="search-overlay" id="searchOverlay">
        <div class="search-overlay-header">
            <input 
                type="search" 
                class="search-overlay-input" 
                id="overlaySearchInput"
                placeholder="Search content..." 
                onkeyup="handleSearchOverlay(this.value)"
            >
            <button class="search-overlay-close" onclick="closeSearchOverlay()">
                <i class="fas fa-times"></i>
            </button>
        </div>
        <div class="search-results" id="searchResults"></div>
    </div>
    
    <main class="main-content">
        <?php if (empty($search)): ?>
            <?php foreach($content_by_category as $category => $contents): ?>
                <?php if (!empty($contents)): ?>
                <div class="content-section">
                    <h2 class="section-title"><?php echo htmlspecialchars($category); ?></h2>
                    <div class="content-carousel">
                        <?php foreach($contents as $content): ?>
                            <div class="content-card" onclick="window.location.href='watch.php?id=<?php echo $content['id']; ?>'">
                                <img src="<?php echo htmlspecialchars($content['thumbnail']); ?>" alt="<?php echo htmlspecialchars($content['title']); ?>">
                                <div class="age-badge"><?php echo $content['age_rating']; ?>+</div>
                                <div class="content-overlay">
                                    <div class="content-overlay-title"><?php echo htmlspecialchars($content['title']); ?></div>
                                    <div class="content-overlay-meta">By <?php echo htmlspecialchars($content['author']); ?></div>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>
                <?php endif; ?>
            <?php endforeach; ?>
        <?php else: ?>
            <div class="content-section">
                <h2 class="section-title">Search Results for "<?php echo htmlspecialchars($search); ?>"</h2>
                <?php if (!empty($search_results)): ?>
                    <div class="search-grid">
                        <?php foreach($search_results as $content): ?>
                            <div class="search-card" onclick="window.location.href='watch.php?id=<?php echo $content['id']; ?>'">
                                <img src="<?php echo htmlspecialchars($content['thumbnail']); ?>" alt="<?php echo htmlspecialchars($content['title']); ?>">
                                <div class="age-badge"><?php echo $content['age_rating']; ?>+</div>
                                <div class="search-overlay-card">
                                    <div class="content-overlay-title"><?php echo htmlspecialchars($content['title']); ?></div>
                                    <div class="content-overlay-meta">By <?php echo htmlspecialchars($content['author']); ?></div>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                <?php else: ?>
                    <div class="empty-state">
                        <div class="empty-icon">🔍</div>
                        <h3>No results found</h3>
                        <p>Try adjusting your search terms</p>
                    </div>
                <?php endif; ?>
            </div>
        <?php endif; ?>
        
        <?php if (empty($content_by_category) && empty($search)): ?>
        <div class="empty-state">
            <div class="empty-icon">🎬</div>
            <h3>No content available</h3>
            <p>Be the first to upload content!</p>
            <a href="make.php" style="display: inline-block; margin-top: 1rem; background: var(--text-primary); color: var(--bg-primary); padding: 0.75rem 1.5rem; border-radius: 25px; text-decoration: none; font-weight: 500;">Upload Content</a>
        </div>
        <?php endif; ?>
    </main>
    
    <div class="profile-modal" id="profileModal">
        <div class="profile-modal-content">
            <h2 class="modal-title">Who's here for more?</h2>
            <div class="profiles-grid">
                <?php foreach($profiles as $profile): ?>
                    <form method="POST" style="display: contents;">
                        <input type="hidden" name="profile_id" value="<?php echo $profile['id']; ?>">
                        <button type="submit" name="select_profile" class="profile-item <?php echo $profile['id'] == $selected_profile['id'] ? 'active' : ''; ?>">
                            <div class="profile-avatar">
                                <img src="<?php echo htmlspecialchars($profile['avatar']); ?>" alt="<?php echo htmlspecialchars($profile['name']); ?>">
                            </div>
                            <div class="profile-name"><?php echo htmlspecialchars($profile['name']); ?></div>
                        </button>
                    </form>
                <?php endforeach; ?>
                
                <button class="profile-item add-profile" onclick="window.location.href='settings.php'">
                    <div class="add-profile-icon">+</div>
                    <div class="profile-name">Add Profile</div>
                </button>
            </div>
            <button onclick="closeProfileModal()" class="close-modal">Continue</button>
        </div>
    </div>

    <footer class="footer">
        <div class="footer-content">
            <div>
                <h3 class="footer-brand">formore</h3>
                <p class="footer-text">The new streaming.</p>
            </div>
            <div>
                <a href="https://imators.com/terms-of-use" class="footer-link">Terms of Service</a>
                <a href="https://imators.com/privacy" class="footer-link">Privacy Policy</a>
            </div>
            <div>
                <p class="footer-text">&copy; <?php echo date('Y'); ?> formore is a product of Imators LLC. All rights reserved.</p>
            </div>
        </div>
    </footer>
    
    <script>
        const allContent = <?php echo json_encode($all_content); ?>;

        function toggleDarkMode() {
            const html = document.documentElement;
            const isDark = html.classList.toggle('dark');
            localStorage.setItem('theme', isDark ? 'dark' : 'light');
            updateThemeIcon();
        }

        function updateThemeIcon() {
            const icon = document.getElementById('themeIcon');
            const isDark = document.documentElement.classList.contains('dark');
            icon.className = isDark ? 'fas fa-sun' : 'fas fa-moon';
        }

        function initTheme() {
            const saved = localStorage.getItem('theme');
            const prefersDark = window.matchMedia('(prefers-color-scheme: dark)').matches;
            const isDark = saved === 'dark' || (saved === null && prefersDark);
            
            if (isDark) {
                document.documentElement.classList.add('dark');
            }
            updateThemeIcon();
        }

        function openSearchOverlay() {
            document.getElementById('searchOverlay').classList.add('active');
            document.getElementById('overlaySearchInput').focus();
        }

        function closeSearchOverlay() {
            document.getElementById('searchOverlay').classList.remove('active');
        }

        function handleSearchOverlay(query) {
            const resultsContainer = document.getElementById('searchResults');
            
            if (!query.trim()) {
                resultsContainer.innerHTML = '';
                return;
            }

            const q = query.toLowerCase();
            const filtered = allContent.filter(item => 
                item.title.toLowerCase().includes(q) ||
                item.author.toLowerCase().includes(q)
            );

            if (filtered.length === 0) {
                resultsContainer.innerHTML = '<div style="padding: 2rem; text-align: center; color: var(--text-secondary);">Aucun résultat</div>';
                return;
            }

            resultsContainer.innerHTML = filtered.map(item => `
                <div class="search-result-item" onclick="window.location.href='watch.php?id=${item.id}'">
                    <div class="search-result-title">${item.title}</div>
                    <div class="search-result-meta">By ${item.author}</div>
                </div>
            `).join('');
        }

        function openProfileModal() {
            document.getElementById('profileModal').classList.add('active');
            document.body.style.overflow = 'hidden';
        }
        
        function closeProfileModal() {
            document.getElementById('profileModal').classList.remove('active');
            document.body.style.overflow = 'auto';
        }
        
        document.getElementById('profileModal').addEventListener('click', function(e) {
            if (e.target === this) {
                closeProfileModal();
            }
        });

        document.getElementById('searchOverlay').addEventListener('click', function(e) {
            if (e.target === this) {
                closeSearchOverlay();
            }
        });
        
        document.addEventListener('keydown', function(e) {
            if (e.key === 'Escape') {
                closeProfileModal();
                closeSearchOverlay();
            }
        });
        
        document.querySelectorAll('.content-carousel').forEach(carousel => {
            let isDown = false;
            let startX;
            let scrollLeft;
            
            carousel.addEventListener('mousedown', (e) => {
                isDown = true;
                startX = e.pageX - carousel.offsetLeft;
                scrollLeft = carousel.scrollLeft;
            });
            
            carousel.addEventListener('mouseleave', () => {
                isDown = false;
            });
            
            carousel.addEventListener('mouseup', () => {
                isDown = false;
            });
            
            carousel.addEventListener('mousemove', (e) => {
                if (!isDown) return;
                e.preventDefault();
                const x = e.pageX - carousel.offsetLeft;
                const walk = (x - startX) * 2;
                carousel.scrollLeft = scrollLeft - walk;
            });
        });

        initTheme();
    </script>
</body>
</html>