<?php
$lang = isset($_GET['lang']) ? $_GET['lang'] : 'en';

$translations = [
    'en' => [
        'title' => 'AktasHome Resort - Exclusive Invitation Only',
        'welcome' => 'Welcome to aktashome Resort',
        'subtitle' => 'An exclusive retreat reserved by invitation only at the Roosvelt Neighborhood in Brussels',
        'invitation_notice' => 'This resort is available by invitation only',
        'about_title' => 'About AktasHome Resort',
        'about_text' => 'AktasHome Resort offers an unparalleled luxury experience in a breathtaking natural setting. Our exclusive resort combines modern amenities with traditional hospitality to create unforgettable memories for our invited guests.',
        'facilities_title' => 'Our Exclusive Facilities',
        'cinema' => 'Private Cinema',
        'cinema_desc' => 'State-of-the-art cinema for private screenings',
        'assistance' => '24/7 Assistance Service',
        'assistance_desc' => 'Round-the-clock personalised assistance',
        'dining' => 'Fine Dining',
        'dining_desc' => 'Exquisite cuisine from renowned chefs',
        'spa' => 'Wellness & Spa',
        'spa_desc' => 'Rejuvenating treatments and wellness programmes',
        'breakfast_title' => 'Breakfast Service',
        'breakfast_hours' => 'Breakfast served daily from 07:00 to 11:45',
        'location_title' => 'Prime Location',
        'location_text' => 'Nestled in a pristine location, AktasHome Resort provides easy access to local attractions whilst maintaining the tranquillity of a private retreat.',
        'contact_title' => 'Contact Us',
        'request_invitation' => 'Request Invitation',
        'learn_more' => 'Learn More'
    ]
];

$t = $translations[$lang];
?>

<!DOCTYPE html>

<html lang="<?php echo $lang; ?>">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $t['title']; ?></title>
    <link rel="icon" type="image/png" href="ac.png">
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Raleway:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Raleway', sans-serif;
        }
    </style>
</head>
<body class="bg-white text-gray-900">
    <div class="max-w-4xl mx-auto px-6 py-12">
        <div class="text-center mb-16">
            <h1 class="text-4xl font-light mb-4">aktas home resort</h1>
            <p class="text-xl text-gray-600 mb-4"><?php echo $t['subtitle']; ?></p>
            <div class="bg-gray-100 text-gray-700 px-4 py-2 rounded text-sm mb-8 inline-block">
                <?php echo $t['invitation_notice']; ?>
            </div>
            <div class="w-24 h-px bg-gray-300 mx-auto"></div>
        </div>

    <div class="mb-16">
        <h2 class="text-2xl font-light mb-6 text-center"><?php echo $t['about_title']; ?></h2>
        <p class="text-gray-600 leading-relaxed text-center max-w-3xl mx-auto">
            <?php echo $t['about_text']; ?>
        </p>
    </div>

    <div class="mb-16">
        <h2 class="text-2xl font-light mb-12 text-center"><?php echo $t['facilities_title']; ?></h2>
        
        <div class="grid md:grid-cols-2 gap-8">
            <div class="text-center py-8">
                <h3 class="text-lg font-medium mb-2"><?php echo $t['cinema']; ?></h3>
                <p class="text-gray-600 text-sm"><?php echo $t['cinema_desc']; ?></p>
            </div>

            <div class="text-center py-8">
                <h3 class="text-lg font-medium mb-2"><?php echo $t['assistance']; ?></h3>
                <p class="text-gray-600 text-sm"><?php echo $t['assistance_desc']; ?></p>
            </div>

            <div class="text-center py-8">
                <h3 class="text-lg font-medium mb-2"><?php echo $t['dining']; ?></h3>
                <p class="text-gray-600 text-sm"><?php echo $t['dining_desc']; ?></p>
            </div>

            <div class="text-center py-8">
                <h3 class="text-lg font-medium mb-2"><?php echo $t['spa']; ?></h3>
                <p class="text-gray-600 text-sm"><?php echo $t['spa_desc']; ?></p>
            </div>
        </div>
    </div>

    <div class="mb-16">
        <h2 class="text-2xl font-light mb-6 text-center"><?php echo $t['breakfast_title']; ?></h2>
        <p class="text-gray-600 text-center font-medium">
            <?php echo $t['breakfast_hours']; ?>
        </p>
    </div>

    <div class="mb-16">
        <h2 class="text-2xl font-light mb-6 text-center"><?php echo $t['location_title']; ?></h2>
        <p class="text-gray-600 leading-relaxed text-center max-w-3xl mx-auto">
            <?php echo $t['location_text']; ?>
        </p>
    </div>

    <div class="text-center">
        <h2 class="text-2xl font-light mb-8"><?php echo $t['contact_title']; ?></h2>
        <div class="space-y-4">
            <button class="bg-black text-white px-8 py-3 rounded hover:bg-gray-800 transition-colors mr-4">
                <?php echo $t['request_invitation']; ?>
            </button>
            <button class="border border-gray-300 text-gray-700 px-8 py-3 rounded hover:bg-gray-50 transition-colors">
                <?php echo $t['learn_more']; ?>
            </button>
        </div>
    </div>
</div>

</body>
</html>