<!DOCTYPE html>
<html lang="en" class="h-full">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Header - Imators</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap');
        :root {
            --primary-color: #3B82F6;
            --secondary-color: #10B981;
        }
        body {
            font-family: 'Inter', sans-serif;
            color: #FFFFFF;
            background-color: #111827;
        }
        .header {
            background-color: rgba(0, 0, 0, 0.8);
            backdrop-filter: blur(10px);
            transition: all 0.3s ease;
            z-index: 1002;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.3);
        }
        .desktop-menu { display: none; }
        @media (min-width: 1024px) {
            .desktop-menu {
                display: flex;
            }
            .hamburger {
                display: none;
            }
            .desktop-menu-item {
                position: relative;
                padding: 1rem;
                cursor: pointer;
                color: #FFFFFF;
                font-weight: 500;
            }
            .desktop-submenu {
                position: absolute;
                top: 100%;
                left: 0;
                background-color: #1a1a1a;
                min-width: 200px;
                border-radius: 8px;
                box-shadow: 0 4px 12px rgba(0, 0, 0, 0.2);
                opacity: 0;
                visibility: hidden;
                transform: translateY(10px);
                transition: all 0.3s ease;
            }
            .desktop-menu-item:hover .desktop-submenu {
                opacity: 1;
                visibility: visible;
                transform: translateY(0);
            }
            .desktop-submenu a {
                display: block;
                padding: 0.75rem 1rem;
                color: #FFFFFF;
                transition: all 0.2s ease;
            }
            .desktop-submenu a:hover {
                background-color: rgba(255, 255, 255, 0.1);
                transform: translateX(5px);
            }
        }
        .hamburger {
            width: 30px;
            height: 20px;
            position: relative;
            cursor: pointer;
            z-index: 1003;
        }
        .hamburger span {
            display: block;
            position: absolute;
            height: 3px;
            width: 100%;
            background: #FFFFFF;
            border-radius: 9px;
            opacity: 1;
            left: 0;
            transform: rotate(0deg);
            transition: .25s ease-in-out;
        }
        .hamburger span:nth-child(1) { top: 0px; }
        .hamburger span:nth-child(2) { top: 10px; }
        .hamburger.open span:nth-child(1) {
            top: 10px;
            transform: rotate(135deg);
        }
        .hamburger.open span:nth-child(2) {
            top: 10px;
            transform: rotate(-135deg);
        }
        .menu {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.95);
            padding-top: 80px;
            z-index: 1001;
            display: none;
            overflow-y: auto;
            -webkit-overflow-scrolling: touch;
        }
        .menu.active { display: block; }
        .menu-item {
            font-size: 24px;
            color: white;
            margin: 16px 24px;
            padding: 12px;
            cursor: pointer;
            transition: all 0.3s;
            border-radius: 12px;
        }
        .menu-item:active {
            background-color: rgba(255, 255, 255, 0.1);
            transform: scale(0.98);
        }
        .submenu {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.95);
            padding-top: 80px;
            z-index: 1001;
            display: none;
            overflow-y: auto;
            -webkit-overflow-scrolling: touch;
            transform: translateX(100%);
            transition: transform 0.3s ease-in-out;
        }
        .submenu.active {
            display: block;
            transform: translateX(0);
        }
        .back-to-menu {
            position: fixed;
            top: 20px;
            left: 20px;
            color: white;
            font-size: 16px;
            cursor: pointer;
            transition: all 0.3s;
            padding: 8px 16px;
            border-radius: 20px;
            background-color: rgba(255, 255, 255, 0.1);
            display: flex;
            align-items: center;
            gap: 8px;
        }
        .back-to-menu:active {
            transform: scale(0.95);
            background-color: rgba(255, 255, 255, 0.2);
        }
        .submenu a {
            display: block;
            font-size: 20px;
            color: white;
            margin: 12px 24px;
            padding: 12px;
            text-decoration: none;
            transition: all 0.3s;
            border-radius: 12px;
        }
        .submenu a:active {
            background-color: rgba(255, 255, 255, 0.1);
            transform: translateX(5px);
        }
        .dropdown {
            position: relative;
        }
        .dropdown-content {
            display: none;
            position: absolute;
            right: 0;
            background-color: #1a1a1a;
            min-width: 160px;
            box-shadow: 0px 8px 16px rgba(0, 0, 0, 0.2);
            z-index: 1;
            border-radius: 8px;
            overflow: hidden;
        }
        .dropdown:hover .dropdown-content { display: block; }
        .dropdown-content a {
            color: #fff;
            padding: 12px 16px;
            text-decoration: none;
            display: block;
            transition: all 0.3s ease;
        }
        .dropdown-content a:hover {
            background-color: #575757;
            transform: translateX(5px);
        }
        html { scroll-behavior: smooth; }
        
        @media (max-width: 640px) {
            .menu-item {
                font-size: 20px;
                margin: 8px 16px;
            }
            .submenu a {
                font-size: 18px;
                margin: 8px 16px;
            }
        }
    </style>
</head>
<body class="h-full">

<header class="header fixed w-full transition-all duration-300" style="top: 0;">
    <nav class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="flex justify-between items-center h-16 md:h-20">
            <div class="flex-shrink-0 flex items-center">
                <a href="/fr" class="flex items-center">
                    <img src="https://cdn.imators.com/logo.png" alt="Logo Imators" class="h-6 w-auto md:h-8">
                </a>
            </div>

            <div class="desktop-menu items-center space-x-6">
 <div class="desktop-menu-item">
 Produits
 <div class="desktop-submenu">
 <a href="/fr/progm">Progm</a>
 <a href="https://ohmypanel.com">OhMyPanel</a>
 <a href="https://owtiftt.com">Owtfitt</a>
 <a href="https://formore.tv">ForMore</a>
 <a href="https://gemance.com">Gemance</a>
 </div>
 </div>
 <div class="desktop-menu-item">
 Outils de d&eacute;veloppeur
 <div class="desktop-submenu">
 <a href="https://imators.systems">Syst&egrave;mes Imators</a>
 <a href="https://developer.imators.com">D&eacute;veloppeur d'imateurs</a>
 </div>
 </div>
 <div class="desktop-menu-item">
 L'entreprise
 <div class="desktop-submenu">
 <a href="/fr/about-us">&Agrave; propos d'Imators</a>
 <a href="/fr/contact-us">Support Client</a>
 </div>
 </div>
 </div>

            <div class="flex items-center space-x-2 sm:space-x-4">
                <a href="https://idsma.imators.com/language/fr" class="bg-gradient-to-r from-primary-color to-secondary-color text-white px-4 sm:px-6 py-2 sm:py-3 rounded-full text-sm font-medium transition-all duration-300 ease-in-out transform hover:scale-105 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-primary-color shadow-lg">
                    Imators Account
                </a>
                <div class="relative dropdown">
                    <button id="language-button" class="bg-white text-black text-sm px-3 sm:px-4 py-2 rounded-full shadow hover:bg-gray-100 transition-all font-medium">
                        EN
                    </button>
                    <div class="dropdown-content">
                        <a href="/fr">Français</a>
                        <a href="/nl">Nederlands</a>
                        <a href="/de">Deutsch</a>
                        <a href="/">English</a>
                    </div>
                </div>
                <button id="hamburger" class="hamburger lg:hidden">
                    <span></span>
                    <span></span>
                </button>
            </div>
        </div>
    </nav>
</header>

<div class="menu lg:hidden">
 <div class="menu-items">
 <div class="menu-item" data-submenu="products">Produits</div>
 <div class="menu-item" data-submenu="dev-tools">Outils de d&eacute;veloppeur</div>
 <div class="menu-item" data-submenu="company">L'entreprise</div>
 </div>
</div>

<div class="submenu" id="products">
 <div class="back-to-menu">
 <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
 <path d="M15 18l-6-6 6-6" />
 </svg>
 Back
 </div>
 <a href="/progm">Progm</a>
 <a href="https://ohmypanel.com">OhMyPanel</a>
 <a href="https://owtiftt.com">Owtfitt</a>
 <a href="https://formore.tv">ForMore</a>
 <a href="https://gemance.com">Gemance</a>
</div>

<div class="submenu" id="dev-tools">
 <div class="back-to-menu">
 <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
 <path d="M15 18l-6-6 6-6" />
 </svg>
 Back
 </div>
 <a href="https://imators.systems">Syst&egrave;mes Imators</a>
 <a href="https://developer.imators.com">Espace D&eacute;veloppeur</a>
</div>

<div class="submenu" id="company">
 <div class="back-to-menu">
 <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
 <path d="M15 18l-6-6 6-6" />
 </svg>
 Back
 </div>
 <a href="/about-us">A propos d'Imators</a>
 <a href="/contact-us">Support client</a>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const hamburger = document.getElementById('hamburger');
    const menu = document.querySelector('.menu');
    const header = document.querySelector('.header');
    const menuItems = document.querySelectorAll('.menu-item');
    const submenus = document.querySelectorAll('.submenu');
    const backButtons = document.querySelectorAll('.back-to-menu');
    const languageBanner = document.getElementById('language-banner');

    let currentSubmenu = null;

    hamburger.addEventListener('click', function() {
        this.classList.toggle('open');
        menu.classList.toggle('active');
        if (currentSubmenu) {
            currentSubmenu.classList.remove('active');
            currentSubmenu = null;
        }
        document.body.style.overflow = menu.classList.contains('active') ? 'hidden' : '';
    });

    menuItems.forEach(item => {
        item.addEventListener('click', function() {
            const submenuId = this.getAttribute('data-submenu');
            const submenu = document.getElementById(submenuId);
            menu.style.display = 'none';
            submenu.classList.add('active');
            currentSubmenu = submenu;
        });
    });

    backButtons.forEach(button => {
        button.addEventListener('click', function(e) {
            e.preventDefault();
            const submenu = this.closest('.submenu');
            submenu.classList.remove('active');
            menu.style.display = 'block';
            currentSubmenu = null;
        });
    });

    let lastScrollTop = 0;
    let scrollTimeout;

    window.addEventListener('scroll', () => {
        clearTimeout(scrollTimeout);
        const scrollTop = window.pageYOffset || document.documentElement.scrollTop;
        
        if (scrollTop > 0) {
            header.style.backgroundColor = 'rgba(0, 0, 0, 0.9)';
        } else {
            header.style.backgroundColor = 'rgba(0, 0, 0, 0.8)';
        }

        if (!menu.classList.contains('active') && !currentSubmenu?.classList.contains('active')) {
            if (Math.abs(scrollTop - lastScrollTop) > 50) {
                if (scrollTop > lastScrollTop && scrollTop > header.offsetHeight) {
                    header.style.transform = 'translateY(-100%)';
                } else {
                    header.style.transform = 'translateY(0)';
                }
                lastScrollTop = scrollTop;
            }
        }

        scrollTimeout = setTimeout(() => {
            header.style.transform = 'translateY(0)';
        }, 1000);
    });

    async function checkUserLocation() {
        try {
            const response = await fetch('https://ipinfo.io?token=5763340b2576b8');
            const data = await response.json();
            const country = data.country;
            
            const messages = {
                FR: {
                    text: 'Nous avons détecté que vous êtes en France. Souhaitez-vous visiter la version française du site ?',
                    yes: 'Oui',
                    no: 'Non',
                    lang: 'fr'
                },
                BE: {
                    text: 'We hebben gedetecteerd dat u zich in België bevindt. Wilt u de Nederlandse versie van de website bezoeken?',
                    yes: 'Ja',
                    no: 'Nee',
                    lang: 'nl'
                },
                NL: {
                    text: 'We hebben gedetecteerd dat u zich in Nederland bevindt. Wilt u de Nederlandse versie van de website bezoeken?',
                    yes: 'Ja',
                    no: 'Nee',
                    lang: 'nl'
                },
                DE: {
                    text: 'Wir haben erkannt, dass Sie sich in Deutschland befinden. Möchten Sie die deutsche Version der Website besuchen?',
                    yes: 'Ja',
                    no: 'Nein',
                    lang: 'de'
                }
            };
            
            const countrySettings = messages[country];
            
            if (countrySettings) {
                document.getElementById('language-text').textContent = countrySettings.text;
                document.querySelector('[onclick="redirectToLocalSite()"]').textContent = countrySettings.yes;
                document.querySelector('[onclick="closeBanner()"]').textContent = countrySettings.no;
                window.targetLang = countrySettings.lang;
                languageBanner.style.transform = 'translateY(0)';
                header.style.top = languageBanner.offsetHeight + 'px';
            }
        } catch (error) {
            console.error('Error:', error);
        }
    }

    window.redirectToLocalSite = function() {
        if (window.targetLang) {
            window.location.href = '/' + window.targetLang;
        }
    }

    window.closeBanner = function() {
        languageBanner.style.transform = 'translateY(-100%)';
        header.style.top = '0';
        localStorage.setItem('bannerDismissed', 'true');
    }

    if (!localStorage.getItem('bannerDismissed')) {
        checkUserLocation();
    }

    const languageButton = document.getElementById('language-button');
    
    async function setLanguageButtonText() {
        try {
            const response = await fetch('https://ipinfo.io?token=5763340b2576b8');
            const data = await response.json();
            const country = data.country;

            const buttonText = {
                FR: 'FR',
                BE: 'BE',
                NL: 'NL',
                DE: 'DE'
            };

            languageButton.innerText = buttonText[country] || 'EN';
        } catch (error) {
            console.error('Error retrieving location data:', error);
        }
    }

    setLanguageButtonText();

    document.addEventListener('touchstart', handleTouchStart, false);
    document.addEventListener('touchmove', handleTouchMove, false);

    let xDown = null;
    let yDown = null;

    function handleTouchStart(evt) {
        xDown = evt.touches[0].clientX;
        yDown = evt.touches[0].clientY;
    }

    function handleTouchMove(evt) {
        if (!xDown || !yDown) {
            return;
        }

        const xUp = evt.touches[0].clientX;
        const yUp = evt.touches[0].clientY;

        const xDiff = xDown - xUp;
        const yDiff = yDown - yUp;

        if (Math.abs(xDiff) > Math.abs(yDiff)) {
            if (xDiff > 0) {
                // Swipe left
            } else {
                // Swipe right
                if (currentSubmenu?.classList.contains('active')) {
                    currentSubmenu.classList.remove('active');
                    menu.style.display = 'block';
                    currentSubmenu = null;
                }
            }
        }

        xDown = null;
        yDown = null;
    }
});
</script>
</body>
</html>