function sendConfirmationEmail($email, $nom, $prenom, $demande) {
    // Encodage des caractères spéciaux dans les noms
    $nom = '=?UTF-8?B?' . base64_encode($nom) . '?=';
    $prenom = '=?UTF-8?B?' . base64_encode($prenom) . '?=';
    
    $to = $email;
    $subject = '=?UTF-8?B?' . base64_encode(EMAIL_SUBJECT) . '?=';
    
    $message = '<html><body style="background-color:#181818; color:#c9d1d9; font-family: Arial, sans-serif; margin:0; padding:0;">';
    $message .= '<table role="presentation" style="width:100%; border-collapse:collapse; margin:0 auto; max-width:600px;">';
    $message .= '<tr><td style="background:#0d1117; padding:20px 0; text-align:center;">';
    $message .= '<img src="https://cdn.imators.com/logo.png" alt="Imators Logo" style="height:50px;">';
    $message .= '</td></tr>';
    $message .= '<tr><td style="padding:40px 20px; text-align:center; background-color:#21262d;">';
    $message .= '<h1 style="color:#f0f6fc; font-size:28px; font-weight:bold; margin-bottom:20px;">Support Request Confirmation</h1>';
    $message .= '<p style="color:#c9d1d9; font-size:18px; margin-top:10px; line-height:1.5;">Dear ' . htmlspecialchars($prenom) . ' ' . htmlspecialchars($nom) . ',</p>';
    $message .= '<p style="color:#c9d1d9; font-size:18px; margin-top:10px; line-height:1.5;">We have received your support request. Our team will get back to you within 24 hours.</p>';
    $message .= '<p style="color:#c9d1d9; font-size:18px; margin-top:10px; line-height:1.5;">Your request:</p>';
    $message .= '<p style="color:#c9d1d9; font-size:16px; margin-top:10px; line-height:1.5; background-color:#2d333b; padding:15px; border-radius:5px;">' . nl2br(htmlspecialchars($demande)) . '</p>';
    $message .= '</td></tr>';
    $message .= '<tr><td style="padding:20px; text-align:center; background-color:#0d1117; color:#ffffff; font-size:16px;">';
    $message .= '<p>&copy; ' . date("Y") . ' Imators LLC. All rights reserved.</p>';
    $message .= '</td></tr>';
    $message .= '</table>';
    $message .= '</body></html>';

    // En-têtes améliorés
    $headers = array();
    $headers[] = 'MIME-Version: 1.0';
    $headers[] = 'Content-type: text/html; charset=UTF-8';
    $headers[] = 'From: ' . EMAIL_FROM;
    $headers[] = 'X-Mailer: PHP/' . phpversion();
    $headers[] = 'Reply-To: ' . EMAIL_FROM;
    
    // Ajout de logging pour le debug
    error_log("Attempting to send email to: " . $email);
    
    $result = mail($to, $subject, $message, implode("\r\n", $headers));
    
    // Log du résultat
    error_log("Email send result: " . ($result ? "Success" : "Failure"));
    
    return $result;
}

// Modification de la partie qui appelle sendConfirmationEmail
if (sendConfirmationEmail($email, $nom, $prenom, $demande)) {
    $_SESSION['support_success'] = 'Your support request has been received. Please check your email for confirmation.';
    error_log("Email confirmation success set in session");
} else {
    $_SESSION['support_error'] = 'There was an error processing your request. Please try again later.';
    error_log("Email send failed - error message set in session");
}