<!DOCTYPE html>
<html data-lt-installed="true" lang="fr">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Imators</title>
    <script>
        window.intercomSettings = {
            api_base: "https://api-iam.intercom.io",
            app_id: "iy90e1rt",
        };
    </script>
    <script>
        (function(){var w=window;var ic=w.Intercom;if(typeof ic==="function"){ic('reattach_activator');ic('update',w.intercomSettings);}else{var d=document;var i=function(){i.c(arguments);};i.q=[];i.c=function(args){i.q.push(args);};w.Intercom=i;var l=function(){var s=d.createElement('script');s.type='text/javascript';s.async=true;s.src='https://widget.intercom.io/widget/iy90e1rt';var x=d.getElementsByTagName('script')[0];x.parentNode.insertBefore(s,x);};if(document.readyState==='complete'){l();}else if(w.attachEvent){w.attachEvent('onload',l);}else{w.addEventListener('load',l,false);}}})();
    </script>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.1.2/dist/tailwind.min.css" rel="stylesheet" />
    <link href="https://fonts.googleapis.com/css2?family=Space+Grotesk:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link href="https://cdn.imators.com/logo.png" rel="icon" type="image/png" />
    <script src="https://cdn.jsdelivr.net/npm/alpinejs@2.2.19/dist/alpine.min.js" defer></script>
    <link href="https://fonts.googleapis.com/css2?family=Karla:wght@200&display=swap" rel="stylesheet">
    <meta name="description" content="Imators, founded in January 2024 by Izhak Aktas, is an innovative company specializing in the development of cutting-edge technologies.">
    <meta property="og:url" content="https://imators.com/progm">
    <meta property="og:type" content="website">
    <meta property="og:title" content="Imators - Progm">
    <meta property="og:description" content="Discover a new technological era by including good products and good means in your daily life with Imators">
    <meta property="og:image" content="https://opengraph.b-cdn.net/production/documents/d172e1b4-bb0f-43f1-8d53-3e621ff45f4d.png?token=666f0cdDa_ZLi24WisNPC35fxAOWa_mcSOkOE0dzTXg&height=630&width=1200&expires=33249085956">
    <meta name="twitter:card" content="summary_large_image">
    <meta property="twitter:domain" content="imators.com">
    <meta property="twitter:url" content="https://imators.com/progm">
    <meta name="twitter:title" content="Imators - Progm">
    <meta name="twitter:description" content="Discover a new technological era by including good products and good means in your daily life with Imators">
    <meta name="twitter:image" content="https://opengraph.b-cdn.net/production/documents/d172e1b4-bb0f-43f1-8d53-3e621ff45f4d.png?token=666f0cdDa_ZLi24WisNPC35fxAOWa_mcSOkOE0dzTXg&height=630&width=1200&expires=33249085956">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600;700&display=swap" rel="stylesheet">
    <style>
        body {
            background-color: black;
            color: white;
            font-family: 'Poppins', sans-serif;
        }
        .gradient-background {
            background: linear-gradient(to bottom, #000000, #78a3cf);
            min-height: 100vh;
        }
        .video-frame {
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.3);
            border-radius: 16px;
            overflow: hidden;
            border: 1px solid rgba(255, 255, 255, 0.1);
        }
        .header-spacer {
            height: 64px;
        }
        .content-wrapper {
            padding-top: 20vh;
        }
        mac {
            font-family: -apple-system, BlinkMacSystemFont, sans-serif;
        }
    </style>
</head>
<body class="min-h-screen flex flex-col justify-between">
    <?php include 'src/header.php'; ?>
    <div class="gradient-background flex-grow flex flex-col items-center justify-center">
        <div class="content-wrapper container mx-auto px-4 py-12 text-center">
            <h1 class="text-5xl mb-6 tracking-tight mt-24 text-white">Progm</h1>
            <h1 class="text-sm mb-6 text-white">More than <span class="text-green-200">3562 installations</span></h1>
            <p class="text-xl mb-8 font-light text-white max-w-2xl mx-auto">A simple, modern organizer for more structured days on the computer</p>
            <div class="flex justify-center space-x-4 mb-12">
                <a href="https://cdn.imators.com/ProgmInstaller.exe" download class="bg-blue-500 text-white font-semibold py-3 px-8 rounded-full hover:bg-opacity-90 transition duration-300 ease-in-out transform hover:scale-105 inline-block">
                    Download for Windows
                </a>
		

            </div>
            <div class="video-container w-full max-w-4xl mx-auto">
                <div class="aspect-video w-full video-frame">
                    <video class="w-full h-full object-cover" autoplay loop muted playsinline>
                        <source src="https://cdn.imators.com/Progm.mp4" type="video/mp4">
                        Votre navigateur ne supporte pas la balise vid&eacute;o.
                    </video>
                </div>
            </div>
        </div>
    </div>

    <div class="fixed bottom-0 left-0 right-0 mx-4 sm:mx-6 md:mx-8 mb-4 sm:mb-6 p-4 sm:p-5 bg-black text-white rounded-lg shadow-xl z-50 opacity-0 translate-y-8 transition-all duration-500 ease-out" id="cookieBox">
  <div class="container mx-auto flex flex-col sm:flex-row justify-between items-center gap-4">
    <div class="text-sm md:text-base font-light leading-relaxed max-w-3xl">
    Our site uses only the essential cookies required for the site to function properly. No information is passed on to third parties. To find out more about the essential information collected, <a href="./terms-of-use" class="underline">please read our terms of use<a>.
    </div>
    <button class="w-full sm:w-auto bg-white text-black px-6 py-2 rounded-full hover:bg-gray-100 transition-colors whitespace-nowrap text-sm font-medium" onclick="acceptCookies()">
    Accept
    </button>
  </div>
</div>

<script>
  function acceptCookies() {
    const cookieBox = document.getElementById('cookieBox');
    cookieBox.classList.add('opacity-0', 'translate-y-8');
    
    setTimeout(() => {
      cookieBox.style.display = 'none';
      localStorage.setItem('cookiesAccepted', 'true');
    }, 500);
  }

  window.onload = function() {
    const cookieBox = document.getElementById('cookieBox');
    
    if (localStorage.getItem('cookiesAccepted') === 'true') {
      cookieBox.style.display = 'none';
    } else {
      setTimeout(() => {
        cookieBox.classList.remove('opacity-0', 'translate-y-8');
      }, 2000);
    }
  }
</script>

    <footer class="bg-black text-white"><div class="max-w-6xl mx-auto px-4 py-6 flex flex-wrap justify-between">
    <div class="w-full md:w-1/3 p-4">
        <h5 class="text-xs uppercase font-medium mb-4">Need Help?</h5>
        <a href="/support" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
            Support
        </a>
        <a href="/contact-us" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
            Contact Us
        </a>
    </div>
    <div class="w-full md:w-1/3 p-4">
        <h5 class="text-xs uppercase font-medium mb-4">Discover</h5>
        <a href="/privacy" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
            Privacy Policy
        </a>
        <a href="/terms-of-use" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
            Terms of Use
        </a>
        <a href="/refund-policy" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
            Refund Policy
        </a>
        <a href="/legal-notice" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
            Legal Notice
        </a>
        <a href="/" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
            Home
        </a>
        <a href="/about-us" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
            About Us
        </a>
    </div>
    <div class="w-full md:w-1/3 p-4">
        <h5 class="text-xs uppercase font-medium mb-4">Because it's possible</h5>
        <p class="text-sm">
            All images, videos, and content on this site are the property of Imators.
        </p>
    </div>
</div>

<div class="text-center py-3 border-t border-gray-800">
    <p class="text-sm">
        &copy; <?php echo date("Y"); ?> Imators. All rights reserved.
    </p>
    <p class="text-xs mt-2">
        <a href="https://aktascorp.com">Imators is a aktascorp members.</a>
    </p>
    <p class="text-xs">
        Imators is a registered LLC. All our products are subject to our terms.
    </p>
</div></footer>
</body>
</html>