<?php
$lang = $_GET['lang'] ?? 'en';
if (!in_array($lang, ['en', 'fr', 'ar', 'nl', 'de'])) {
    $lang = 'en';
}

$translations = json_decode(file_get_contents('translations.json'), true)[$lang];
?>
<!DOCTYPE html>
<html lang="<?php echo $lang; ?>">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Support - Imators</title>
    <link href="https://cdn.imators.com/logo.png" rel="icon" type="image/png" />
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/tailwindcss@2.1.2/dist/tailwind.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Space+Grotesk:wght@300;400;500;600;700&display=swap');
        body {
            font-family: 'Space Grotesk', sans-serif;
            background-color: #000000;
            color: #FFFFFF;
        }
        
        header {
            background-color: rgba(0, 0, 0, 0.8);
        }
        
        .separator {
            height: 1px;
            background-color: #333;
            width: 100%;
            margin: 30px 0;
        }
        
        a.text-link {
            position: relative;
            color: #FFFFFF;
            text-decoration: none;
            padding-bottom: 2px;
        }
        
        a.text-link::after {
            content: '';
            position: absolute;
            width: 100%;
            height: 1px;
            bottom: 0;
            left: 0;
            background-color: #FFFFFF;
            transform: scaleX(0);
            transform-origin: bottom right;
            transition: transform 0.3s;
        }
        
        a.text-link:hover::after {
            transform: scaleX(1);
            transform-origin: bottom left;
        }
    </style>
</head>
<body>
    <?php include 'src/header.php'; ?>

    <div class="w-full h-64 md:h-80 lg:h-96 overflow-hidden">
        <img src="banner_color.png" alt="Support Banner" class="w-full h-full object-cover">
    </div>
    
    <div class="container px-4 mx-auto py-12">
        <h1 class="text-4xl font-light mb-6"><?php echo $translations['support_title']; ?></h1>
        <p class="text-xl text-gray-400 mb-12"><?php echo $translations['support_subtitle']; ?></p>
        
        <div class="separator"></div>
        
        <div class="py-6 flex flex-wrap items-center">
            <div class="w-full md:w-1/4 mb-4 md:mb-0">
                <h3 class="text-xl font-light"><?php echo $translations['hardware_support']; ?></h3>
            </div>
            <div class="w-full md:w-2/4 mb-4 md:mb-0">
                <p class="text-gray-400"><?php echo $translations['hardware_desc']; ?></p>
                <p class="text-sm text-gray-500 mt-2"><?php echo $translations['account_required']; ?></p>
            </div>
            <div class="w-full md:w-1/4 text-right">
                <a href="https://idsma.imators.com" class="text-link"><?php echo $translations['access_support_portal']; ?></a>
            </div>
        </div>
        
        <div class="separator"></div>
        
        <div class="py-6 flex flex-wrap items-center">
            <div class="w-full md:w-1/4 mb-4 md:mb-0">
                <h3 class="text-xl font-light"><?php echo $translations['press_inquiries']; ?></h3>
            </div>
            <div class="w-full md:w-2/4 mb-4 md:mb-0">
                <p class="text-gray-400"><?php echo $translations['press_desc']; ?></p>
                <p class="text-sm text-gray-500 mt-2"><?php echo $translations['press_email']; ?></p>
            </div>
            <div class="w-full md:w-1/4 text-right">
                <a href="mailto:press@imators.com" class="text-link"><?php echo $translations['contact_press']; ?></a>
            </div>
        </div>
        
        <div class="separator"></div>
        
        <div class="py-6 flex flex-wrap items-center">
            <div class="w-full md:w-1/4 mb-4 md:mb-0">
                <h3 class="text-xl font-light"><?php echo $translations['technical_support']; ?></h3>
            </div>
            <div class="w-full md:w-2/4 mb-4 md:mb-0">
                <p class="text-gray-400"><?php echo $translations['technical_desc']; ?></p>
                <p class="text-sm text-gray-500 mt-2"><?php echo $translations['account_required']; ?></p>
            </div>
            <div class="w-full md:w-1/4 text-right">
                <a href="https://idsma.imators.com" class="text-link"><?php echo $translations['access_support_portal']; ?></a>
            </div>
        </div>
        
        <div class="separator"></div>
        
        <div class="py-6 flex flex-wrap items-center">
            <div class="w-full md:w-1/4 mb-4 md:mb-0">
                <h3 class="text-xl font-light"><?php echo $translations['community_forum']; ?></h3>
            </div>
            <div class="w-full md:w-2/4 mb-4 md:mb-0">
                <p class="text-gray-400"><?php echo $translations['community_desc']; ?></p>
            </div>
            <div class="w-full md:w-1/4 text-right">
                <a href="/forum" class="text-link"><?php echo $translations['visit_forum']; ?></a>
            </div>
        </div>
        
        <div class="separator"></div>
        
        <div class="py-10">
            <h2 class="text-2xl font-light mb-8"><?php echo $translations['quick_help']; ?></h2>
            
            <div class="flex flex-wrap">
                <div class="w-full md:w-1/2 mb-8 md:mb-0">
                    <h3 class="text-lg font-light mb-2"><?php echo $translations['knowledge_base']; ?></h3>
                    <p class="text-gray-400 mb-2"><?php echo $translations['kb_desc']; ?></p>
                    <a href="/kb" class="text-link"><?php echo $translations['explore_kb']; ?></a>
                </div>
                
                <div class="w-full md:w-1/2">
                    <h3 class="text-lg font-light mb-2"><?php echo $translations['downloads']; ?></h3>
                    <p class="text-gray-400 mb-2"><?php echo $translations['downloads_desc']; ?></p>
                    <a href="/downloads" class="text-link"><?php echo $translations['go_downloads']; ?></a>
                </div>
            </div>
            
            <div class="mt-10">
                <p class="text-gray-400 text-xl font-bold mb-4"><?php echo $translations['fastest_way']; ?> <a href="tel:+1 (417) 479-2581" class="underline">+1 (417) 479-2581</a></p>
            </div>
        </div>
        
        <div class="separator"></div>
        
        <div class="py-6">
            <h2 class="text-2xl font-light mb-6"><?php echo $translations['support_hours']; ?></h2>
            <p><?php echo $translations['support_everyday']; ?></p>
            <p class="text-gray-400 text-sm mt-2"><?php echo $translations['urgent_issues']; ?></p>
        </div>
    </div>

    <footer class="bg-black text-white"><div class="max-w-6xl mx-auto px-4 py-6 flex flex-wrap justify-between">
    <div class="w-full md:w-1/3 p-4">
        <h5 class="text-xs uppercase font-medium mb-4"><?php echo $translations['need_help']; ?></h5>
        <a href="/support" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
            <?php echo $translations['support']; ?>
        </a>
        <a href="/contact-us" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
            <?php echo $translations['contact_us']; ?>
        </a>
    </div>
    <div class="w-full md:w-1/3 p-4">
        <h5 class="text-xs uppercase font-medium mb-4"><?php echo $translations['discover']; ?></h5>
        <a href="/privacy" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
            <?php echo $translations['privacy_policy']; ?>
        </a>
        <a href="/terms-of-use" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
            <?php echo $translations['terms_of_use']; ?>
        </a>
        <a href="/refund-policy" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
            <?php echo $translations['refund_policy']; ?>
        </a>
        <a href="/legal-notice" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
            <?php echo $translations['legal_notice']; ?>
        </a>
        <a href="/" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
            <?php echo $translations['home']; ?>
        </a>
        <a href="/about-us" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
            <?php echo $translations['about_us']; ?>
        </a>
    </div>
    <div class="w-full md:w-1/3 p-4">
        <h5 class="text-xs uppercase font-medium mb-4"><?php echo $translations['because_possible']; ?></h5>
        <p class="text-sm">
            <?php echo $translations['all_images']; ?>
        </p>
    </div>
</div>

<div class="text-center py-3 border-t border-gray-800">
    <p class="text-sm">
        &copy; <?php echo date("Y"); ?> <?php echo $translations['copyright']; ?>
    </p>
    <p class="text-xs mt-2">
        <a href="https://aktascorp.com"><?php echo $translations['imators_aktascorp']; ?></a>
    </p>
    <p class="text-xs">
        <?php echo $translations['registered_llc']; ?>
    </p>
</div></footer>

    <script>
        document.getElementById('mobile-menu-button')?.addEventListener('click', function() {
            document.getElementById('mobile-menu')?.classList.remove('hidden');
        });
        
        document.getElementById('mobile-menu-close')?.addEventListener('click', function() {
            document.getElementById('mobile-menu')?.classList.add('hidden');
        });
    </script>
</body>
</html>