<?php
session_start();

define('EMAIL_FROM', 'Imators Support <no-reply@imators.com>');
define('EMAIL_SUBJECT', 'Imators Support');
define('REDIRECT_URL', '/success');

function cleanInput($data) {
    return htmlspecialchars(stripslashes(trim($data)));
}

function getUserIP() {
    if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
        return $_SERVER['HTTP_CLIENT_IP'];
    } elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
        return $_SERVER['HTTP_X_FORWARDED_FOR'];
    } else {
        return $_SERVER['REMOTE_ADDR'];
    }
}

function sendConfirmationEmail($email, $nom, $prenom, $demande) {
    $to = $email;
    $subject = EMAIL_SUBJECT;
    $message = '<html><body style="background-color:#181818; color:#c9d1d9; font-family: Arial, sans-serif; margin:0; padding:0;">' ;
    $message .= '<table role="presentation" style="width:100%; border-collapse:collapse; margin:0 auto; max-width:600px;">' ;
    
    // En-tête
    $message .= '<tr><td style="background:#0d1117; padding:20px 0; text-align:center;">' ;
    $message .= '<img src="https://cdn.imators.com/logo.png" alt="Logo Imators" style="height:50px;">' ;
    $message .= '</td></tr>' ;
    
    // Titre
    $message .= '<tr><td style="padding:40px 20px; text-align:center; background-color:#21262d;">' ;
    $message .= '<h1 style="color:#f0f6fc; font-size:28px; font-weight:bold; margin-bottom:20px;">Confirmation de la demande de soutien</h1>' ;
    
    // Contenu
    $message .= '<p style="color:#c9d1d9; font-size:18px; margin-top:10px; line-height:1.5;">Cher ' . $prenom . ' ' . $nom . ',</p>' ;
    $message .= '<p style="color:#c9d1d9; font-size:18px; margin-top:10px; line-height:1.5;">Nous avons bien reçu votre demande d'assistance. Notre équipe vous répondra dans les 24 heures.</p>' ;
    $message .= '<p style="color:#c9d1d9; font-size:18px; margin-top:10px; line-height:1.5;">Votre demande :</p>' ;
    $message .= '<p style="color:#c9d1d9; font-size:16px; margin-top:10px; line-height:1.5; background-color:#2d333b; padding:15px; border-radius:5px;">' . nl2br($demande) . '</p>' ;
    $message .= '</td></tr>' ;
    
    // Pied de page
    $message .= '<tr><td style="padding:20px; text-align:center; background-color:#0d1117; color:#ffffff; font-size:16px;">' ;
    $message .= '<p>&copy; ' . date("Y") . ' Imators LLC. All rights reserved.</p>' ;
    $message .= '</td></tr>' ;
    
    $message .= '</table>' ;
    $message .= '</body></html>';

    $headers = "MIME-Version: 1.0" . "\r\n";
    $headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
    $headers .= 'From: ' . EMAIL_FROM . "\r\n";

    return mail($to, $subject, $message, $headers);
}

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $nom = cleanInput($_POST['nom'] ?? '');
    $prenom = cleanInput($_POST['prenom'] ?? '');
    $email = cleanInput($_POST['email'] ?? '');
    $demande = cleanInput($_POST['demande'] ?? '');
    $ip = getUserIP();

    if (empty($nom) || empty($prenom) || empty($email) || empty($demande)) {
        $_SESSION['support_error'] = 'All fields are required.';
        header("Location: " . REDIRECT_URL);
        exit();
    }

    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $_SESSION['support_error'] = 'Invalid email address.';
        header("Location: " . REDIRECT_URL);
        exit();
    }

    if (sendConfirmationEmail($email, $nom, $prenom, $demande)) {
        $_SESSION['support_success'] = 'Your support request has been received. Please check your email for confirmation.';
    } else {
        $_SESSION['support_error'] = 'There was an error processing your request. Please try again later.';
    }

    header("Location: " . REDIRECT_URL);
    exit();
}

header("Location: " . REDIRECT_URL);
exit();
?>