<?php
if (isset($_POST['cookie_consent'])) {
    setcookie('cookie_consent', $_POST['cookie_consent'], time() + (365 * 24 * 60 * 60), '/');
    header('Location: index.php');
    exit;
}

function detectBrowserLanguage() {
    if (isset($_SERVER['HTTP_ACCEPT_LANGUAGE'])) {
        $browser_lang = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 2);
        $supported_langs = ['en', 'fr', 'it', 'es', 'ja', 'zh', 'ar'];
        return in_array($browser_lang, $supported_langs) ? $browser_lang : 'en';
    }
    return 'en';
}

$lang = isset($_GET['lang']) ? $_GET['lang'] : detectBrowserLanguage();

$texts = [
    'en' => [
        'title' => 'Cookie Policy',
        'subtitle' => 'Cookie and privacy management',
        'content' => 'This website (imators.com) uses cookies to analyze site usage for analytical purposes. Under no circumstances are they transmitted to third parties. These cookies contain visit detection, location detection (by country only and not precisely) and IP address, to allow the technical service to block access to a visitor if the latter is malicious. Location is also used in account connection services for identification of potentially threatening connections and email notification of account connections. Refusal does not in any way prevent the site from functioning. An approval request on connection services will nevertheless be requested again. The information collected by cookies is under no circumstances stored in our databases or recorded for personalization purposes.',
        'accept' => 'Accept',
        'refuse' => 'Refuse'
    ],
    'fr' => [
        'title' => 'Politique des Cookies',
        'subtitle' => 'Gestion des cookies et de la confidentialité',
        'content' => 'Ce site web (imators.com) utilise des cookies pour analyser l\'utilisation du site à des fins analytiques. En aucun cas ils ne sont transmis à des tiers. Ces cookies contiennent la détection de visite, de localisation (par pays uniquement et non précisément) et de l\'adresse IP, pour permettre au service technique de bloquer l\'accès à un visiteur si ce dernier est malveillant. La localisation est aussi utilisée dans les services de connexion au compte à des fins d\'identification de connexion potentiellement menaçante et d\'information par mail de connexion au compte. Le refus n\'empêche en aucun cas le fonctionnement du site. Une demande d\'approbation sur les services de connexion sera néanmoins redemandée. Les informations collectées par les cookies ne sont en aucun cas stockées dans nos bases de données ni enregistrées à des fins de personnalisation.',
        'accept' => 'Accepter',
        'refuse' => 'Refuser'
    ],
    'it' => [
        'title' => 'Politica sui Cookie',
        'subtitle' => 'Gestione dei cookie e della privacy',
        'content' => 'Questo sito web (imators.com) utilizza i cookie per analizzare l\'utilizzo del sito a fini analitici. In nessun caso vengono trasmessi a terzi. Questi cookie contengono il rilevamento delle visite, della localizzazione (solo per paese e non precisamente) e dell\'indirizzo IP, per consentire al servizio tecnico di bloccare l\'accesso a un visitatore se questo è malintenzionato. La localizzazione è utilizzata anche nei servizi di connessione all\'account per l\'identificazione di connessioni potenzialmente minacciose e per le notifiche via email delle connessioni all\'account. Il rifiuto non impedisce in alcun modo il funzionamento del sito. Una richiesta di approvazione sui servizi di connessione sarà comunque richiesta nuovamente. Le informazioni raccolte dai cookie non sono in nessun caso memorizzate nei nostri database né registrate per scopi di personalizzazione.',
        'accept' => 'Accetta',
        'refuse' => 'Rifiuta'
    ],
    'es' => [
        'title' => 'Política de Cookies',
        'subtitle' => 'Gestión de cookies y privacidad',
        'content' => 'Este sitio web (imators.com) utiliza cookies para analizar el uso del sitio con fines analíticos. En ningún caso se transmiten a terceros. Estas cookies contienen la detección de visitas, de localización (solo por país y no precisamente) y de dirección IP, para permitir al servicio técnico bloquear el acceso a un visitante si este es malicioso. La localización también se utiliza en los servicios de conexión a la cuenta para la identificación de conexiones potencialmente amenazantes e información por correo de conexión a la cuenta. El rechazo no impide de ninguna manera el funcionamiento del sitio. Una solicitud de aprobación en los servicios de conexión será sin embargo solicitada nuevamente. La información recopilada por las cookies no se almacena bajo ninguna circunstancia en nuestras bases de datos ni se registra con fines de personalización.',
        'accept' => 'Aceptar',
        'refuse' => 'Rechazar'
    ],
    'ja' => [
        'title' => 'クッキーポリシー',
        'subtitle' => 'クッキーとプライバシーの管理',
        'content' => 'このウェブサイト（imators.com）では、分析目的でサイトの利用状況を分析するためにクッキーを使用しています。いかなる場合も第三者に送信されることはありません。これらのクッキーには、訪問検知、位置情報（国単位のみで正確ではない）、およびIPアドレスが含まれており、技術サービスが悪意のある訪問者のアクセスをブロックできるようにします。位置情報は、潜在的に脅威となる接続の識別とアカウント接続のメール通知のため、アカウント接続サービスでも使用されます。拒否してもサイトの機能に支障はありません。接続サービスでの承認要求は再度求められます。クッキーによって収集された情報は、いかなる場合もデータベースに保存されることも、パーソナライゼーション目的で記録されることもありません。',
        'accept' => '受け入れる',
        'refuse' => '拒否する'
    ],
    'zh' => [
        'title' => 'Cookie政策',
        'subtitle' => 'Cookie和隐私管理',
        'content' => '本网站（imators.com）使用Cookie来分析网站使用情况以进行分析。在任何情况下都不会传输给第三方。这些Cookie包含访问检测、位置检测（仅按国家，不精确）和IP地址，以允许技术服务在访问者恶意时阻止其访问。位置信息还用于账户连接服务，用于识别潜在威胁性连接和账户连接的邮件通知。拒绝不会以任何方式阻止网站运行。连接服务的批准请求将再次被要求。Cookie收集的信息在任何情况下都不会存储在我们的数据库中，也不会为个性化目的而记录。',
        'accept' => '接受',
        'refuse' => '拒绝'
    ],
    'ar' => [
        'title' => 'سياسة ملفات تعريف الارتباط',
        'subtitle' => 'إدارة ملفات تعريف الارتباط والخصوصية',
        'content' => 'يستخدم هذا الموقع (imators.com) ملفات تعريف الارتباط لتحليل استخدام الموقع لأغراض التحليل. لا يتم نقلها إلى أطراف ثالثة في أي حال من الأحوال. تحتوي ملفات تعريف الارتباط هذه على كشف الزيارة وكشف الموقع (حسب البلد فقط وليس بدقة) وعنوان IP، للسماح للخدمة التقنية بحظر الوصول لزائر إذا كان ضارًا. يُستخدم الموقع أيضًا في خدمات اتصال الحساب لتحديد الاتصالات المهددة المحتملة وإشعار البريد الإلكتروني لاتصالات الحساب. الرفض لا يمنع بأي شكل من الأشكال تشغيل الموقع. سيتم طلب موافقة على خدمات الاتصال مرة أخرى. المعلومات التي تجمعها ملفات تعريف الارتباط لا يتم تخزينها في قواعد بياناتنا أو تسجيلها لأغراض التخصيص في أي حال من الأحوال.',
        'accept' => 'قبول',
        'refuse' => 'رفض'
    ]
];

$current_text = $texts[$lang] ?? $texts['en'];
?>

<!DOCTYPE html>
<html lang="<?= $lang ?>">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $current_text['title'] ?></title>
    <title>Imators</title>
    <meta name="description" content="Imators is a technology company, founded in early 2024 by Izhak Aktas. Our aim is to lay the foundations for the second technological phase the world will experience. It will happen little by little, so that you can enjoy it.">

    <meta property="og:url" content="https://imators.com">
    <meta property="og:type" content="website">
    <meta property="og:title" content="Imators">
    <meta property="og:description" content="Imators is a technology company, founded in early 2024 by Izhak Aktas. Our aim is to lay the foundations for the second technological phase the world will experience. It will happen little by little, so that you can enjoy it.">
    <meta property="og:image" content="https://opengraph.b-cdn.net/production/images/c2346076-5c2d-4af5-bc04-93187bd10074.png?token=htWPJq1jtmC6T1l0lrysm0HzFmIEpPZpdfjbd2qnjX8&height=630&width=1200&expires=33264233001">

    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:domain" content="imators.com">
    <meta name="twitter:url" content="https://imators.com">
    <meta name="twitter:title" content="Imators">
    <meta name="twitter:description" content="Imators is a technology company, founded in early 2024 by Izhak Aktas. Our aim is to lay the foundations for the second technological phase the world will experience. It will happen little by little, so that you can enjoy it.">
    <meta name="twitter:image" content="https://opengraph.b-cdn.net/production/images/c2346076-5c2d-4af5-bc04-93187bd10074.png?token=htWPJq1jtmC6T1l0lrysm0HzFmIEpPZpdfjbd2qnjX8&height=630&width=1200&expires=33264233001">
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-white text-black min-h-screen flex items-center justify-center p-4">

<div class="max-w-xl w-full space-y-12">
    
    <div class="space-y-2">
        <h1 class="text-2xl font-light"><?= $current_text['title'] ?></h1>
        <p class="text-sm text-gray-500"><?= $current_text['subtitle'] ?></p>
    </div>

    <div>
        <p class="text-sm leading-relaxed text-gray-700">
            <?= $current_text['content'] ?>
        </p>
    </div>
    
    <div class="space-y-6">
        <div class="flex gap-3">
            <form method="POST" class="flex-1">
                <input type="hidden" name="cookie_consent" value="accepted">
                <button type="submit" class="w-full bg-black text-white py-3 text-sm hover:bg-gray-800 transition-colors">
                    <?= $current_text['accept'] ?>
                </button>
            </form>
            
            <form method="POST" class="flex-1">
                <input type="hidden" name="cookie_consent" value="declined">
                <button type="submit" class="w-full border border-gray-300 text-black py-3 text-sm hover:border-black transition-colors">
                    <?= $current_text['refuse'] ?>
                </button>
            </form>
        </div>
        
        <div class="space-y-3">
            <p class="text-xs text-gray-400">
                <?php if ($lang === 'en'): ?>
                    Available in
                <?php elseif ($lang === 'fr'): ?>
                    Disponible en
                <?php elseif ($lang === 'it'): ?>
                    Disponibile in
                <?php elseif ($lang === 'es'): ?>
                    Disponible en
                <?php elseif ($lang === 'ja'): ?>
                    利用可能言語
                <?php elseif ($lang === 'zh'): ?>
                    可用语言
                <?php elseif ($lang === 'ar'): ?>
                    متاح بـ
                <?php endif; ?>
            </p>
            
            <div class="flex flex-wrap gap-x-4 gap-y-1 text-xs">
                <a href="?lang=en" class="<?= $lang === 'en' ? 'text-black' : 'text-gray-400' ?> hover:text-black transition-colors">English</a>
                <a href="?lang=fr" class="<?= $lang === 'fr' ? 'text-black' : 'text-gray-400' ?> hover:text-black transition-colors">Français</a>
                <a href="?lang=it" class="<?= $lang === 'it' ? 'text-black' : 'text-gray-400' ?> hover:text-black transition-colors">Italiano</a>
                <a href="?lang=es" class="<?= $lang === 'es' ? 'text-black' : 'text-gray-400' ?> hover:text-black transition-colors">Español</a>
                <a href="?lang=ja" class="<?= $lang === 'ja' ? 'text-black' : 'text-gray-400' ?> hover:text-black transition-colors">日本語</a>
                <a href="?lang=zh" class="<?= $lang === 'zh' ? 'text-black' : 'text-gray-400' ?> hover:text-black transition-colors">中文</a>
                <a href="?lang=ar" class="<?= $lang === 'ar' ? 'text-black' : 'text-gray-400' ?> hover:text-black transition-colors">العربية</a>
            </div>
        </div>
    </div>
</div>

</body>
</html>