<?php
$transparent_header = true;

require_once 'db.php';

$sql = "SELECT id, title, content, image_url, DATE_FORMAT(date_created, '%d/%m/%Y') AS formatted_date, 
               author FROM news_blog ORDER BY date_created DESC LIMIT 6";
$stmt = $conn->prepare($sql);
$stmt->execute();
$news = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="imators-verification" content="verified">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <script defer src="https://cloud.umami.is/script.js" data-website-id="b467e8c1-b13e-4744-80ac-d625ad1403b4"></script>
    
    <script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
    new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
    j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
    'https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
    })(window,document,'script','dataLayer','GTM-MNDDTWSM');</script>
    <title>Imators</title>
    <meta name="description" content="Imators is a technology company, founded in early 2024 by Izhak Aktas. Our aim is to lay the foundations for the second technological phase the world will experience. It will happen little by little, so that you can enjoy it.">

    <meta property="og:url" content="https://imators.com">
    <meta property="og:type" content="website">
    <meta property="og:title" content="Imators">
    <meta property="og:description" content="Imators is a technology company, founded in early 2024 by Izhak Aktas. Our aim is to lay the foundations for the second technological phase the world will experience. It will happen little by little, so that you can enjoy it.">
    <meta property="og:image" content="https://opengraph.b-cdn.net/production/images/c2346076-5c2d-4af5-bc04-93187bd10074.png?token=htWPJq1jtmC6T1l0lrysm0HzFmIEpPZpdfjbd2qnjX8&height=630&width=1200&expires=33264233001">

    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:domain" content="imators.com">
    <meta name="twitter:url" content="https://imators.com">
    <meta name="twitter:title" content="Imators">
    <meta name="twitter:description" content="Imators is a technology company, founded in early 2024 by Izhak Aktas. Our aim is to lay the foundations for the second technological phase the world will experience. It will happen little by little, so that you can enjoy it.">
    <meta name="twitter:image" content="https://opengraph.b-cdn.net/production/images/c2346076-5c2d-4af5-bc04-93187bd10074.png?token=htWPJq1jtmC6T1l0lrysm0HzFmIEpPZpdfjbd2qnjX8&height=630&width=1200&expires=33264233001">

    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Space+Grotesk:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link href="https://cdn.imators.com/logo.png" rel="icon" type="image/png" />
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">

    <style>
        body {
            font-family: 'Space Grotesk', sans-serif;
            background-color: #000;
            overflow-x: hidden;
        }

        .header {
            z-index: 1000;
        }

        .zajidhiadj {
            z-index: 1001;
            position: relative;
        }

        .hero-slider {
            width: 100%;
            height: 100vh;
            position: relative;
            overflow: hidden;
        }

        .slider-wrapper {
            width: 400%;
            height: 100%;
            display: flex;
            transition: transform 1.2s cubic-bezier(0.4, 0, 0.2, 1);
        }

        .slide {
            width: 25%;
            height: 100%;
            background-size: cover;
            background-position: center;
            position: relative;
        }

        .slide::before {
            content: '';
            position: absolute;
            inset: 0;
            background: linear-gradient(to bottom, rgba(0,0,0,0.1) 0%, rgba(0,0,0,0.6) 100%);
        }

        .slide-info {
            position: absolute;
            bottom: 10rem;
            left: 50%;
            transform: translateX(-50%);
            text-align: center;
            color: white;
            z-index: 2;
            opacity: 0;
            transform: translateX(-50%) translateY(20px);
            transition: all 0.8s cubic-bezier(0.4, 0, 0.2, 1);
        }

        .slide.active .slide-info {
            opacity: 1;
            transform: translateX(-50%) translateY(0);
        }

        .slide-label {
            font-size: 0.7rem;
            font-weight: 300;
            opacity: 0.7;
            margin-bottom: 0.5rem;
            text-transform: uppercase;
            letter-spacing: 0.15em;
        }

        .slide-title {
            font-size: 2.2rem;
            font-weight: 300;
            margin-bottom: 1rem;
            letter-spacing: -0.02em;
        }

        .slide-desc {
            font-size: 0.95rem;
            font-weight: 300;
            margin-bottom: 2rem;
            opacity: 0.85;
            max-width: 450px;
            line-height: 1.4;
        }

        .slide-link {
            display: inline-block;
            padding: 0.9rem 2.2rem;
            border: 1px solid rgba(255, 255, 255, 0.4);
            color: white;
            text-decoration: none;
            font-size: 0.9rem;
            font-weight: 300;
            border-radius: 50px;
            transition: all 0.4s ease;
            backdrop-filter: blur(10px);
            background: rgba(255, 255, 255, 0.05);
        }

        .slide-link:hover {
            background: rgba(255, 255, 255, 0.1);
            border-color: rgba(255, 255, 255, 0.7);
            transform: translateY(-2px);
        }

        .dots {
            position: absolute;
            bottom: 4rem;
            left: 50%;
            transform: translateX(-50%);
            display: flex;
            gap: 1rem;
            z-index: 10;
        }

        .dot {
            width: 8px;
            height: 8px;
            border-radius: 50%;
            background: rgba(255, 255, 255, 0.3);
            cursor: pointer;
            transition: all 0.4s ease;
        }

        .dot.active {
            background: white;
            transform: scale(1.2);
        }

        .dot:hover {
            background: rgba(255, 255, 255, 0.6);
        }

        @media (max-width: 768px) {
            .slide-title {
                font-size: 1.8rem;
            }
            
            .slide-desc {
                font-size: 0.9rem;
            }
            
            .slide-info {
                bottom: 12rem;
            }
            
            .dots {
                bottom: 6rem;
            }
        }

        @media (max-width: 480px) {
            .slide-title {
                font-size: 1.5rem;
            }
            
            .slide-desc {
                font-size: 0.85rem;
                max-width: 350px;
            }
            
            .slide-link {
                padding: 0.8rem 2rem;
            }
        }
    </style>
</head>
<body>
    <?php include 'src/header.php'; ?>

    <section class="hero-slider">
        <div class="slider-wrapper" id="slider">
            <div class="slide active">
                <div class="slide-info">
                    <div class="slide-label">Available in October 2025</div>
                    <h2 class="slide-title">Can</h2>
                    <p class="slide-desc">An algorithm that lives in your projects, which you control 100%.</p>
                    <a href="https://imators.systems/can" class="slide-link">Test the Beta</a>
                </div>
            </div>
            
            <div class="slide">
                <div class="slide-info">
                    <h2 class="slide-title">Academ</h2>
                    <p class="slide-desc">Education will become enjoyable for all.</p>
                    <a href="https://academ.my" class="slide-link">Install the application</a>
                </div>
            </div>
            
            <div class="slide"> 
                <div class="slide-info">
                    <div class="slide-label">Available in February 2026</div>
                    <h2 class="slide-title">OhMyPanel</h2>
                    <p class="slide-desc">Make food shopping a quick and easy activity, and turn a shop into an organised, worry-free place.</p>
                    <a href="https://ohmypanel.com" class="slide-link">Find out more</a>
                </div>
            </div>
            
            <div class="slide">
                <div class="slide-info">
                    <h2 class="slide-title">formore</h2>
                    <p class="slide-desc">Streaming updated and free, to watch series and films from your favourite video games, to bring beauty to life.</p>
                    <a href="https://formore.tv" class="slide-link">Watch a film</a>
                </div>
            </div>
        </div>

        <div class="dots">
            <div class="dot active" onclick="goTo(0)"></div>
            <div class="dot" onclick="goTo(1)"></div>
            <div class="dot" onclick="goTo(2)"></div>
            <div class="dot" onclick="goTo(3)"></div>
        </div>
    </section>

    <script>
        let current = 0;
        const slides = document.querySelectorAll('.slide');
        const dots = document.querySelectorAll('.dot');
        const slider = document.getElementById('slider');
        let timer;

        const images = [
            {
                desktop: 'can-banner.png',
                mobile: 'can-banner-mobile.png'
            },
            {
                desktop: 'https://cdn.imators.com/banner-academ.png',
                mobile: 'https://cdn.imators.com/slider/academ-mobile.jpg'
            },
            {
                desktop: 'banner-omp.png',
                mobile: 'banner-omp-mobile.png'
            },
            {
                desktop: 'For_More-BannerIndex.png',
                mobile: 'banner-formore-mobile.png'
            }
        ];

        function setImages() {
            const isMobile = window.innerWidth <= 768;
            slides.forEach((slide, i) => {
                const img = isMobile ? images[i].mobile : images[i].desktop;
                slide.style.backgroundImage = `url('${img}')`;
            });
        }

        function update() {
            slider.style.transform = `translateX(-${current * 25}%)`;
            
            slides.forEach((slide, i) => {
                slide.classList.toggle('active', i === current);
            });
            
            dots.forEach((dot, i) => {
                dot.classList.toggle('active', i === current);
            });
        }

        function goTo(index) {
            current = index;
            update();
            resetTimer();
        }

        function next() {
            current = (current + 1) % 4;
            update();
        }

        function startTimer() {
            timer = setInterval(next, 5000);
        }

        function resetTimer() {
            clearInterval(timer);
            startTimer();
        }

        let touchStart = 0;
        document.addEventListener('touchstart', e => {
            touchStart = e.touches[0].clientX;
        });

        document.addEventListener('touchend', e => {
            const touchEnd = e.changedTouches[0].clientX;
            const diff = touchStart - touchEnd;
            
            if (Math.abs(diff) > 50) {
                if (diff > 0) {
                    current = (current + 1) % 4;
                } else {
                    current = (current - 1 + 4) % 4;
                }
                update();
                resetTimer();
            }
        });

        document.addEventListener('DOMContentLoaded', () => {
            setImages();
            startTimer();
            window.addEventListener('resize', setImages);
        });
    </script>

<div class="w-full">
  <h2 class="text-4xl md:text-6xl font-light text-gray-300 mb-8 mt-8 md:mt-16 text-center px-4 md:px-8">Maybe we can help you to discover ?</h2>
  
  <div class="space-y-0">
    <a href="https://store.imators.com/lifestyle" class="block w-full bg-black text-white p-8 hover:opacity-90 transition-opacity group">
      <div class="flex justify-between items-center">
        <span class="text-xl font-light">Discover lifestyle products</span>
        <svg class="w-6 h-6 transform group-hover:translate-x-1 transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24">
          <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 8l4 4m0 0l-4 4m4-4H3"/>
        </svg>
      </div>
    </a>
    
    <a href="https://store.imators.com/online-products" class="block w-full bg-white text-black p-8 hover:opacity-90 transition-opacity group">
      <div class="flex justify-between items-center">
        <span class="text-xl font-light">Discover online products</span>
        <svg class="w-6 h-6 transform group-hover:translate-x-1 transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24">
          <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 8l4 4m0 0l-4 4m4-4H3"/>
        </svg>
      </div>
    </a>
    
    <a href="https://store.imators.com/buisness-products" class="block w-full bg-black text-white p-8 hover:opacity-90 transition-opacity group">
      <div class="flex justify-between items-center">
        <span class="text-xl font-light">Discover business products</span>
        <svg class="w-6 h-6 transform group-hover:translate-x-1 transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24">
          <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 8l4 4m0 0l-4 4m4-4H3"/>
        </svg>
      </div>
    </a>
    
    <a href="https://store.imators.com/developers-products" class="block w-full bg-white text-black p-8 hover:opacity-90 transition-opacity group">
      <div class="flex justify-between items-center">
        <span class="text-xl font-light">Discover developers products</span>
        <svg class="w-6 h-6 transform group-hover:translate-x-1 transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24">
          <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 8l4 4m0 0l-4 4m4-4H3"/>
        </svg>
      </div>
    </a>
  </div>
  
  <div class="w-full bg-gradient-to-b from-black via-black to-black h-20"></div>
  
  <div class="w-full relative">
    <div class="absolute top-0 left-0 w-full h-20 bg-gradient-to-b from-black to-transparent z-10"></div>
    <img src="banner-end-section.jpg" alt="Banner" class="brightness-50 w-full h-48 md:h-96 object-cover">
    <div class="absolute bottom-4 left-1/2 transform -translate-x-1/2">
      <p class="text-white text-sm md:text-lg font-light">Don't get carried away by anything other than yourself - Aktas Izhak</p>
    </div>
  </div>
</div>

    <footer>
        <div class="max-w-6xl mx-auto px-4 py-6 flex flex-wrap justify-between">
            <div class="w-full md:w-1/3 p-4">
                <h5 class="text-xs uppercase font-medium mb-4">Need Help?</h5>
                <a href="/support" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
                    Support
                </a>
                <a href="/contact-us" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
                    Contact Us
                </a>
            </div>
            <div class="w-full md:w-1/3 p-4">
                <h5 class="text-xs uppercase font-medium mb-4">Discover</h5>
                <a href="/privacy" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
                    Privacy Policy
                </a>
                <a href="/terms-of-use" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
                    Terms of Use
                </a>
                <a href="/refund-policy" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
                    Refund Policy
                </a>
                <a href="/legal-notice" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
                    Legal Notice
                </a>
                <a href="/" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
                    Home
                </a>
                <a href="/about-us" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
                    About Us
                </a>
            </div>
            <div class="w-full md:w-1/3 p-4">
                <h5 class="text-xs uppercase font-medium mb-4">Because it's possible</h5>
                <p class="text-sm">
                    All images, videos, and content on this site are the property of Imators.
                </p>
            </div>
        </div>

        <div class="text-center py-3 border-t border-gray-800">
            <p class="text-sm">
                &copy; <?php echo date("Y"); ?> Imators. All rights reserved.
            </p>
            <p class="text-xs mt-2">
                <a href="https://aktascorp.com">Imators is a aktascorp members.</a>
            </p>
            <p class="text-xs">
                Imators is a registered LLC. All our products are subject to our terms.
            </p>
        </div>
    </footer>
</body>
</html>