<!DOCTYPE html>
<html lang="en-GB">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Imators - For the lifestyle</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://cdn.imators.com/logo.png" rel="icon" type="image/png" />
    <style>
        body {
            font-family: 'Poppins', sans-serif;
            background-color: #000000;
            color: #FFFFFF;
            min-height: 100vh;
        }

        .main-container {
            display: flex;
            flex-direction: column;
            min-height: 100vh;
        }

        .content-area {
            flex: 1;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 2rem 1rem;
        }

        .grid-background {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-image: 
                radial-gradient(circle at 50% 50%, rgba(255, 255, 255, 0.15) 1px, transparent 1px);
            background-size: 30px 30px;
            opacity: 0.3;
            z-index: -1;
        }

        .highlight {
            color: #FFFFFF;
            position: relative;
            display: inline-block;
        }

        .highlight::after {
            content: '';
            position: absolute;
            width: 100%;
            height: 8px;
            bottom: 5px;
            left: 0;
            background-color: rgba(255, 255, 255, 0.15);
            z-index: -1;
        }

        .feature-item {
            border-left: 1px solid rgba(255, 255, 255, 0.1);
            transition: all 0.3s ease;
            padding-left: 1rem;
            margin-bottom: 1.5rem;
        }

        .feature-item:hover {
            border-left: 1px solid rgba(255, 255, 255, 0.3);
        }

        .product-tab {
            border-bottom: 2px solid transparent;
            transition: all 0.3s ease;
            white-space: nowrap;
            flex: 1;
            text-align: center;
        }

        .product-tab.active {
            border-bottom: 2px solid #FFFFFF;
        }

        .product-tab:hover:not(.active) {
            border-bottom: 2px solid rgba(255, 255, 255, 0.3);
        }

        .demo-button {
            background: rgba(255, 255, 255, 0.05);
            border: 1px solid rgba(255, 255, 255, 0.1);
            transition: all 0.3s ease;
            text-align: center;
            width: 100%;
            max-width: 300px;
        }

        .demo-button:hover {
            background: rgba(255, 255, 255, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.3);
        }

        .api-box {
            background: rgba(255, 255, 255, 0.03);
            border: 1px solid rgba(255, 255, 255, 0.1);
            width: 100%;
            max-width: 500px;
        }

        .footer {
            padding: 1.5rem;
            border-top: 1px solid rgba(255, 255, 255, 0.1);
        }
        
        /* Circles for products */
        .circle-container {
            position: relative;
            width: 280px;
            height: 280px;
            margin: 0 auto;
        }
        
        .circle {
            position: absolute;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            background: rgba(255, 255, 255, 0.03);
            border: 1px solid rgba(255, 255, 255, 0.1);
            transition: all 0.3s ease;
        }
        
        .circle:hover {
            background: rgba(255, 255, 255, 0.05);
        }
        
        .circle-1 {
            width: 180px;
            height: 180px;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            z-index: 3;
        }
        
        .circle-2 {
            width: 130px;
            height: 130px;
            top: 25%;
            left: 75%;
            z-index: 2;
        }
        
        .circle-3 {
            width: 120px;
            height: 120px;
            top: 75%;
            left: 25%;
            z-index: 1;
        }
        
        /* Cookie Box */
        .cookie-box {
            position: fixed;
            bottom: 0;
            left: 0;
            right: 0;
            margin: 1rem;
            padding: 1rem;
            background-color: #000000;
            border: 1px solid rgba(255, 255, 255, 0.1);
            border-radius: 0.5rem;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.5);
            z-index: 50;
            opacity: 0;
            transform: translateY(1rem);
            transition: all 0.5s ease-out;
        }

        .cookie-box.visible {
            opacity: 1;
            transform: translateY(0);
        }

        @media (max-width: 768px) {
            .content-area {
                padding: 1.5rem 1rem;
            }
            
            h2 {
                font-size: 1.75rem;
                line-height: 1.3;
            }
            
            .footer {
                padding: 1rem;
            }
        }
    </style>
</head>
<body>
<?php include 'src/header.php'; ?>

    <div class="grid-background"></div>
    <div class="main-container">
        <div class="mt-24 content-area">
            <div class="w-full max-w-4xl mx-auto">
                <!-- Logo and Main Text -->
                <div class="mb-8 md:mb-12 text-center">
                    <h1 class="text-xl md:text-2xl font-light">For The Lifestyle</h1>
                    <h2 class="text-3xl md:text-4xl font-light leading-tight mb-4 md:mb-6">
                        Products designed for your<br class="hidden md:block"> everyday needs.
                    </h2>
                    <p class="text-zinc-400 text-base md:text-xl max-w-2xl mx-auto">
                        Discover our lifestyle products that seamlessly integrate with your daily routine.
                    </p>
                </div>
                
                <!-- Circles with product logos -->
                <div class="circle-container my-16">
                    <div class="circle circle-1">
                        <img src="https://imators.systems/traffic/traffic_logo.png" alt="TrafficLight" class="w-10 h-10 md:w-12 md:h-12">
                    </div>
                    <div class="circle circle-2">
                        <img src="https://cdn.imators.com/product2_logo.png" alt="Product 2" class="w-8 h-8 md:w-10 md:h-10">
                    </div>
                    <div class="circle circle-3">
                        <img src="https://cdn.imators.com/product3_logo.png" alt="Product 3" class="w-8 h-8 md:w-10 md:h-10">
                    </div>
                </div>
                
                <!-- Product Tabs -->
                <div class="product-tabs flex mb-6 border-b border-zinc-800 overflow-x-auto">
                    <div class="product-tab active px-4 py-3 md:px-6 cursor-pointer" onclick="changeTab('product1')">
                        <i class="fa fa-traffic-light mr-2"></i> TrafficLight
                    </div>
                    <div class="product-tab px-4 py-3 md:px-6 cursor-pointer" onclick="changeTab('product2')">
                        <i class="fa fa-cube mr-2"></i> Product 2
                    </div>
                    <div class="product-tab px-4 py-3 md:px-6 cursor-pointer" onclick="changeTab('product3')">
                        <i class="fa fa-cube mr-2"></i> Product 3
                    </div>
                </div>
                
                <!-- Product 1 Content -->
                <div id="product1" class="tab-content">
                    <div class="mb-8 md:mb-12">
                        <div class="flex items-center mb-6">
                            <img src="https://imators.systems/traffic/traffic_logo.png" alt="TrafficLight" class="rounded-md w-10 h-10 md:w-12 md:h-12 mr-3">
                            <h1 class="text-xl md:text-2xl font-light">TrafficLight</h1>
                        </div>
                        <h2 class="text-3xl md:text-4xl font-light leading-tight mb-4 md:mb-6">
                            A solution to see<br class="hidden md:block"> what your city hasn't added.
                        </h2>
                        <p class="text-zinc-400 text-base md:text-xl max-w-2xl">
                            With TrafficLight, you can get detailed, live traffic information, thanks to the addition of the community and a cutting-edge system.
                        </p>
                    </div>
                    
                    <div class="grid grid-cols-1 md:grid-cols-3 gap-4 md:gap-8 mb-8">
                        <div class="feature-item">
                            <div class="flex items-center mb-2">
                                <i class="fa fa-road text-zinc-300 mr-3"></i>
                                <h3 class="text-base md:text-lg font-medium">Faster, all the time.</h3>
                            </div>
                            <p class="text-zinc-400 text-sm">Avoid an average 15-minute delay at your destination*</p>
                        </div>
                        
                        <div class="feature-item">
                            <div class="flex items-center mb-2">
                                <i class="fa fa-map-marker text-zinc-300 mr-3"></i>
                                <h3 class="text-base md:text-lg font-medium">You change everything</h3>
                            </div>
                            <p class="text-zinc-400 text-sm">No need to stop or pick up your phone! The application automatically adds traffic lights**</p>
                        </div>
                        
                        <div class="feature-item">
                            <div class="flex items-center mb-2">
                                <i class="fa fa-mobile-screen text-zinc-300 mr-3"></i>
                                <h3 class="text-base md:text-lg font-medium">Mobile Ready</h3>
                            </div>
                            <p class="text-zinc-400 text-sm">Optimised user experience on all devices.</p>
                        </div>
                    </div>
                    
                    <div class="flex justify-center mt-4 mb-8">
                        <a href="https://imators.systems/traffic" class="demo-button px-6 py-3 md:px-8 md:py-4 rounded-md text-base md:text-lg hover:text-white transition-colors">
                            <i class="fa fa-play-circle mr-2"></i>
                            Go to the application
                        </a>
                    </div>
                </div>
                
                <!-- Product 2 Content -->
                <div id="product2" class="tab-content hidden">
                    <div class="mb-8 md:mb-12">
                        <div class="flex items-center mb-6">
                            <img src="https://cdn.imators.com/product2_logo.png" alt="Product 2" class="rounded-md w-10 h-10 md:w-12 md:h-12 mr-3">
                            <h1 class="text-xl md:text-2xl font-light">Product 2</h1>
                        </div>
                        <h2 class="text-3xl md:text-4xl font-light leading-tight mb-4 md:mb-6">
                            Second product<br class="hidden md:block"> for your lifestyle.
                        </h2>
                        <p class="text-zinc-400 text-base md:text-xl max-w-2xl">
                            Our second product provides innovative solutions designed to enhance your everyday experience.
                        </p>
                    </div>
                    
                    <div class="grid grid-cols-1 md:grid-cols-3 gap-4 md:gap-8 mb-8">
                        <div class="feature-item">
                            <div class="flex items-center mb-2">
                                <i class="fa fa-bolt text-zinc-300 mr-3"></i>
                                <h3 class="text-base md:text-lg font-medium">Fast Performance</h3>
                            </div>
                            <p class="text-zinc-400 text-sm">Experience lightning-fast response times</p>
                        </div>
                        
                        <div class="feature-item">
                            <div class="flex items-center mb-2">
                                <i class="fa fa-shield text-zinc-300 mr-3"></i>
                                <h3 class="text-base md:text-lg font-medium">Enhanced Security</h3>
                            </div>
                            <p class="text-zinc-400 text-sm">Your data is protected with advanced encryption</p>
                        </div>
                        
                        <div class="feature-item">
                            <div class="flex items-center mb-2">
                                <i class="fa fa-cloud text-zinc-300 mr-3"></i>
                                <h3 class="text-base md:text-lg font-medium">Cloud Integration</h3>
                            </div>
                            <p class="text-zinc-400 text-sm">Seamless sync across all your devices</p>
                        </div>
                    </div>
                    
                    <div class="flex justify-center mt-4 mb-8">
                        <a href="https://imators.com/product2" class="demo-button px-6 py-3 md:px-8 md:py-4 rounded-md text-base md:text-lg hover:text-white transition-colors">
                            <i class="fa fa-info-circle mr-2"></i>
                            Learn More
                        </a>
                    </div>
                </div>
                
                <!-- Product 3 Content -->
                <div id="product3" class="tab-content hidden">
                    <div class="mb-8 md:mb-12">
                        <div class="flex items-center mb-6">
                            <img src="https://cdn.imators.com/product3_logo.png" alt="Product 3" class="rounded-md w-10 h-10 md:w-12 md:h-12 mr-3">
                            <h1 class="text-xl md:text-2xl font-light">Product 3</h1>
                        </div>
                        <h2 class="text-3xl md:text-4xl font-light leading-tight mb-4 md:mb-6">
                            Third product<br class="hidden md:block"> to complete your experience.
                        </h2>
                        <p class="text-zinc-400 text-base md:text-xl max-w-2xl">
                            Our third product completes the lifestyle suite with powerful features that integrate with your daily activities.
                        </p>
                    </div>
                    
                    <div class="grid grid-cols-1 md:grid-cols-3 gap-4 md:gap-8 mb-8">
                        <div class="feature-item">
                            <div class="flex items-center mb-2">
                                <i class="fa fa-wand-magic-sparkles text-zinc-300 mr-3"></i>
                                <h3 class="text-base md:text-lg font-medium">Smart Automation</h3>
                            </div>
                            <p class="text-zinc-400 text-sm">Automate routine tasks with intelligent features</p>
                        </div>
                        
                        <div class="feature-item">
                            <div class="flex items-center mb-2">
                                <i class="fa fa-gauge-high text-zinc-300 mr-3"></i>
                                <h3 class="text-base md:text-lg font-medium">High Performance</h3>
                            </div>
                            <p class="text-zinc-400 text-sm">Optimized for speed and efficiency</p>
                        </div>
                        
                        <div class="feature-item">
                            <div class="flex items-center mb-2">
                                <i class="fa fa-chart-simple text-zinc-300 mr-3"></i>
                                <h3 class="text-base md:text-lg font-medium">Detailed Analytics</h3>
                            </div>
                            <p class="text-zinc-400 text-sm">Get insights with comprehensive reporting</p>
                        </div>
                    </div>
                    
                    <div class="flex justify-center mt-4 mb-8">
                        <a href="https://imators.com/product3" class="demo-button px-6 py-3 md:px-8 md:py-4 rounded-md text-base md:text-lg hover:text-white transition-colors">
                            <i class="fa fa-info-circle mr-2"></i>
                            Learn More
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="fixed bottom-0 left-0 right-0 mx-4 sm:mx-6 md:mx-8 mb-4 sm:mb-6 p-4 sm:p-5 bg-black text-white rounded-lg shadow-xl z-50 opacity-0 translate-y-8 transition-all duration-500 ease-out" id="cookieBox">
      <div class="container mx-auto flex flex-col sm:flex-row justify-between items-center gap-4">
        <div class="text-sm md:text-base font-light leading-relaxed max-w-3xl">
        Our site uses only the essential cookies required for the site to function properly. No information is passed on to third parties. To find out more about the essential information collected, <a href="./terms-of-use" class="underline">please read our terms of use</a>.
        </div>
        <button class="w-full sm:w-auto bg-white text-black px-6 py-2 rounded-full hover:bg-gray-100 transition-colors whitespace-nowrap text-sm font-medium" onclick="acceptCookies()">
        Accept
        </button>
      </div>
    </div>

    <script>
    function changeTab(tabId) {
        // Hide all tab contents
        document.querySelectorAll('.tab-content').forEach(tab => {
            tab.classList.add('hidden');
        });
        
        // Remove active class from all tabs
        document.querySelectorAll('.product-tab').forEach(tab => {
            tab.classList.remove('active');
        });
        
        // Show selected tab content
        document.getElementById(tabId).classList.remove('hidden');
        
        // Add active class to clicked tab
        event.currentTarget.classList.add('active');
    }

    // Cookie functions
    function acceptCookies() {
        const cookieBox = document.getElementById('cookieBox');
        cookieBox.classList.remove('visible');
        
        setTimeout(() => {
            cookieBox.style.display = 'none';
        }, 500);
        
        // Set cookie with 30 days expiration
        const expiryDate = new Date();
        expiryDate.setDate(expiryDate.getDate() + 30);
        
        document.cookie = "cookiesAccepted=true; expires=" + expiryDate.toUTCString() + "; path=/";
    }

    // Check if cookies have been accepted
    function checkCookies() {
        if (!document.cookie.split(';').some((item) => item.trim().startsWith('cookiesAccepted='))) {
            const cookieBox = document.getElementById('cookieBox');
            
            setTimeout(() => {
                cookieBox.classList.add('visible');
            }, 2000);
        }
    }

    // Run when page loads
    window.onload = function() {
        checkCookies();
    }
    </script>

<footer class="bg-black text-white"><div class="max-w-6xl mx-auto px-4 py-6 flex flex-wrap justify-between">
    <div class="w-full md:w-1/3 p-4">
        <h5 class="text-xs uppercase font-medium mb-4">Need Help?</h5>
        <a href="/support" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
            Support
        </a>
        <a href="/contact-us" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
            Contact Us
        </a>
    </div>
    <div class="w-full md:w-1/3 p-4">
        <h5 class="text-xs uppercase font-medium mb-4">Discover</h5>
        <a href="/privacy" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
            Privacy Policy
        </a>
        <a href="/terms-of-use" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
            Terms of Use
        </a>
        <a href="/refund-policy" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
            Refund Policy
        </a>
        <a href="/legal-notice" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
            Legal Notice
        </a>
        <a href="/" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
            Home
        </a>
        <a href="/about-us" class="my-2 block hover:text-gray-100 text-sm font-medium duration-700">
            About Us
        </a>
    </div>
    <div class="w-full md:w-1/3 p-4">
        <h5 class="text-xs uppercase font-medium mb-4">Because it's possible</h5>
        <p class="text-sm">
            All images, videos, and content on this site are the property of Imators.
        </p>
    </div>
</div>

<div class="text-center py-3 border-t border-gray-800">
    <p class="text-sm">
        &copy; <?php echo date("Y"); ?> Imators. All rights reserved.
    </p>
    <p class="text-xs mt-2">
        <a href="https://aktascorp.com">Imators is a aktascorp members.</a>
    </p>
    <p class="text-xs">
        Imators is a registered LLC. All our products are subject to our terms.
    </p>
</div></footer>
</body>
</html>