import * as react from 'react';
import { ContextType } from './use-calendar-base.js';
import { CalendarState, RangeCalendarState } from '@react-stately/calendar';
import '@react-types/shared';
import '@react-types/calendar';
import '@internationalized/date';
import 'tailwind-variants';
import '@heroui/system';
import '@heroui/theme';
import '@react-aria/calendar';
import '@react-types/button';
import '@heroui/button';
import '@heroui/react-utils';

declare const CalendarProvider: react.Provider<ContextType<CalendarState | RangeCalendarState>>;
declare const useCalendarContext: () => ContextType<CalendarState | RangeCalendarState>;

export { CalendarProvider, useCalendarContext };
