import * as react from 'react';
import * as _heroui_system from '@heroui/system';
import { PropGetter, HTMLHeroUIProps } from '@heroui/system';
import { AriaRadioGroupProps } from '@react-types/radio';
import { Orientation } from '@react-types/shared';
import { ReactRef } from '@heroui/react-utils';
import { SlotsToClasses, RadioGroupSlots } from '@heroui/theme';
import { RadioGroupState } from '@react-stately/radio';
import { RadioProps } from './radio.js';
import './use-radio.js';

interface Props extends Omit<HTMLHeroUIProps<"div">, "onChange"> {
    /**
     * Ref to the DOM node.
     */
    ref?: ReactRef<HTMLDivElement | null>;
    /**
     * The axis the radio group items should align with.
     * @default "vertical"
     */
    orientation?: Orientation;
    /**
     * Classname or List of classes to change the classNames of the element.
     * if `className` is passed, it will be added to the base slot.
     *
     * @example
     * ```ts
     * <RadioGroup classNames={{
     *    base:"base-classes",
     *    label: "label-classes",
     *    wrapper: "wrapper-classes", // radios wrapper
     * }} >
     *  // radios
     * </RadioGroup>
     * ```
     */
    classNames?: SlotsToClasses<RadioGroupSlots>;
    /**
     * React aria onChange event.
     */
    onValueChange?: AriaRadioGroupProps["onChange"];
}
type UseRadioGroupProps = Omit<Props, "defaultChecked"> & Omit<AriaRadioGroupProps, "onChange"> & Partial<Pick<RadioProps, "color" | "size" | "isDisabled" | "disableAnimation" | "onChange">>;
type ContextType = {
    groupState: RadioGroupState;
    isRequired?: UseRadioGroupProps["isRequired"];
    isInvalid?: UseRadioGroupProps["isInvalid"];
    color?: RadioProps["color"];
    size?: RadioProps["size"];
    isDisabled?: RadioProps["isDisabled"];
    disableAnimation?: RadioProps["disableAnimation"];
    onChange?: RadioProps["onChange"];
};
declare function useRadioGroup(props: UseRadioGroupProps): {
    Component: _heroui_system.As<any>;
    children: react.ReactNode;
    label: react.ReactNode;
    context: ContextType;
    description: react.ReactNode;
    isInvalid: boolean;
    errorMessage: react.ReactNode;
    getGroupProps: PropGetter;
    getLabelProps: PropGetter;
    getWrapperProps: PropGetter;
    getDescriptionProps: PropGetter;
    getErrorMessageProps: PropGetter;
};
type UseRadioGroupReturn = ReturnType<typeof useRadioGroup>;

export { type ContextType, type UseRadioGroupProps, type UseRadioGroupReturn, useRadioGroup };
