"use client";
import {
  toast_default
} from "./chunk-CF6MWS7K.mjs";

// src/toast-region.tsx
import { useCallback, useEffect, useMemo, useRef, useState } from "react";
import { useToastRegion } from "@react-aria/toast";
import { useHover } from "@react-aria/interactions";
import { mergeProps } from "@react-aria/utils";
import { toastRegion } from "@heroui/theme";
import { clsx } from "@heroui/shared-utils";
import { jsx } from "react/jsx-runtime";
function ToastRegion({
  toastQueue,
  placement,
  disableAnimation,
  maxVisibleToasts,
  toastOffset,
  toastProps = {},
  className,
  classNames,
  ...props
}) {
  var _a, _b;
  const ref = useRef(null);
  const { regionProps } = useToastRegion(props, toastQueue, ref);
  const { hoverProps, isHovered } = useHover({
    isDisabled: false
  });
  const [isTouched, setIsTouched] = useState(false);
  const slots = useMemo(
    () => toastRegion({
      disableAnimation
    }),
    [disableAnimation]
  );
  const baseStyles = clsx(classNames == null ? void 0 : classNames.base, className);
  useEffect(() => {
    function handleTouchOutside(event) {
      if (ref.current && !ref.current.contains(event.target)) {
        setIsTouched(false);
      }
    }
    document.addEventListener("touchstart", handleTouchOutside);
    return () => {
      document.removeEventListener("touchstart", handleTouchOutside);
    };
  }, []);
  const [heights, setHeights] = useState([]);
  const total = (_b = (_a = toastQueue.visibleToasts) == null ? void 0 : _a.length) != null ? _b : 0;
  const handleTouchStart = useCallback(() => {
    setIsTouched(true);
  }, []);
  return /* @__PURE__ */ jsx(
    "div",
    {
      ...mergeProps(regionProps, hoverProps),
      ref,
      className: slots.base({ class: baseStyles }),
      "data-placement": placement,
      onTouchStart: handleTouchStart,
      children: [...toastQueue.visibleToasts].reverse().map((toast, index) => {
        if (disableAnimation && total - index > maxVisibleToasts) {
          return null;
        }
        if (disableAnimation || total - index <= 4 || isHovered && total - index <= maxVisibleToasts + 1) {
          return /* @__PURE__ */ jsx(
            toast_default,
            {
              state: toastQueue,
              toast,
              ...mergeProps(toastProps, toast.content),
              disableAnimation,
              heights,
              index,
              isRegionExpanded: isHovered || isTouched,
              maxVisibleToasts,
              placement,
              setHeights,
              toastOffset,
              total
            },
            toast.key
          );
        }
        return null;
      })
    }
  );
}

export {
  ToastRegion
};
