"use client";
"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/index.ts
var index_exports = {};
__export(index_exports, {
  Button: () => button_default,
  ButtonGroup: () => button_group_default,
  ButtonGroupProvider: () => ButtonGroupProvider,
  useButton: () => useButton,
  useButtonGroup: () => useButtonGroup,
  useButtonGroupContext: () => useButtonGroupContext
});
module.exports = __toCommonJS(index_exports);

// src/button.tsx
var import_spinner = require("@heroui/spinner");
var import_ripple2 = require("@heroui/ripple");
var import_system2 = require("@heroui/system");

// src/use-button.ts
var import_system = require("@heroui/system");
var import_shared_utils = require("@heroui/shared-utils");
var import_react = require("react");
var import_focus = require("@react-aria/focus");
var import_utils = require("@react-aria/utils");
var import_react_utils2 = require("@heroui/react-utils");
var import_theme = require("@heroui/theme");
var import_react2 = require("react");
var import_use_aria_button = require("@heroui/use-aria-button");
var import_interactions = require("@react-aria/interactions");
var import_ripple = require("@heroui/ripple");

// src/button-group-context.ts
var import_react_utils = require("@heroui/react-utils");
var [ButtonGroupProvider, useButtonGroupContext] = (0, import_react_utils.createContext)({
  name: "ButtonGroupContext",
  strict: false
});

// src/use-button.ts
function useButton(props) {
  var _a, _b, _c, _d, _e, _f, _g, _h, _i;
  const groupContext = useButtonGroupContext();
  const globalContext = (0, import_system.useProviderContext)();
  const isInGroup = !!groupContext;
  const {
    ref,
    as,
    children,
    startContent: startContentProp,
    endContent: endContentProp,
    autoFocus,
    className,
    spinner,
    isLoading = false,
    disableRipple: disableRippleProp = false,
    fullWidth = (_a = groupContext == null ? void 0 : groupContext.fullWidth) != null ? _a : false,
    radius = groupContext == null ? void 0 : groupContext.radius,
    size = (_b = groupContext == null ? void 0 : groupContext.size) != null ? _b : "md",
    color = (_c = groupContext == null ? void 0 : groupContext.color) != null ? _c : "default",
    variant = (_d = groupContext == null ? void 0 : groupContext.variant) != null ? _d : "solid",
    disableAnimation = (_f = (_e = groupContext == null ? void 0 : groupContext.disableAnimation) != null ? _e : globalContext == null ? void 0 : globalContext.disableAnimation) != null ? _f : false,
    isDisabled: isDisabledProp = (_g = groupContext == null ? void 0 : groupContext.isDisabled) != null ? _g : false,
    isIconOnly = (_h = groupContext == null ? void 0 : groupContext.isIconOnly) != null ? _h : false,
    spinnerPlacement = "start",
    onPress,
    onClick,
    ...otherProps
  } = props;
  const Component = as || "button";
  const shouldFilterDOMProps = typeof Component === "string";
  const domRef = (0, import_react_utils2.useDOMRef)(ref);
  const disableRipple = (_i = disableRippleProp || (globalContext == null ? void 0 : globalContext.disableRipple)) != null ? _i : disableAnimation;
  const { isFocusVisible, isFocused, focusProps } = (0, import_focus.useFocusRing)({
    autoFocus
  });
  const isDisabled = isDisabledProp || isLoading;
  const styles = (0, import_react2.useMemo)(
    () => (0, import_theme.button)({
      size,
      color,
      variant,
      radius,
      fullWidth,
      isDisabled,
      isInGroup,
      disableAnimation,
      isIconOnly,
      className
    }),
    [
      size,
      color,
      variant,
      radius,
      fullWidth,
      isDisabled,
      isInGroup,
      isIconOnly,
      disableAnimation,
      className
    ]
  );
  const { onPress: onRipplePressHandler, onClear: onClearRipple, ripples } = (0, import_ripple.useRipple)();
  const handlePress = (0, import_react.useCallback)(
    (e) => {
      if (disableRipple || isDisabled || disableAnimation) return;
      domRef.current && onRipplePressHandler(e);
    },
    [disableRipple, isDisabled, disableAnimation, domRef, onRipplePressHandler]
  );
  const { buttonProps: ariaButtonProps, isPressed } = (0, import_use_aria_button.useAriaButton)(
    {
      elementType: as,
      isDisabled,
      onPress: (0, import_utils.chain)(onPress, handlePress),
      onClick,
      ...otherProps
    },
    domRef
  );
  const { isHovered, hoverProps } = (0, import_interactions.useHover)({ isDisabled });
  const getButtonProps = (0, import_react.useCallback)(
    (props2 = {}) => ({
      "data-disabled": (0, import_shared_utils.dataAttr)(isDisabled),
      "data-focus": (0, import_shared_utils.dataAttr)(isFocused),
      "data-pressed": (0, import_shared_utils.dataAttr)(isPressed),
      "data-focus-visible": (0, import_shared_utils.dataAttr)(isFocusVisible),
      "data-hover": (0, import_shared_utils.dataAttr)(isHovered),
      "data-loading": (0, import_shared_utils.dataAttr)(isLoading),
      ...(0, import_utils.mergeProps)(
        ariaButtonProps,
        focusProps,
        hoverProps,
        (0, import_react_utils2.filterDOMProps)(otherProps, {
          enabled: shouldFilterDOMProps
        }),
        (0, import_react_utils2.filterDOMProps)(props2)
      ),
      className: styles
    }),
    [
      isLoading,
      isDisabled,
      isFocused,
      isPressed,
      shouldFilterDOMProps,
      isFocusVisible,
      isHovered,
      ariaButtonProps,
      focusProps,
      hoverProps,
      otherProps,
      styles
    ]
  );
  const getIconClone = (icon) => (0, import_react2.isValidElement)(icon) ? (0, import_react2.cloneElement)(icon, {
    // @ts-ignore
    "aria-hidden": true,
    focusable: false
  }) : null;
  const startContent = getIconClone(startContentProp);
  const endContent = getIconClone(endContentProp);
  const spinnerSize = (0, import_react2.useMemo)(() => {
    const buttonSpinnerSizeMap = {
      sm: "sm",
      md: "sm",
      lg: "md"
    };
    return buttonSpinnerSizeMap[size];
  }, [size]);
  const getRippleProps = (0, import_react.useCallback)(
    () => ({ ripples, onClear: onClearRipple }),
    [ripples, onClearRipple]
  );
  return {
    Component,
    children,
    domRef,
    spinner,
    styles,
    startContent,
    endContent,
    isLoading,
    spinnerPlacement,
    spinnerSize,
    disableRipple,
    getButtonProps,
    getRippleProps,
    isIconOnly
  };
}

// src/button.tsx
var import_jsx_runtime = require("react/jsx-runtime");
var Button = (0, import_system2.forwardRef)((props, ref) => {
  const {
    Component,
    domRef,
    children,
    spinnerSize,
    spinner = /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_spinner.Spinner, { color: "current", size: spinnerSize }),
    spinnerPlacement,
    startContent,
    endContent,
    isLoading,
    disableRipple,
    getButtonProps,
    getRippleProps,
    isIconOnly
  } = useButton({ ...props, ref });
  return /* @__PURE__ */ (0, import_jsx_runtime.jsxs)(Component, { ref: domRef, ...getButtonProps(), children: [
    startContent,
    isLoading && spinnerPlacement === "start" && spinner,
    isLoading && isIconOnly ? null : children,
    isLoading && spinnerPlacement === "end" && spinner,
    endContent,
    !disableRipple && /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_ripple2.Ripple, { ...getRippleProps() })
  ] });
});
Button.displayName = "HeroUI.Button";
var button_default = Button;

// src/button-group.tsx
var import_system4 = require("@heroui/system");

// src/use-button-group.ts
var import_theme2 = require("@heroui/theme");
var import_system3 = require("@heroui/system");
var import_react_utils3 = require("@heroui/react-utils");
var import_react3 = require("react");
var import_shared_utils2 = require("@heroui/shared-utils");
function useButtonGroup(originalProps) {
  var _a, _b;
  const globalContext = (0, import_system3.useProviderContext)();
  const [props, variantProps] = (0, import_system3.mapPropsVariants)(originalProps, import_theme2.buttonGroup.variantKeys);
  const {
    ref,
    as,
    children,
    color = "default",
    size = "md",
    variant = "solid",
    radius,
    isDisabled = false,
    isIconOnly = false,
    disableRipple = (_a = globalContext == null ? void 0 : globalContext.disableRipple) != null ? _a : false,
    disableAnimation = (_b = globalContext == null ? void 0 : globalContext.disableAnimation) != null ? _b : false,
    className,
    ...otherProps
  } = props;
  const Component = as || "div";
  const domRef = (0, import_react_utils3.useDOMRef)(ref);
  const classNames = (0, import_react3.useMemo)(
    () => (0, import_theme2.buttonGroup)({
      ...variantProps,
      className
    }),
    [(0, import_shared_utils2.objectToDeps)(variantProps), className]
  );
  const context = (0, import_react3.useMemo)(
    () => ({
      size,
      color,
      variant,
      radius,
      isIconOnly,
      isDisabled,
      disableAnimation,
      disableRipple,
      fullWidth: !!(originalProps == null ? void 0 : originalProps.fullWidth)
    }),
    [
      size,
      color,
      variant,
      radius,
      isDisabled,
      isIconOnly,
      disableAnimation,
      disableRipple,
      originalProps == null ? void 0 : originalProps.fullWidth
    ]
  );
  const getButtonGroupProps = (0, import_react3.useCallback)(
    () => ({
      role: "group",
      ...otherProps
    }),
    [otherProps]
  );
  return {
    Component,
    children,
    domRef,
    context,
    classNames,
    getButtonGroupProps
  };
}

// src/button-group.tsx
var import_jsx_runtime2 = require("react/jsx-runtime");
var ButtonGroup = (0, import_system4.forwardRef)((props, ref) => {
  const { Component, domRef, context, children, classNames, getButtonGroupProps } = useButtonGroup({
    ...props,
    ref
  });
  return /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(ButtonGroupProvider, { value: context, children: /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(Component, { ref: domRef, className: classNames, ...getButtonGroupProps(), children }) });
});
ButtonGroup.displayName = "HeroUI.ButtonGroup";
var button_group_default = ButtonGroup;
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  Button,
  ButtonGroup,
  ButtonGroupProvider,
  useButton,
  useButtonGroup,
  useButtonGroupContext
});
