<p align="center">
  <a href="https://tailwind-variants.org">
    <img width="20%" src=".github/assets/isotipo.png" alt="tailwind-variants" />
    <h1 align="center">tailwind-variants</h1>
  </a>
</p>
<p align="center">
  The <em>power</em> of Tailwind combined with a <em>first-class</em> variant API.<br><br>
  <a href="https://www.npmjs.com/package/tailwind-variants">
    <img src="https://img.shields.io/npm/dm/tailwind-variants.svg?style=flat-round" alt="npm downloads">
  </a>
  <a href="https://www.npmjs.com/package/tailwind-variants">
    <img alt="NPM Version" src="https://badgen.net/npm/v/tailwind-variants" />
  </a>
  <a href="https://github.com/nextui-org/tailwind-variants/blob/main/LICENSE">
    <img src="https://img.shields.io/npm/l/tailwind-variants?style=flat" alt="License">
  </a>
</p>

## Features

- First-class variant API
- Responsive variants
- Slots support
- Composition support
- Fully typed
- Framework agnostic
- Automatic conflict resolution

## Documentation

For full documentation, visit [tailwind-variants.org](https://tailwind-variants.org)

## Quick Start

1. Installation:
   To use Tailwind Variants in your project, you can install it as a dependency:

```bash
yarn add tailwind-variants
# or
npm i tailwind-variants
```

2. Usage:

```js
import {tv} from "tailwind-variants";

const button = tv({
  base: "font-medium bg-blue-500 text-white rounded-full active:opacity-80",
  variants: {
    color: {
      primary: "bg-blue-500 text-white",
      secondary: "bg-purple-500 text-white",
    },
    size: {
      sm: "text-sm",
      md: "text-base",
      lg: "px-4 py-3 text-lg",
    },
  },
  compoundVariants: [
    {
      size: ["sm", "md"],
      class: "px-3 py-1",
    },
  ],
  defaultVariants: {
    size: "md",
    color: "primary",
  },
});

return <button className={button({size: "sm", color: "secondary"})}>Click me</button>;
```

3. Responsive variants configuration (optional): If you want to use responsive variants
   you need to add the Tailwind Variants `wrapper` to your TailwindCSS config file `tailwind.config.js`.

```js
// tailwind.config.js

const {withTV} = require("tailwind-variants/transformer");

/** @type {import('tailwindcss').Config} */
module.exports = withTV({
  content: ["./index.html", "./src/**/*.{js,ts,jsx,tsx}"],
  theme: {
    extend: {},
  },
  plugins: [],
});
```

If you're using a custom path to import Tailwind variants, such as creating a custom tv instance with `createTV`, it's recommended to include this path in the transformer configuration:

```js
// tailwind.config.js

const {withTV} = require("tailwind-variants/transformer");

/** @type {import('tailwindcss').Config} */
module.exports = withTV(
  {
    content: ["./index.html", "./src/**/*.{js,ts,jsx,tsx}"],
    theme: {
      extend: {},
    },
    plugins: [],
  },
  {
    aliases: ["@/lib/tv"],
  },
);
```

## Acknowledgements

- [**cva**](https://github.com/joe-bell/cva) ([Joe Bell](https://github.com/joe-bell))
  This project as started as an extension of Joe's work on `cva` – a great tool for generating variants for a single element with Tailwind CSS. Big shoutout to [Joe Bell](https://github.com/joe-bell) and [contributors](https://github.com/joe-bell/cva/graphs/contributors) you guys rock! 🤘 - we recommend to use `cva` if don't need any of the **Tailwind Variants** features listed [here](https://www.tailwind-variants.org/docs/comparison).

- [**Stitches**](https://stitches.dev/) ([Modulz](https://modulz.app))  
  The pioneers of the `variants` API movement. Inmense thanks to [Modulz](https://modulz.app) for their work on Stitches and the community around it. 🙏

## Community

We're excited to see the community adopt NextUI, raise issues, and provide feedback. Whether it's a feature request, bug report, or a project to showcase, please get involved!

- [Discord](https://discord.gg/9b6yyZKmH4)
- [Twitter](https://twitter.com/getnextui)
- [GitHub Discussions](https://github.com/nextui-org/tailwind-variants/discussions)

## Contributing

Contributions are always welcome!

Please follow our [contributing guidelines](./CONTRIBUTING.md).

Please adhere to this project's [CODE_OF_CONDUCT](./CODE_OF_CONDUCT.md).

## Authors

- Junior garcia ([@jrgarciadev](https://github.com/jrgaciadev))
- Tianen Pang ([@tianenpang](https://github.com/tianenpang))

## License

Licensed under the MIT License.

See [LICENSE](./LICENSE.md) for more information.
