<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Projects - Izhak</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="icon" href="icon.png" type="image/png">
    <link href="https://api.fontshare.com/v2/css?f[]=cabinet-grotesk@400,500,700,800&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <style>
        :root {
            --bg-light: #ffffff;
            --bg-dark: #121212;
            --text-light: #121212;
            --text-dark: #f5f5f5;
            --border-light: rgba(0, 0, 0, 0.1);
            --border-dark: rgba(255, 255, 255, 0.1);
        }

        @media (prefers-color-scheme: dark) {
            body {
                background-color: var(--bg-dark);
                color: var(--text-dark);
            }
            .header-border {
                border-top: 1px solid var(--text-dark);
                border-bottom: 1px solid var(--text-dark);
                background-color: rgba(18, 18, 18, 0.8);
            }
            .border-custom {
                border-color: var(--border-dark);
            }
        }

        @media (prefers-color-scheme: light) {
            body {
                background-color: var(--bg-light);
                color: var(--text-light);
            }
            .header-border {
                border-top: 1px solid var(--text-light);
                border-bottom: 1px solid var(--text-light);
                background-color: rgba(255, 255, 255, 0.8);
            }
            .border-custom {
                border-color: var(--border-light);
            }
        }

        body {
            font-family: 'Cabinet Grotesk', sans-serif;
            transition: background-color 0.3s ease, color 0.3s ease;
            margin: 0;
            padding: 0;
        }

        .header-border {
            backdrop-filter: blur(10px);
        }

        @keyframes slideUp {
            from {
                opacity: 0;
                transform: translateY(30px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .slide-up {
            opacity: 0;
            animation: slideUp 0.6s cubic-bezier(0.4, 0, 0.2, 1) forwards;
        }

        .delay-1 {animation-delay: 0.1s;}
        .delay-2 {animation-delay: 0.2s;}
        .delay-3 {animation-delay: 0.3s;}
        .delay-4 {animation-delay: 0.4s;}

        .hero-section {
            height: 60vh;
            display: flex;
            align-items: center;
            justify-content: center;
            text-align: center;
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 2rem;
        }

        .section-header {
            background: rgba(0,0,0,0.02);
            border-bottom: 1px solid var(--border-light);
            padding: 2rem 0;
        }

        @media (prefers-color-scheme: dark) {
            .section-header {
                background: rgba(255,255,255,0.02);
                border-color: var(--border-dark);
            }
        }

        .section-title {
            font-size: 0.8rem;
            text-transform: uppercase;
            letter-spacing: 0.15em;
            opacity: 0.4;
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 2rem;
        }

        .project-item {
            border-bottom: 1px solid var(--border-light);
            padding: 0;
        }

        @media (prefers-color-scheme: dark) {
            .project-item {
                border-color: var(--border-dark);
            }
        }

        .project-link {
            display: flex;
            align-items: center;
            gap: 2rem;
            padding: 3rem 2rem;
            text-decoration: none;
            color: inherit;
            transition: opacity 0.2s ease;
            max-width: 1200px;
            margin: 0 auto;
        }

        .project-link:hover {
            opacity: 0.7;
        }

        .project-number {
            font-size: 1.2rem;
            font-weight: 300;
            opacity: 0.5;
            min-width: 3rem;
        }

        .project-info {
            flex: 1;
        }

        .project-title {
            font-size: 1.8rem;
            font-weight: 300;
            margin-bottom: 0.5rem;
            letter-spacing: -0.01em;
        }

        .project-description {
            font-size: 0.95rem;
            opacity: 0.6;
            line-height: 1.5;
        }

        .project-meta {
            display: flex;
            align-items: center;
            gap: 1.5rem;
        }

        .project-status {
            font-size: 0.8rem;
            text-transform: uppercase;
            letter-spacing: 0.1em;
            opacity: 0.5;
        }

        .project-icon {
            font-size: 1.2rem;
            opacity: 0.3;
        }

        .cta-section {
            padding: 4rem 2rem;
            text-align: center;
            max-width: 1200px;
            margin: 0 auto;
        }

        .button-custom {
            background-color: var(--text-light);
            color: var(--bg-light);
            padding: 1rem 2rem;
            border-radius: 2rem;
            font-size: 0.9rem;
            font-weight: 300;
            letter-spacing: 0.05em;
            transition: opacity 0.2s ease;
            text-decoration: none;
            display: inline-block;
        }

        @media (prefers-color-scheme: dark) {
            .button-custom {
                background-color: var(--text-dark);
                color: var(--bg-dark);
            }
        }

        .button-custom:hover {
            opacity: 0.8;
        }

        @media (max-width: 768px) {
            .hero-section {
                height: 50vh;
                padding: 0 1rem;
            }
            
            .project-link {
                padding: 2rem 1rem;
                flex-direction: column;
                align-items: flex-start;
                gap: 1rem;
            }
            
            .project-meta {
                align-self: flex-end;
            }
            
            .project-title {
                font-size: 1.4rem;
            }
            
            .section-title {
                padding: 0 1rem;
            }
            
            .cta-section {
                padding: 3rem 1rem;
            }
        }
    </style>
</head>
<body class="min-h-screen">
    <header class="header-border py-6 sticky top-0 z-50 slide-up">
        <div class="max-width-1200px mx-auto px-6">
            <div class="flex justify-between items-center">
                <h1 class="text-2xl font-light tracking-tight">Izhak</h1>
                <a href="index.html" class="text-sm font-light hover:opacity-70 transition-opacity">← Back</a>
            </div>
        </div>
    </header>

    <section class="hero-section slide-up delay-1">
        <div>
            <h2 class="text-4xl md:text-6xl font-light tracking-tight mb-4">Selected Work for you</h2>
            <p class="text-lg md:text-xl font-light opacity-70 max-w-2xl mx-auto">
                A curated collection of digital experiences, from concept to completion
            </p>
        </div>
    </section>

    <main>
        <div class="section-header slide-up delay-2">
            <h3 class="section-title">Active Projects or realisations</h3>
        </div>
        
        <div class="project-item slide-up delay-3">
            <a href="https://imators.com" class="project-link" target="_blank">
                <div class="project-number">01</div>
                <div class="project-info">
                    <div class="project-title">Imators</div>
                    <div class="project-description">IT company focused on innovation and the creation of products to accompany life without spoiling it.</div>
                </div>
                <div class="project-meta">
                    <div class="project-status">See more</div>
                    <div class="project-icon"><i class="fas fa-share"></i></div>
                </div>
            </a>
        </div>

        <div class="project-item slide-up delay-4">
            <a href="https://vertchasseur.com" class="project-link" target="_blank">
                <div class="project-number">02</div>
                <div class="project-info">
                    <div class="project-title">Neighbourhood Vert Chasseur</div>
                    <div class="project-description">This site was created to provide information about this upscale neighborhood.</div>
                </div>
                <div class="project-meta">
                    <div class="project-status">See more</div>
                    <div class="project-icon"><i class="fas fa-share"></i></div>
                </div>
            </a>
        </div>

        <div class="project-item">
            <a href="https://aktascorp.com" class="project-link">
                <div class="project-number">03</div>
                <div class="project-info">
                    <div class="project-title">the aktascorp website</div>
                    <div class="project-description">design of the website of my parent company of my works</div>
                </div>
                <div class="project-meta">
                    <div class="project-status">See more</div>
                    <div class="project-icon"><i class="fas fa-share"></i></div>
                </div>
            </a>
        </div>

        <div class="project-item">
            <a href="https://peerkinton.com" class="project-link">
                <div class="project-number">04</div>
                <div class="project-info">
                    <div class="project-title">Peerkinton</div>
                    <div class="project-description">A private Minecraft server with an entire active civilization of players.</div>
                </div>
                <div class="project-meta">
                    <div class="project-status">See more</div>
                    <div class="project-icon"><i class="fas fa-share"></i></div>
                </div>
            </a>
        </div>
        
        <div class="project-item slide-up delay-3">
            <a href="https://imators.systems/Revo" class="project-link" target="_blank">
                <div class="project-number">05</div>
                <div class="project-info">
                    <div class="project-title">MDJ</div>
                    <div class="project-description">A website for a client created to illustrate their magnificent Minecraft Dungeon project available on the Java edition of the game.</div>
                </div>
                <div class="project-meta">
                    <div class="project-status">See more</div>
                    <div class="project-icon"><i class="fas fa-share"></i></div>
                </div>
            </a>
        </div>
        


        <section class="cta-section">
            <h2 class="text-3xl md:text-4xl font-light mb-6">Ready to start something new?</h2>
            <p class="text-lg font-light opacity-70 mb-8 max-w-2xl mx-auto">
                Let's collaborate on your next project and create something meaningful together
            </p>
            <a href="mailto:izhak@imators.com" class="button-custom">
                Get in touch
            </a>
        </section>
    </main>

    <footer class="py-8 text-center text-sm font-light opacity-50">
        <p>Designed with a smile.</p>
    </footer>
</body>
</html>