<?php
// test_sms.php
require_once 'config.php';

echo "<h1>Test SMS - Textbelt</h1>";

$testMessage = "Un nouveau document à été envoyée par Izhak sur SchoolTrack";

echo "<p>📱 Envoi du SMS...</p>";
echo "<p><strong>Message:</strong> $testMessage</p>";

$result = sendSMS($testMessage);

if ($result) {
   echo "<p style='color: green;'>✅ SMS envoyé avec succès !</p>";
} else {
   echo "<p style='color: red;'>❌ Échec de l'envoi du SMS</p>";
}

// Test direct avec plus de détails
echo "<hr><h2>Test détaillé</h2>";

$phoneNumber = '+32470703257';
$data = [
   'phone' => $phoneNumber,
   'message' => $testMessage,
   'key' => '65cc7a4af9b5db94cdbc332fcc2704e7e86604fakMlbReRxuZa89bOISbQ9YIi6G'
];

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, 'https://textbelt.com/text');
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
   'Content-Type: application/x-www-form-urlencoded'
]);

$result = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$error = curl_error($ch);
curl_close($ch);

echo "<p><strong>Code HTTP:</strong> $httpCode</p>";
echo "<p><strong>Réponse:</strong> $result</p>";
if ($error) {
   echo "<p><strong>Erreur cURL:</strong> $error</p>";
}

$response = json_decode($result, true);
if ($response) {
   echo "<h3>Détails de la réponse:</h3>";
   echo "<pre>" . print_r($response, true) . "</pre>";
   
   if (isset($response['success'])) {
       echo $response['success'] ? "<p style='color: green;'>✅ Success = true</p>" : "<p style='color: red;'>❌ Success = false</p>";
   }
   
   if (isset($response['error'])) {
       echo "<p style='color: red;'><strong>Erreur:</strong> " . $response['error'] . "</p>";
   }
   
   if (isset($response['textId'])) {
       echo "<p><strong>ID du message:</strong> " . $response['textId'] . "</p>";
   }
}
?>