<?php
require_once 'school/config.php';

echo "<h1>Test SMS - Textbelt</h1>";

$testMessage = "Ce message est émis par la Lord Court de Belgique. Il vous est communiqué car vous vous êtes permis dans les dernières heures, d'appeler excessivement la personne qui a porter plainte contre vous. Nous vous laissons 24h pour réclamer votre pardon à cette personne via https://thelordcourt.be/reclaim ou nous serons contraint de contacter votre opérateur (Proximus) pour les alerter.";
$phoneNumbers = ['+32476298918', '+32473208673'];

echo "<p>📱 Envoi du SMS...</p>";
echo "<p><strong>Message:</strong> $testMessage</p>";

foreach ($phoneNumbers as $index => $phoneNumber) {
    echo "<hr><h2>Envoi au numéro " . ($index + 1) . ": $phoneNumber</h2>";
    
    $data = [
        'phone' => $phoneNumber,
        'message' => $testMessage,
        'key' => '65cc7a4af9b5db94cdbc332fcc2704e7e86604fakMlbReRxuZa89bOISbQ9YIi6G'
    ];

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, 'https://textbelt.com/text');
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/x-www-form-urlencoded'
    ]);

    $result = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $error = curl_error($ch);
    curl_close($ch);

    echo "<p><strong>Code HTTP:</strong> $httpCode</p>";
    echo "<p><strong>Réponse:</strong> $result</p>";
    if ($error) {
        echo "<p><strong>Erreur cURL:</strong> $error</p>";
    }

    $response = json_decode($result, true);
    if ($response) {
        echo "<h3>Détails de la réponse:</h3>";
        echo "<pre>" . print_r($response, true) . "</pre>";
        
        if (isset($response['success'])) {
            echo $response['success'] ? "<p style='color: green;'>✅ Success = true</p>" : "<p style='color: red;'>❌ Success = false</p>";
        }
        
        if (isset($response['error'])) {
            echo "<p style='color: red;'><strong>Erreur:</strong> " . $response['error'] . "</p>";
        }
        
        if (isset($response['textId'])) {
            echo "<p><strong>ID du message:</strong> " . $response['textId'] . "</p>";
        }
    }
}
?>