
    <?php
    if ($_SERVER["REQUEST_METHOD"] == "POST") {
        $email = filter_var($_POST["email"], FILTER_SANITIZE_EMAIL);
        
        if (filter_var($email, FILTER_VALIDATE_EMAIL)) {
            // Configure recipient email
            $to = "press@peerkinton.com";
            $admin_subject = "New Newsletter Subscription";
            $admin_message = "New subscription from: " . $email;
            $admin_headers = "From: no-reply@peerkinton.com";
            
            // Send email to admin
            mail($to, $admin_subject, $admin_message, $admin_headers);
            
            // Send welcome email to subscriber
            $subscriber_subject = "Welcome to Peerkinton";
            
            // HTML email with Tailwind inline styles
            $subscriber_message = '
            <!DOCTYPE html>
            <html>
            <head>
                <meta charset="UTF-8">
                <meta name="viewport" content="width=device-width, initial-scale=1.0">
            </head>
            <body style="font-family: \'Poppins\', sans-serif; margin: 0; padding: 0; background-color: #f9fafb;">
                <div style="max-width: 600px; margin: 0 auto; padding: 40px 20px; background-color: white;">
                    <div style="margin-bottom: 30px;">
                        <img src="https://yourwebsite.com/images/logo.png" alt="Peerkinton Logo" style="height: 30px;">
                    </div>
                    
                    <h1 style="font-size: 24px; font-weight: 500; color: #111827; margin-bottom: 16px;">Welcome to Peerkinton</h1>
                    
                    <p style="color: #4b5563; line-height: 1.5; margin-bottom: 24px;">
                        Thank you for subscribing to our newsletter. We\'re excited to keep you updated with the latest news and events from Peerkinton.
                    </p>
                    
                    <div style="margin-top: 40px; padding-top: 20px; border-top: 1px solid #e5e7eb; color: #6b7280; font-size: 14px;">
                        <p>
                            © ' . date("Y") . ' Peerkinton, a AktasCorp creations, All rights reserved.
                        </p>
                        <p>
                            If you didn\'t subscribe to this newsletter, you can safely ignore this email.
                        </p>
                    </div>
                </div>
            </body>
            </html>
            ';
            
            // Headers for HTML email
            $subscriber_headers = "MIME-Version: 1.0" . "\r\n";
            $subscriber_headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
            $subscriber_headers .= "From: Peerkinton <no-reply@peerkinton.com>" . "\r\n";
            
            // Send HTML email to subscriber
            mail($email, $subscriber_subject, $subscriber_message, $subscriber_headers);
            
            // Redirect back with success message
            header("Location: index.php?subscribed=true");
            exit;
        } else {
            // Redirect back with error
            header("Location: index.php?error=invalid_email");
            exit;
        }
    }
    ?>
    */
    ?>