/*
 * Decompiled with CFR 0.152.
 */
package fr.imators.shop.gui;

import fr.imators.shop.ImatorsShop;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class ShopCreationGUI
implements Listener {
    private static Map<Player, ShopCreationGUI> activeGUIs = new HashMap<Player, ShopCreationGUI>();
    private Player player;
    private String shopName;
    private boolean waitingForName = false;

    public ShopCreationGUI() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)ImatorsShop.getInstance());
    }

    public void open(Player player) {
        this.player = player;
        activeGUIs.put(player, this);
        Inventory inv = Bukkit.createInventory(null, (int)27, (String)(String.valueOf(ChatColor.DARK_BLUE) + "Cr\u00e9er une boutique"));
        ItemStack nameItem = new ItemStack(Material.NAME_TAG);
        ItemMeta nameMeta = nameItem.getItemMeta();
        nameMeta.setDisplayName(String.valueOf(ChatColor.YELLOW) + "D\u00e9finir le nom de la boutique");
        nameMeta.setLore(Arrays.asList(String.valueOf(ChatColor.GRAY) + "Clique pour d\u00e9finir le nom", String.valueOf(ChatColor.GRAY) + "de ta boutique"));
        nameItem.setItemMeta(nameMeta);
        ItemStack createItem = new ItemStack(Material.EMERALD);
        ItemMeta createMeta = createItem.getItemMeta();
        createMeta.setDisplayName(String.valueOf(ChatColor.GREEN) + "Cr\u00e9er la boutique");
        createMeta.setLore(Arrays.asList(String.valueOf(ChatColor.GRAY) + "Clique pour cr\u00e9er ta boutique", String.valueOf(ChatColor.GRAY) + "sur la pancarte que tu regardes", this.shopName != null ? String.valueOf(ChatColor.YELLOW) + "Nom: " + this.shopName : String.valueOf(ChatColor.RED) + "Nom non d\u00e9fini"));
        createItem.setItemMeta(createMeta);
        ItemStack cancelItem = new ItemStack(Material.BARRIER);
        ItemMeta cancelMeta = cancelItem.getItemMeta();
        cancelMeta.setDisplayName(String.valueOf(ChatColor.RED) + "Annuler");
        cancelItem.setItemMeta(cancelMeta);
        inv.setItem(11, nameItem);
        inv.setItem(13, createItem);
        inv.setItem(15, cancelItem);
        player.openInventory(inv);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        if (!activeGUIs.containsKey(player)) {
            return;
        }
        if (!event.getView().getTitle().equals(String.valueOf(ChatColor.DARK_BLUE) + "Cr\u00e9er une boutique")) {
            return;
        }
        event.setCancelled(true);
        if (event.getCurrentItem() == null) {
            return;
        }
        ShopCreationGUI gui = activeGUIs.get(player);
        switch (event.getCurrentItem().getType()) {
            case NAME_TAG: {
                player.closeInventory();
                player.sendMessage(String.valueOf(ChatColor.YELLOW) + "\u00c9cris le nom de ta boutique dans le chat :");
                gui.waitingForName = true;
                break;
            }
            case EMERALD: {
                if (gui.shopName == null) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Tu dois d'abord d\u00e9finir un nom !");
                    return;
                }
                Block targetBlock = player.getTargetBlockExact(5);
                if (targetBlock == null || !(targetBlock.getState() instanceof Sign)) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Tu dois regarder une pancarte !");
                    return;
                }
                if (ImatorsShop.getInstance().getShopManager().createShop(targetBlock.getLocation(), player.getUniqueId().toString(), gui.shopName)) {
                    player.sendMessage(String.valueOf(ChatColor.GREEN) + "Boutique cr\u00e9\u00e9e avec succ\u00e8s !");
                    player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Utilise /ishop pour g\u00e9rer tes articles !");
                } else {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Erreur lors de la cr\u00e9ation de la boutique !");
                }
                player.closeInventory();
                activeGUIs.remove(player);
                break;
            }
            case BARRIER: {
                player.closeInventory();
                activeGUIs.remove(player);
                player.sendMessage(String.valueOf(ChatColor.RED) + "Cr\u00e9ation annul\u00e9e !");
            }
        }
    }

    @EventHandler
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        if (!activeGUIs.containsKey(player)) {
            return;
        }
        ShopCreationGUI gui = activeGUIs.get(player);
        if (!gui.waitingForName) {
            return;
        }
        event.setCancelled(true);
        String name = event.getMessage().trim();
        if (name.length() > 20) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Le nom est trop long (max 20 caract\u00e8res) !");
            return;
        }
        gui.shopName = name;
        gui.waitingForName = false;
        player.sendMessage(String.valueOf(ChatColor.GREEN) + "Nom d\u00e9fini : " + name);
        Bukkit.getScheduler().runTask((Plugin)ImatorsShop.getInstance(), () -> gui.open(player));
    }
}

