<?php
/**
 * Plugin Name: Countdown Time - Block
 * Description: Display your events date into a timer to your visitor with countdown time block
 * Version: 1.1.7
 * Author: bPlugins LLC
 * Author URI: http://bplugins.com
 * License: GPLv3
 * License URI: https://www.gnu.org/licenses/gpl-3.0.txt
 * Text Domain: countdown-time
 */

// ABS PATH
if ( !defined( 'ABSPATH' ) ) { exit; }

// Constant
define( 'CTB_PLUGIN_VERSION', isset( $_SERVER['HTTP_HOST'] ) && 'localhost' === $_SERVER['HTTP_HOST'] ? time() : '1.1.7' );
define( 'CTB_ASSETS_DIR', plugin_dir_url( __FILE__ ) . 'assets/' );

// Countdown Time
class CTBCountdownTime{
	function __construct(){
		register_activation_hook( __FILE__, [$this, 'onPluginActivate'] );
		
		if ( version_compare( $GLOBALS['wp_version'], '5.8-alpha-1', '<' ) ) {
			add_filter( 'block_categories', [$this, 'blockCategories'] );
		} else { add_filter( 'block_categories_all', [$this, 'blockCategories'] ); }

		add_action( 'init', [$this, 'onInit'] );
	}

	function onPluginActivate(){
		if ( is_plugin_active( 'countdown-time-pro/plugin.php' ) ){
			deactivate_plugins( 'countdown-time-pro/plugin.php' );
		}
	} // Deactivate pro if active

	function blockCategories( $categories ){
		return array_merge( [[
			'slug'	=> 'CTBlock',
			'title'	=> 'Countdown Time',
		] ], $categories );
	} // Categories
	
	function onInit() {
		wp_register_script( 'ctb-countdown-time-script', plugins_url( 'dist/script.js', __FILE__ ), [ 'react', 'react-dom' ], CTB_PLUGIN_VERSION, true ); // Frontend Script

		wp_register_style( 'ctb-countdown-time-style', plugins_url( 'dist/style.css', __FILE__ ), [], CTB_PLUGIN_VERSION ); // Style

		wp_register_style( 'ctb-countdown-time-editor-style', plugins_url( 'dist/editor.css', __FILE__ ), [ 'ctb-countdown-time-style' ], CTB_PLUGIN_VERSION ); // Backend Style

		register_block_type( __DIR__, [
			'editor_style'		=> 'ctb-countdown-time-editor-style',
			'render_callback'	=> [$this, 'render']
		] ); // Register Block
		
		wp_set_script_translations( 'ctb-countdown-time-editor-script', 'countdown-time', plugin_dir_path( __FILE__ ) . '/languages' ); // Translate
	}

	function render( $attributes ){
		extract( $attributes );

		// Enqueue assets where has block
		wp_enqueue_script( 'ctb-countdown-time-script' );
		wp_enqueue_style( 'ctb-countdown-time-style' );

		$className = $className ?? '';
		$blockClassName = "wp-block-ctb-countdown-time $className align$align";

		ob_start(); ?>
		<div class='<?php echo esc_attr( $blockClassName ); ?>' id='ctbCountdownTime-<?php echo esc_attr( $cId ) ?>' data-attributes='<?php echo esc_attr( wp_json_encode( $attributes ) ); ?>'></div>

		<?php return ob_get_clean();
	} // Render
}
new CTBCountdownTime;