<?php

namespace DevOwl\RealCookieBanner\templates;

use DevOwl\RealCookieBanner\base\UtilsProvider;
use DevOwl\RealCookieBanner\Core;
use DevOwl\RealCookieBanner\lite\view\customize\banner\TcfBodyDesign;
use DevOwl\RealCookieBanner\view\customize\banner\BasicLayout;
use DevOwl\RealCookieBanner\view\customize\banner\individual\Group;
use DevOwl\RealCookieBanner\view\customize\banner\individual\Texts as IndividualTexts;
use DevOwl\RealCookieBanner\view\customize\banner\Texts;
use ReflectionClass;
use DevOwl\RealCookieBanner\view\customize\banner\Design;
use DevOwl\RealCookieBanner\view\customize\banner\HeaderDesign;
use DevOwl\RealCookieBanner\view\customize\banner\BodyDesign;
use DevOwl\RealCookieBanner\view\customize\banner\FooterDesign;
use DevOwl\RealCookieBanner\view\customize\banner\individual\SaveButton;
use DevOwl\RealCookieBanner\view\customize\banner\individual\Layout;
use DevOwl\RealCookieBanner\view\customize\banner\Decision;
// @codeCoverageIgnoreStart
\defined('ABSPATH') or die('No script kiddies please!');
// Avoid direct file request
// @codeCoverageIgnoreEnd
/**
 * Predefined templates for cookie banner.
 */
class BannerTemplates
{
    use UtilsProvider;
    /**
     * Get all available templates.
     */
    public function get()
    {
        /**
         * Filters available templates for cookie banner customize.
         *
         * @hook RCB/Presets/Banner
         * @param {array} $templates All available templates
         * @returns {array}
         */
        return \apply_filters('RCB/Presets/Banner', ['light' => ['name' => \__('Light Dialog', RCB_TD), 'description' => \__('Standard design for the cookie consent as a dialog.', RCB_TD), 'settings' => []], 'light-banner' => ['name' => \__('Light Banner', RCB_TD), 'description' => \__('Standard design for the cookie consent as a banner.', RCB_TD), 'settings' => [BasicLayout::SETTING_TYPE => 'banner', BasicLayout::SETTING_OVERLAY => \false, Design::SETTING_TEXT_ALIGN => 'left', Design::SETTING_BOX_SHADOW_OFFSET_Y => 0, Design::SETTING_BOX_SHADOW_BLUR_RADIUS => 17, FooterDesign::SETTING_PADDING => [10, 20, 12, 20], Layout::SETTING_INHERIT_BANNER_MAX_WIDTH => \false]], 'dark' => ['name' => \__('Dark Dialog', RCB_TD), 'description' => \__('Standard design for the cookie consent as a dialog in dark mode.', RCB_TD), 'needsPro' => \true, 'settings' => \array_merge([Design::SETTING_COLOR_BG => '#222222', Design::SETTING_FONT_COLOR => '#f9f9f9', HeaderDesign::SETTING_FONT_COLOR => '#ffffff', HeaderDesign::SETTING_BOTTOM_BORDER_COLOR => '#191919', BodyDesign::SETTING_TEACHINGS_FONT_COLOR => '#afafaf', BodyDesign::SETTING_BUTTON_ACCEPT_ESSENTIALS_BG => '#2d2d2d', BodyDesign::SETTING_BUTTON_ACCEPT_ESSENTIALS_FONT_COLOR => '#ffffff', BodyDesign::SETTING_BUTTON_ACCEPT_ESSENTIALS_BORDER_COLOR => '#067070', BodyDesign::SETTING_BUTTON_ACCEPT_ESSENTIALS_HOVER_BG => '#333333', BodyDesign::SETTING_BUTTON_ACCEPT_ESSENTIALS_HOVER_FONT_COLOR => '#ffffff', BodyDesign::SETTING_BUTTON_ACCEPT_ESSENTIALS_HOVER_BORDER_COLOR => '#067d7d', BodyDesign::SETTING_BUTTON_ACCEPT_INDIVIDUAL_FONT_COLOR => '#969696', BodyDesign::SETTING_BUTTON_ACCEPT_INDIVIDUAL_HOVER_FONT_COLOR => '#d3d3d3', FooterDesign::SETTING_BG => '#141414', FooterDesign::SETTING_FONT_COLOR => '#969696', FooterDesign::SETTING_HOVER_FONT_COLOR => '#d3d3d3', FooterDesign::SETTING_TOP_BORDER_COLOR => '#0f0f0f', Group::SETTING_CHECKBOX_BG => '#2d2d2d', Group::SETTING_CHECKBOX_BORDER_COLOR => '#333333', Group::SETTING_GROUP_BORDER_COLOR => '#424242', Group::SETTING_HEADLINE_COLOR => '#ffffff', Group::SETTING_DESCRIPTION_COLOR => '#ffffff', Group::SETTING_LINK_COLOR => '#969696', Group::SETTING_LINK_HOVER_COLOR => '#d3d3d3', SaveButton::SETTING_BG => '#2d2d2d', SaveButton::SETTING_FONT_COLOR => '#ffffff', SaveButton::SETTING_BORDER_COLOR => '#067d7d', SaveButton::SETTING_HOVER_BG => '#333333', SaveButton::SETTING_HOVER_FONT_COLOR => '#ffffff', SaveButton::SETTING_HOVER_BORDER_COLOR => '#067070'], $this->isPro() ? [TcfBodyDesign::SETTING_STACKS_BG => '#222222', TcfBodyDesign::SETTING_STACKS_ACTIVE_BG => '#2d2d2d', TcfBodyDesign::SETTING_STACKS_HOVER_BG => '#2d2d2d', TcfBodyDesign::SETTING_STACKS_BORDER_COLOR => '#2d2d2d', TcfBodyDesign::SETTING_STACKS_TITLE_FONT_COLOR => '#f9f9f9', TcfBodyDesign::SETTING_STACKS_DESCRIPTION_FONT_COLOR => '#afafaf'] : [])], 'dark-banner' => ['name' => \__('Dark Banner', RCB_TD), 'description' => \__('Standard design for the cookie consent as a banner in dark mode.', RCB_TD), 'needsPro' => \true, 'settings' => \array_merge([BasicLayout::SETTING_TYPE => 'banner', BasicLayout::SETTING_OVERLAY => \false, Design::SETTING_COLOR_BG => '#222222', Design::SETTING_TEXT_ALIGN => 'left', Design::SETTING_FONT_COLOR => '#f9f9f9', Design::SETTING_BOX_SHADOW_OFFSET_Y => 0, Design::SETTING_BOX_SHADOW_BLUR_RADIUS => 17, HeaderDesign::SETTING_FONT_COLOR => '#ffffff', HeaderDesign::SETTING_BOTTOM_BORDER_COLOR => '#191919', BodyDesign::SETTING_TEACHINGS_FONT_COLOR => '#afafaf', BodyDesign::SETTING_BUTTON_ACCEPT_ESSENTIALS_BG => '#2d2d2d', BodyDesign::SETTING_BUTTON_ACCEPT_ESSENTIALS_FONT_COLOR => '#ffffff', BodyDesign::SETTING_BUTTON_ACCEPT_ESSENTIALS_BORDER_COLOR => '#067070', BodyDesign::SETTING_BUTTON_ACCEPT_ESSENTIALS_HOVER_BG => '#333333', BodyDesign::SETTING_BUTTON_ACCEPT_ESSENTIALS_HOVER_FONT_COLOR => '#ffffff', BodyDesign::SETTING_BUTTON_ACCEPT_ESSENTIALS_HOVER_BORDER_COLOR => '#067d7d', BodyDesign::SETTING_BUTTON_ACCEPT_INDIVIDUAL_FONT_COLOR => '#969696', BodyDesign::SETTING_BUTTON_ACCEPT_INDIVIDUAL_HOVER_FONT_COLOR => '#d3d3d3', FooterDesign::SETTING_BG => '#141414', FooterDesign::SETTING_FONT_COLOR => '#969696', FooterDesign::SETTING_HOVER_FONT_COLOR => '#d3d3d3', FooterDesign::SETTING_TOP_BORDER_COLOR => '#0f0f0f', Layout::SETTING_INHERIT_BANNER_MAX_WIDTH => \false, Group::SETTING_CHECKBOX_BG => '#2d2d2d', Group::SETTING_CHECKBOX_BORDER_COLOR => '#333333', Group::SETTING_GROUP_BORDER_COLOR => '#424242', Group::SETTING_HEADLINE_COLOR => '#ffffff', Group::SETTING_DESCRIPTION_COLOR => '#ffffff', Group::SETTING_LINK_COLOR => '#969696', Group::SETTING_LINK_HOVER_COLOR => '#d3d3d3', SaveButton::SETTING_BG => '#2d2d2d', SaveButton::SETTING_FONT_COLOR => '#ffffff', SaveButton::SETTING_BORDER_COLOR => '#067d7d', SaveButton::SETTING_HOVER_BG => '#333333', SaveButton::SETTING_HOVER_FONT_COLOR => '#ffffff', SaveButton::SETTING_HOVER_BORDER_COLOR => '#067070'], $this->isPro() ? [TcfBodyDesign::SETTING_STACKS_BG => '#222222', TcfBodyDesign::SETTING_STACKS_ACTIVE_BG => '#2d2d2d', TcfBodyDesign::SETTING_STACKS_HOVER_BG => '#2d2d2d', TcfBodyDesign::SETTING_STACKS_BORDER_COLOR => '#2d2d2d', TcfBodyDesign::SETTING_STACKS_TITLE_FONT_COLOR => '#f9f9f9', TcfBodyDesign::SETTING_STACKS_DESCRIPTION_FONT_COLOR => '#afafaf'] : [])], 'divi-dialog' => ['name' => \__('Divi Dialog', RCB_TD), 'description' => \__('Optimized design for the standard Divi theme as a consent dialog.', RCB_TD), 'needsPro' => \true, 'settings' => \array_merge([BasicLayout::SETTING_DIALOG_BORDER_RADIUS => 0, BasicLayout::SETTING_BORDER_RADIUS => 2, Design::SETTING_BOX_SHADOW_OFFSET_Y => 2, Design::SETTING_BOX_SHADOW_BLUR_RADIUS => 3, Design::SETTING_BOX_SHADOW_COLOR => '#666666', HeaderDesign::SETTING_PADDING => [19, 20, 17, 20], HeaderDesign::SETTING_FONT_SIZE => 26, HeaderDesign::SETTING_BOTTOM_BORDER_COLOR => '#e2e2e2', BodyDesign::SETTING_DOTTED_GROUPS_BULLET_COLOR => '#2ea3f2', BodyDesign::SETTING_BUTTON_ACCEPT_ALL_BG => '#0089f2', BodyDesign::SETTING_BUTTON_ACCEPT_ALL_FONT_COLOR => '#000000', BodyDesign::SETTING_BUTTON_ACCEPT_ALL_HOVER_BG => '#52a2d8', BodyDesign::SETTING_BUTTON_ACCEPT_ALL_HOVER_FONT_COLOR => '#000000', BodyDesign::SETTING_BUTTON_ACCEPT_INDIVIDUAL_FONT_COLOR => '#0064e8', BodyDesign::SETTING_BUTTON_ACCEPT_INDIVIDUAL_HOVER_FONT_COLOR => '#000000', FooterDesign::SETTING_INHERIT_BG => \true, FooterDesign::SETTING_FONT_COLOR => '#757575', FooterDesign::SETTING_TOP_BORDER_COLOR => '#e2e2e2', Layout::SETTING_DIALOG_MAX_WIDTH => 825, Group::SETTING_CHECKBOX_ACTIVE_COLOR => '#000000', Group::SETTING_CHECKBOX_ACTIVE_BG => '#2ea3f2', Group::SETTING_CHECKBOX_ACTIVE_BORDER_COLOR => '#2993d9'], $this->isPro() ? [TcfBodyDesign::SETTING_STACKS_ARROW_COLOR => '#2ea3f2'] : [])], 'divi-banner' => ['name' => \__('Divi Banner', RCB_TD), 'description' => \__('Optimized design for the standard Divi theme as a consent banner.', RCB_TD), 'needsPro' => \true, 'settings' => \array_merge([BasicLayout::SETTING_TYPE => 'banner', BasicLayout::SETTING_BORDER_RADIUS => 2, BasicLayout::SETTING_OVERLAY => \false, BasicLayout::SETTING_OVERLAY_BG_ALPHA => 38, Design::SETTING_TEXT_ALIGN => 'left', Design::SETTING_BOX_SHADOW_OFFSET_Y => -3, Design::SETTING_BOX_SHADOW_BLUR_RADIUS => 2, Design::SETTING_BOX_SHADOW_COLOR => '#666666', HeaderDesign::SETTING_PADDING => [21, 20, 19, 20], HeaderDesign::SETTING_FONT_SIZE => 26, HeaderDesign::SETTING_BOTTOM_BORDER_COLOR => '#e2e2e2', BodyDesign::SETTING_DOTTED_GROUPS_BULLET_COLOR => '#2ea3f2', BodyDesign::SETTING_BUTTON_ACCEPT_ALL_BG => '#0089f2', BodyDesign::SETTING_BUTTON_ACCEPT_ALL_FONT_COLOR => '#000000', BodyDesign::SETTING_BUTTON_ACCEPT_ALL_HOVER_BG => '#56a4d8', BodyDesign::SETTING_BUTTON_ACCEPT_ALL_HOVER_FONT_COLOR => '#000000', BodyDesign::SETTING_BUTTON_ACCEPT_INDIVIDUAL_FONT_COLOR => '#0064e8', BodyDesign::SETTING_BUTTON_ACCEPT_INDIVIDUAL_HOVER_FONT_COLOR => '#000000', FooterDesign::SETTING_INHERIT_BG => \true, FooterDesign::SETTING_PADDING => [17, 20, 21, 20], FooterDesign::SETTING_FONT_COLOR => '#757575', FooterDesign::SETTING_TOP_BORDER_COLOR => '#e2e2e2', Layout::SETTING_DIALOG_MAX_WIDTH => 825, Group::SETTING_CHECKBOX_ACTIVE_COLOR => '#000000', Group::SETTING_CHECKBOX_ACTIVE_BG => '#2ea3f2', Group::SETTING_CHECKBOX_ACTIVE_BORDER_COLOR => '#2993d9'], $this->isPro() ? [TcfBodyDesign::SETTING_STACKS_ARROW_COLOR => '#2ea3f2'] : [])], 'astra-dialog' => ['name' => \__('Astra Dialog', RCB_TD), 'description' => \__('Optimized design for the standard Astra theme as a consent dialog.', RCB_TD), 'needsPro' => \true, 'settings' => \array_merge([BasicLayout::SETTING_DIALOG_BORDER_RADIUS => 0, BasicLayout::SETTING_BORDER_RADIUS => 1, BasicLayout::SETTING_OVERLAY_BG => '#3a3a3a', BasicLayout::SETTING_OVERLAY_BG_ALPHA => 81, Design::SETTING_FONT_SIZE => 15, Design::SETTING_BOX_SHADOW_BLUR_RADIUS => 2, HeaderDesign::SETTING_PADDING => [19, 30, 17, 30], HeaderDesign::SETTING_FONT_SIZE => 21, HeaderDesign::SETTING_BOTTOM_BORDER_COLOR => '#f5f5f5', BodyDesign::SETTING_PADDING => [20, 30, 5, 30], BodyDesign::SETTING_DOTTED_GROUPS_BULLET_COLOR => '#0274be', BodyDesign::SETTING_TEACHINGS_SEPARATOR_COLOR => '#0274be', BodyDesign::SETTING_BUTTON_ACCEPT_ALL_BG => '#0072bf', BodyDesign::SETTING_BUTTON_ACCEPT_ALL_HOVER_BG => '#0264a6', BodyDesign::SETTING_BUTTON_ACCEPT_INDIVIDUAL_FONT_COLOR => '#0168c1', BodyDesign::SETTING_BUTTON_ACCEPT_INDIVIDUAL_HOVER_FONT_COLOR => '#0264a6', FooterDesign::SETTING_BG => '#f5f5f5', FooterDesign::SETTING_PADDING => [19, 30, 21, 30], FooterDesign::SETTING_FONT_COLOR => '#3a3a3a', FooterDesign::SETTING_HOVER_FONT_COLOR => '#141414', Group::SETTING_CHECKBOX_BORDER_COLOR => '#c6c6c6', Group::SETTING_CHECKBOX_ACTIVE_BG => '#0274be', Group::SETTING_CHECKBOX_ACTIVE_BORDER_COLOR => '#0264a6', Group::SETTING_GROUP_PADDING => [20, 20, 20, 20], Group::SETTING_GROUP_BORDER_RADIUS => 0, Group::SETTING_GROUP_BORDER_COLOR => '#c6c6c6'], $this->isPro() ? [TcfBodyDesign::SETTING_STACKS_ARROW_COLOR => '#0274be'] : [])], 'astra-banner' => ['name' => \__('Astra Banner', RCB_TD), 'description' => \__('Optimized design for the standard Astra theme as a consent banner.', RCB_TD), 'needsPro' => \true, 'settings' => \array_merge([BasicLayout::SETTING_TYPE => 'banner', BasicLayout::SETTING_DIALOG_BORDER_RADIUS => 0, BasicLayout::SETTING_BORDER_RADIUS => 1, BasicLayout::SETTING_OVERLAY => \false, BasicLayout::SETTING_OVERLAY_BG => '#3a3a3a', BasicLayout::SETTING_OVERLAY_BG_ALPHA => 81, Design::SETTING_TEXT_ALIGN => 'left', Design::SETTING_FONT_SIZE => 15, Design::SETTING_BOX_SHADOW_BLUR_RADIUS => 2, HeaderDesign::SETTING_PADDING => [19, 30, 17, 30], HeaderDesign::SETTING_FONT_SIZE => 21, HeaderDesign::SETTING_BOTTOM_BORDER_COLOR => '#f5f5f5', BodyDesign::SETTING_PADDING => [20, 30, 20, 30], BodyDesign::SETTING_DOTTED_GROUPS_BULLET_COLOR => '#0274be', BodyDesign::SETTING_TEACHINGS_SEPARATOR_COLOR => '#0274be', BodyDesign::SETTING_BUTTON_ACCEPT_ALL_BG => '#0072bf', BodyDesign::SETTING_BUTTON_ACCEPT_ALL_HOVER_BG => '#0264a6', BodyDesign::SETTING_BUTTON_ACCEPT_INDIVIDUAL_FONT_COLOR => '#0168c1', BodyDesign::SETTING_BUTTON_ACCEPT_INDIVIDUAL_HOVER_FONT_COLOR => '#0264a6', FooterDesign::SETTING_BG => '#f5f5f5', FooterDesign::SETTING_PADDING => [19, 30, 19, 30], FooterDesign::SETTING_FONT_COLOR => '#3a3a3a', FooterDesign::SETTING_HOVER_FONT_COLOR => '#141414', Layout::SETTING_INHERIT_BANNER_MAX_WIDTH => \false, Layout::SETTING_BANNER_MAX_WIDTH => 950, Group::SETTING_CHECKBOX_BORDER_COLOR => '#c6c6c6', Group::SETTING_CHECKBOX_ACTIVE_BG => '#0274be', Group::SETTING_CHECKBOX_ACTIVE_BORDER_COLOR => '#0264a6', Group::SETTING_GROUP_PADDING => [20, 20, 20, 20], Group::SETTING_GROUP_BORDER_RADIUS => 0, Group::SETTING_GROUP_BORDER_COLOR => '#c6c6c6'], $this->isPro() ? [TcfBodyDesign::SETTING_STACKS_ARROW_COLOR => '#0274be'] : [])], 'avada-dialog' => ['name' => \__('Avada Dialog', RCB_TD), 'description' => \__('Optimized design for the standard Avada theme as a consent dialog.', RCB_TD), 'needsPro' => \true, 'settings' => \array_merge([BasicLayout::SETTING_DIALOG_BORDER_RADIUS => 0, BasicLayout::SETTING_BORDER_RADIUS => 0, BasicLayout::SETTING_OVERLAY_BG => '#212934', BasicLayout::SETTING_OVERLAY_BG_ALPHA => 57, Design::SETTING_FONT_SIZE => 16, Design::SETTING_FONT_COLOR => '#4a4e57', Design::SETTING_BOX_SHADOW_BLUR_RADIUS => 2, Design::SETTING_BOX_SHADOW_COLOR => '#6d6d6d', HeaderDesign::SETTING_PADDING => [17, 30, 15, 30], HeaderDesign::SETTING_FONT_SIZE => 26, BodyDesign::SETTING_PADDING => [20, 30, 15, 30], BodyDesign::SETTING_DOTTED_GROUPS_BULLET_COLOR => '#65bc7b', BodyDesign::SETTING_TEACHINGS_SEPARATOR_COLOR => '#008902', BodyDesign::SETTING_BUTTON_ACCEPT_ALL_PADDING => [12, 10, 12, 10], BodyDesign::SETTING_BUTTON_ACCEPT_ALL_BG => '#008202', BodyDesign::SETTING_BUTTON_ACCEPT_ALL_HOVER_BG => '#286627', BodyDesign::SETTING_BUTTON_ACCEPT_ESSENTIALS_PADDING => [10, 5, 10, 5], BodyDesign::SETTING_BUTTON_ACCEPT_INDIVIDUAL_PADDING => [10, 5, 0, 5], BodyDesign::SETTING_BUTTON_ACCEPT_INDIVIDUAL_FONT_COLOR => '#008202', BodyDesign::SETTING_BUTTON_ACCEPT_INDIVIDUAL_FONT_WEIGHT => 'bolder', BodyDesign::SETTING_BUTTON_ACCEPT_INDIVIDUAL_HOVER_FONT_COLOR => '#286627', FooterDesign::SETTING_BG => '#1d242d', FooterDesign::SETTING_PADDING => [25, 30, 25, 30], FooterDesign::SETTING_FONT_COLOR => '#d2d3d5', FooterDesign::SETTING_HOVER_FONT_COLOR => '#ffffff', Layout::SETTING_DIALOG_MAX_WIDTH => 885, Group::SETTING_CHECKBOX_BG => '#efefef', Group::SETTING_CHECKBOX_BORDER_COLOR => '#e5e5e5', Group::SETTING_CHECKBOX_ACTIVE_BG => '#286627', Group::SETTING_CHECKBOX_ACTIVE_BORDER_COLOR => '#286627', Group::SETTING_GROUP_BORDER_COLOR => '#e5e5e5'], $this->isPro() ? [TcfBodyDesign::SETTING_STACKS_ARROW_COLOR => '#65bc7b'] : [])], 'avada-banner' => ['name' => \__('Avada Banner', RCB_TD), 'description' => \__('Optimized design for the standard Avada theme as a consent banner.', RCB_TD), 'needsPro' => \true, 'settings' => \array_merge([BasicLayout::SETTING_TYPE => 'banner', BasicLayout::SETTING_BORDER_RADIUS => 0, BasicLayout::SETTING_OVERLAY => \false, BasicLayout::SETTING_OVERLAY_BG => '#212934', BasicLayout::SETTING_OVERLAY_BG_ALPHA => 57, Design::SETTING_TEXT_ALIGN => 'left', Design::SETTING_FONT_SIZE => 16, Design::SETTING_FONT_COLOR => '#4a4e57', Design::SETTING_BOX_SHADOW_BLUR_RADIUS => 2, Design::SETTING_BOX_SHADOW_COLOR => '#6d6d6d', HeaderDesign::SETTING_PADDING => [17, 30, 15, 30], HeaderDesign::SETTING_FONT_SIZE => 26, BodyDesign::SETTING_PADDING => [20, 30, 20, 30], BodyDesign::SETTING_DOTTED_GROUPS_BULLET_COLOR => '#65bc7b', BodyDesign::SETTING_TEACHINGS_SEPARATOR_COLOR => '#65bc7b', BodyDesign::SETTING_BUTTON_ACCEPT_ALL_PADDING => [12, 10, 12, 10], BodyDesign::SETTING_BUTTON_ACCEPT_ALL_BG => '#008202', BodyDesign::SETTING_BUTTON_ACCEPT_ALL_HOVER_BG => '#286627', BodyDesign::SETTING_BUTTON_ACCEPT_ESSENTIALS_PADDING => [10, 5, 10, 5], BodyDesign::SETTING_BUTTON_ACCEPT_INDIVIDUAL_PADDING => [10, 5, 0, 5], BodyDesign::SETTING_BUTTON_ACCEPT_INDIVIDUAL_FONT_COLOR => '#008202', BodyDesign::SETTING_BUTTON_ACCEPT_INDIVIDUAL_FONT_WEIGHT => 'bolder', BodyDesign::SETTING_BUTTON_ACCEPT_INDIVIDUAL_HOVER_FONT_COLOR => '#286627', FooterDesign::SETTING_BG => '#1d242d', FooterDesign::SETTING_PADDING => [25, 30, 25, 30], FooterDesign::SETTING_FONT_COLOR => '#d2d3d5', FooterDesign::SETTING_HOVER_FONT_COLOR => '#ffffff', Layout::SETTING_DIALOG_MAX_WIDTH => 885, Group::SETTING_CHECKBOX_BG => '#efefef', Group::SETTING_CHECKBOX_BORDER_COLOR => '#e5e5e5', Group::SETTING_CHECKBOX_ACTIVE_BG => '#286627', Group::SETTING_CHECKBOX_ACTIVE_BORDER_COLOR => '#286627', Group::SETTING_GROUP_BORDER_COLOR => '#e5e5e5'], $this->isPro() ? [TcfBodyDesign::SETTING_STACKS_ARROW_COLOR => '#65bc7b'] : [])], 'clean' => ['name' => \__('Clean Dialog', RCB_TD), 'description' => \__('Clean design which suits perfect to themes without many colors.', RCB_TD), 'needsPro' => \true, 'settings' => \array_merge([BasicLayout::SETTING_DIALOG_BORDER_RADIUS => 9, BasicLayout::SETTING_BORDER_RADIUS => 50, BasicLayout::SETTING_OVERLAY_BLUR => 4, Design::SETTING_BOX_SHADOW_OFFSET_Y => 4, Design::SETTING_BOX_SHADOW_BLUR_RADIUS => 27, Design::SETTING_BOX_SHADOW_COLOR => '#6b6b6b', HeaderDesign::SETTING_PADDING => [20, 20, 10, 20], HeaderDesign::SETTING_FONT_SIZE => 19, HeaderDesign::SETTING_FONT_WEIGHT => 'bold', HeaderDesign::SETTING_BOTTOM_BORDER_WIDTH => 0, BodyDesign::SETTING_DOTTED_GROUPS_BULLET_COLOR => '#000000', BodyDesign::SETTING_TEACHINGS_SEPARATOR_COLOR => '#000000', BodyDesign::SETTING_BUTTON_ACCEPT_ALL_BG => '#000000', BodyDesign::SETTING_BUTTON_ACCEPT_ALL_HOVER_BG => '#262626', BodyDesign::SETTING_BUTTON_ACCEPT_INDIVIDUAL_FONT_COLOR => '#000000', BodyDesign::SETTING_BUTTON_ACCEPT_INDIVIDUAL_HOVER_FONT_COLOR => '#262626', FooterDesign::SETTING_INHERIT_BG => \true, FooterDesign::SETTING_PADDING => [7, 20, 11, 20], FooterDesign::SETTING_FONT_COLOR => '#757575', Group::SETTING_CHECKBOX_BORDER_COLOR => '#000000', Group::SETTING_CHECKBOX_ACTIVE_BG => '#000000', Group::SETTING_CHECKBOX_ACTIVE_BORDER_COLOR => '#000000', Group::SETTING_GROUP_PADDING => [0, 0, 10, 0], Group::SETTING_GROUP_BORDER_WIDTH => 0], $this->isPro() ? [TcfBodyDesign::SETTING_STACKS_ARROW_COLOR => '#000000'] : [])], 'clean-green' => ['name' => \__('Clean Green', RCB_TD), 'description' => \__('Professional request to agree to the cookies.', RCB_TD), 'needsPro' => \true, 'settings' => \array_merge([BasicLayout::SETTING_OVERLAY_BLUR => 3, Design::SETTING_BOX_SHADOW_ENABLED => \false, HeaderDesign::SETTING_INHERIT_BG => \false, HeaderDesign::SETTING_BG => '#f4f7f4', HeaderDesign::SETTING_LOGO_MAX_HEIGHT => 53, HeaderDesign::SETTING_LOGO_MARGIN => [5, 20, 5, 5], HeaderDesign::SETTING_FONT_SIZE => 18, HeaderDesign::SETTING_FONT_COLOR => '#576a76', HeaderDesign::SETTING_FONT_WEIGHT => 'bold', HeaderDesign::SETTING_BOTTOM_BORDER_WIDTH => 0, BodyDesign::SETTING_PADDING => [20, 20, 10, 20], BodyDesign::SETTING_DESCRIPTION_INHERIT_FONT_SIZE => \false, BodyDesign::SETTING_DOTTED_GROUPS_INHERIT_FONT_SIZE => \false, BodyDesign::SETTING_DOTTED_GROUPS_BULLET_COLOR => '#566a76', BodyDesign::SETTING_TEACHINGS_SEPARATOR_ACTIVE => \false, BodyDesign::SETTING_TEACHINGS_SEPARATOR_COLOR => '#566a76', BodyDesign::SETTING_TEACHINGS_INHERIT_FONT_SIZE => \true, BodyDesign::SETTING_TEACHINGS_FONT_SIZE => 13, BodyDesign::SETTING_TEACHINGS_INHERIT_FONT_COLOR => \true, BodyDesign::SETTING_TEACHINGS_FONT_COLOR => '#000000', BodyDesign::SETTING_BUTTON_ACCEPT_ALL_BG => '#007f50', BodyDesign::SETTING_BUTTON_ACCEPT_ALL_HOVER_BG => '#576a76', BodyDesign::SETTING_BUTTON_ACCEPT_INDIVIDUAL_PADDING => [5, 5, 0, 5], BodyDesign::SETTING_BUTTON_ACCEPT_INDIVIDUAL_FONT_COLOR => '#007f50', BodyDesign::SETTING_BUTTON_ACCEPT_INDIVIDUAL_HOVER_FONT_COLOR => '#576a76', FooterDesign::SETTING_BG => '#f4f7f4', FooterDesign::SETTING_FONT_SIZE => 12, FooterDesign::SETTING_FONT_COLOR => '#54595f', FooterDesign::SETTING_HOVER_FONT_COLOR => '#000000', Group::SETTING_CHECKBOX_BG => '#f4f7f4', Group::SETTING_CHECKBOX_BORDER_WIDTH => 2, Group::SETTING_CHECKBOX_BORDER_COLOR => '#576a76', Group::SETTING_CHECKBOX_ACTIVE_COLOR => '#000000', Group::SETTING_CHECKBOX_ACTIVE_BG => '#37a97e', Group::SETTING_CHECKBOX_ACTIVE_BORDER_COLOR => '#37a97e', Group::SETTING_GROUP_PADDING => [20, 20, 20, 20], Group::SETTING_GROUP_BORDER_RADIUS => 1, Group::SETTING_GROUP_BORDER_WIDTH => 2, Group::SETTING_HEADLINE_FONT_SIZE => 15, Group::SETTING_HEADLINE_FONT_WEIGHT => 'bold', Group::SETTING_HEADLINE_COLOR => '#576a76', Group::SETTING_DESCRIPTION_FONT_SIZE => 13, Group::SETTING_DESCRIPTION_COLOR => '#000000', Group::SETTING_LINK_COLOR => '#54595f', Group::SETTING_LINK_HOVER_COLOR => '#000000', SaveButton::SETTING_FONT_SIZE => 15], $this->isPro() ? [TcfBodyDesign::SETTING_STACKS_ARROW_COLOR => '#007f50'] : [])], 'clean-red' => ['name' => \__('Clean Red', RCB_TD), 'description' => \__('Professional request to agree to the cookies.', RCB_TD), 'needsPro' => \true, 'settings' => \array_merge([BasicLayout::SETTING_BORDER_RADIUS => 3, BasicLayout::SETTING_OVERLAY_BG => '#0a0a0a', BasicLayout::SETTING_OVERLAY_BLUR => 3, Design::SETTING_BORDER_COLOR => '#ff0000', Design::SETTING_FONT_SIZE => 14, Design::SETTING_BOX_SHADOW_ENABLED => \false, Design::SETTING_BOX_SHADOW_OFFSET_Y => -2, Design::SETTING_BOX_SHADOW_BLUR_RADIUS => 9, Design::SETTING_BOX_SHADOW_COLOR => '#2b2b2b', HeaderDesign::SETTING_INHERIT_BG => \false, HeaderDesign::SETTING_BG => '#f5f5f5', HeaderDesign::SETTING_LOGO_MAX_HEIGHT => 85, HeaderDesign::SETTING_LOGO_MARGIN => [5, 20, 5, 5], HeaderDesign::SETTING_FONT_SIZE => 18, HeaderDesign::SETTING_FONT_COLOR => '#576a76', BodyDesign::SETTING_PADDING => [20, 20, 10, 20], BodyDesign::SETTING_DESCRIPTION_INHERIT_FONT_SIZE => \false, BodyDesign::SETTING_DESCRIPTION_FONT_SIZE => 14, BodyDesign::SETTING_DOTTED_GROUPS_INHERIT_FONT_SIZE => \false, BodyDesign::SETTING_DOTTED_GROUPS_FONT_SIZE => 14, BodyDesign::SETTING_DOTTED_GROUPS_BULLET_COLOR => '#54595f', BodyDesign::SETTING_TEACHINGS_SEPARATOR_ACTIVE => \false, BodyDesign::SETTING_TEACHINGS_SEPARATOR_HEIGHT => 3, BodyDesign::SETTING_TEACHINGS_SEPARATOR_COLOR => '#566a76', BodyDesign::SETTING_TEACHINGS_INHERIT_FONT_SIZE => \true, BodyDesign::SETTING_TEACHINGS_FONT_SIZE => 13, BodyDesign::SETTING_TEACHINGS_FONT_COLOR => '#54595f', BodyDesign::SETTING_BUTTON_ACCEPT_ALL_BG => '#ae1424', BodyDesign::SETTING_BUTTON_ACCEPT_ALL_HOVER_BG => '#686868', BodyDesign::SETTING_BUTTON_ACCEPT_ESSENTIALS_BG => '#f4f7f4', BodyDesign::SETTING_BUTTON_ACCEPT_ESSENTIALS_FONT_SIZE => 15, BodyDesign::SETTING_BUTTON_ACCEPT_ESSENTIALS_FONT_COLOR => '#686868', BodyDesign::SETTING_BUTTON_ACCEPT_ESSENTIALS_BORDER_COLOR => '#60b239', BodyDesign::SETTING_BUTTON_ACCEPT_ESSENTIALS_HOVER_BG => '#686868', BodyDesign::SETTING_BUTTON_ACCEPT_ESSENTIALS_HOVER_FONT_COLOR => '#ffffff', BodyDesign::SETTING_BUTTON_ACCEPT_ESSENTIALS_HOVER_BORDER_COLOR => '#59a535', BodyDesign::SETTING_BUTTON_ACCEPT_INDIVIDUAL_PADDING => [5, 5, 0, 5], BodyDesign::SETTING_BUTTON_ACCEPT_INDIVIDUAL_FONT_COLOR => '#a0282b', BodyDesign::SETTING_BUTTON_ACCEPT_INDIVIDUAL_HOVER_FONT_COLOR => '#686868', FooterDesign::SETTING_BG => '#f5f5f5', FooterDesign::SETTING_PADDING => [15, 20, 17, 20], FooterDesign::SETTING_FONT_SIZE => 12, FooterDesign::SETTING_FONT_COLOR => '#54595f', FooterDesign::SETTING_HOVER_FONT_COLOR => '#000000', FooterDesign::SETTING_TOP_BORDER_WIDTH => 0, Group::SETTING_CHECKBOX_BORDER_WIDTH => 2, Group::SETTING_CHECKBOX_ACTIVE_BG => '#ae1424', Group::SETTING_CHECKBOX_ACTIVE_BORDER_COLOR => '#ae1424', Group::SETTING_GROUP_PADDING => [20, 20, 20, 20], Group::SETTING_GROUP_BORDER_RADIUS => 1, Group::SETTING_GROUP_BORDER_WIDTH => 2, Group::SETTING_HEADLINE_FONT_SIZE => 15, Group::SETTING_HEADLINE_FONT_WEIGHT => 'bold', Group::SETTING_HEADLINE_COLOR => '#54595f', Group::SETTING_DESCRIPTION_FONT_SIZE => 13, Group::SETTING_DESCRIPTION_COLOR => '#000000', Group::SETTING_LINK_COLOR => '#54595f', Group::SETTING_LINK_HOVER_COLOR => '#000000', SaveButton::SETTING_BG => '#f4f7f4', SaveButton::SETTING_FONT_SIZE => 15, SaveButton::SETTING_FONT_COLOR => '#54595f', SaveButton::SETTING_BORDER_WIDTH => 1, SaveButton::SETTING_BORDER_COLOR => '#54595f', SaveButton::SETTING_HOVER_BG => '#686868', SaveButton::SETTING_HOVER_FONT_COLOR => '#ffffff', SaveButton::SETTING_HOVER_BORDER_COLOR => '#686868'], $this->isPro() ? [TcfBodyDesign::SETTING_STACKS_ARROW_COLOR => '#ae1424'] : [])], 'red-contrast' => [
            'name' => \__('Red Contrast', RCB_TD),
            'description' => \__('Emotionally colorful play of red-black-white.', RCB_TD),
            //'needsPro' => true,
            'settings' => \array_merge([BasicLayout::SETTING_DIALOG_BORDER_RADIUS => 0, BasicLayout::SETTING_BORDER_RADIUS => 0, BasicLayout::SETTING_OVERLAY_BG => '#212934', BasicLayout::SETTING_OVERLAY_BG_ALPHA => 57, BasicLayout::SETTING_OVERLAY_BLUR => 0, Decision::SETTING_SAVE_BUTTON => 'afterChangeAll', Design::SETTING_TEXT_ALIGN => 'left', Design::SETTING_FONT_COLOR => '#4a4e57', Design::SETTING_BOX_SHADOW_OFFSET_Y => -1, Design::SETTING_BOX_SHADOW_BLUR_RADIUS => 62, Design::SETTING_BOX_SHADOW_COLOR => '#6d6d6d', HeaderDesign::SETTING_PADDING => [17, 30, 15, 30], HeaderDesign::SETTING_FONT_SIZE => 26, BodyDesign::SETTING_PADDING => [20, 30, 15, 30], BodyDesign::SETTING_DESCRIPTION_FONT_SIZE => 14, BodyDesign::SETTING_DOTTED_GROUPS_FONT_SIZE => 14, BodyDesign::SETTING_DOTTED_GROUPS_BULLET_COLOR => '#9b0103', BodyDesign::SETTING_TEACHINGS_SEPARATOR_ACTIVE => \false, BodyDesign::SETTING_TEACHINGS_SEPARATOR_HEIGHT => 3, BodyDesign::SETTING_TEACHINGS_SEPARATOR_COLOR => '#65bc7b', BodyDesign::SETTING_BUTTON_ACCEPT_ALL_PADDING => [12, 10, 12, 10], BodyDesign::SETTING_BUTTON_ACCEPT_ALL_BG => '#9b0103', BodyDesign::SETTING_BUTTON_ACCEPT_ALL_HOVER_BG => '#9b0103', BodyDesign::SETTING_BUTTON_ACCEPT_ESSENTIALS_PADDING => [10, 5, 10, 5], BodyDesign::SETTING_BUTTON_ACCEPT_ESSENTIALS_BG => '#ffffff', BodyDesign::SETTING_BUTTON_ACCEPT_ESSENTIALS_FONT_COLOR => '#9b0103', BodyDesign::SETTING_BUTTON_ACCEPT_ESSENTIALS_BORDER_WIDTH => 3, BodyDesign::SETTING_BUTTON_ACCEPT_ESSENTIALS_BORDER_COLOR => '#9b0103', BodyDesign::SETTING_BUTTON_ACCEPT_ESSENTIALS_HOVER_BG => '#ffffff', BodyDesign::SETTING_BUTTON_ACCEPT_ESSENTIALS_HOVER_FONT_COLOR => '#9b0103', BodyDesign::SETTING_BUTTON_ACCEPT_ESSENTIALS_HOVER_BORDER_COLOR => '#9b0103', BodyDesign::SETTING_BUTTON_ACCEPT_INDIVIDUAL_PADDING => [10, 5, 0, 5], BodyDesign::SETTING_BUTTON_ACCEPT_INDIVIDUAL_FONT_COLOR => '#9b0103', BodyDesign::SETTING_BUTTON_ACCEPT_INDIVIDUAL_HOVER_FONT_COLOR => '#9b0103', FooterDesign::SETTING_BG => '#1d242d', FooterDesign::SETTING_PADDING => [25, 30, 25, 30], FooterDesign::SETTING_FONT_COLOR => '#d2d3d5', FooterDesign::SETTING_HOVER_FONT_COLOR => '#ffffff', FooterDesign::SETTING_TOP_BORDER_WIDTH => 0, Group::SETTING_CHECKBOX_BG => '#efefef', Group::SETTING_CHECKBOX_BORDER_COLOR => '#e5e5e5', Group::SETTING_CHECKBOX_ACTIVE_BG => '#9b0103', Group::SETTING_CHECKBOX_ACTIVE_BORDER_COLOR => '#9b0103', Group::SETTING_GROUP_BORDER_RADIUS => 3, SaveButton::SETTING_BG => '#ffffff', SaveButton::SETTING_FONT_COLOR => '#9b0103', SaveButton::SETTING_BORDER_WIDTH => 3, SaveButton::SETTING_BORDER_COLOR => '#9b0103', SaveButton::SETTING_HOVER_BG => '#ffffff', SaveButton::SETTING_HOVER_FONT_COLOR => '#9b0103', SaveButton::SETTING_HOVER_BORDER_COLOR => '#9b0103'], $this->isPro() ? [TcfBodyDesign::SETTING_STACKS_ARROW_COLOR => '#9b0103'] : []),
        ], 'gold-in-the-dark' => ['name' => \__('Gold in the Dark', RCB_TD), 'description' => \__('Dark mode design with a clear accent.', RCB_TD), 'needsPro' => \true, 'settings' => \array_merge([BasicLayout::SETTING_TYPE => 'banner', BasicLayout::SETTING_BORDER_RADIUS => 0, BasicLayout::SETTING_OVERLAY_BG => '#0a0a0a', BasicLayout::SETTING_OVERLAY_BG_ALPHA => 59, Design::SETTING_COLOR_BG => '#222222', Design::SETTING_TEXT_ALIGN => 'left', Design::SETTING_FONT_SIZE => 14, Design::SETTING_FONT_COLOR => '#f9f9f9', Design::SETTING_BOX_SHADOW_OFFSET_Y => -1, Design::SETTING_BOX_SHADOW_BLUR_RADIUS => 17, Design::SETTING_BOX_SHADOW_COLOR => '#0a0a0a', HeaderDesign::SETTING_FONT_SIZE => 17, HeaderDesign::SETTING_FONT_COLOR => '#f9f9f9', HeaderDesign::SETTING_BOTTOM_BORDER_COLOR => '#424242', BodyDesign::SETTING_PADDING => [15, 20, 10, 20], BodyDesign::SETTING_DESCRIPTION_FONT_SIZE => 14, BodyDesign::SETTING_DOTTED_GROUPS_INHERIT_FONT_SIZE => \false, BodyDesign::SETTING_DOTTED_GROUPS_BULLET_COLOR => '#b58d00', BodyDesign::SETTING_TEACHINGS_SEPARATOR_ACTIVE => \false, BodyDesign::SETTING_TEACHINGS_SEPARATOR_WIDTH => 0, BodyDesign::SETTING_TEACHINGS_SEPARATOR_HEIGHT => 0, BodyDesign::SETTING_TEACHINGS_SEPARATOR_COLOR => '#056363', BodyDesign::SETTING_TEACHINGS_FONT_COLOR => '#a0a0a0', BodyDesign::SETTING_BUTTON_ACCEPT_ALL_BG => '#b58d00', BodyDesign::SETTING_BUTTON_ACCEPT_ALL_FONT_SIZE => 16, BodyDesign::SETTING_BUTTON_ACCEPT_ALL_FONT_COLOR => '#000000', BodyDesign::SETTING_BUTTON_ACCEPT_ALL_HOVER_BG => '#896200', BodyDesign::SETTING_BUTTON_ACCEPT_ESSENTIALS_PADDING => [5, 5, 5, 5], BodyDesign::SETTING_BUTTON_ACCEPT_ESSENTIALS_BG => '#222222', BodyDesign::SETTING_BUTTON_ACCEPT_ESSENTIALS_FONT_SIZE => 13, BodyDesign::SETTING_BUTTON_ACCEPT_ESSENTIALS_FONT_COLOR => '#b58d00', BodyDesign::SETTING_BUTTON_ACCEPT_ESSENTIALS_BORDER_WIDTH => 1, BodyDesign::SETTING_BUTTON_ACCEPT_ESSENTIALS_BORDER_COLOR => '#b58d00', BodyDesign::SETTING_BUTTON_ACCEPT_ESSENTIALS_HOVER_BG => '#222222', BodyDesign::SETTING_BUTTON_ACCEPT_ESSENTIALS_HOVER_FONT_COLOR => '#ffffff', BodyDesign::SETTING_BUTTON_ACCEPT_ESSENTIALS_HOVER_BORDER_COLOR => '#b58d00', BodyDesign::SETTING_BUTTON_ACCEPT_INDIVIDUAL_FONT_COLOR => '#b58d00', BodyDesign::SETTING_BUTTON_ACCEPT_INDIVIDUAL_HOVER_FONT_COLOR => '#ffffff', FooterDesign::SETTING_BG => '#141414', FooterDesign::SETTING_PADDING => [15, 20, 17, 20], FooterDesign::SETTING_FONT_SIZE => 13, FooterDesign::SETTING_FONT_COLOR => '#969696', FooterDesign::SETTING_HOVER_FONT_COLOR => '#d3d3d3', FooterDesign::SETTING_TOP_BORDER_COLOR => '#424242', Group::SETTING_CHECKBOX_ACTIVE_COLOR => '#000000', Group::SETTING_CHECKBOX_ACTIVE_BG => '#c6a900', Group::SETTING_CHECKBOX_ACTIVE_BORDER_COLOR => '#000000', Group::SETTING_GROUP_BORDER_RADIUS => 0, Group::SETTING_GROUP_BORDER_COLOR => '#424242', Group::SETTING_HEADLINE_FONT_SIZE => 15, Group::SETTING_HEADLINE_FONT_WEIGHT => 'bolder', Group::SETTING_HEADLINE_COLOR => '#ffffff', Group::SETTING_DESCRIPTION_FONT_SIZE => 13, Group::SETTING_DESCRIPTION_COLOR => '#ffffff', Group::SETTING_LINK_COLOR => '#969696', Group::SETTING_LINK_HOVER_COLOR => '#d3d3d3', SaveButton::SETTING_PADDING => [5, 5, 5, 5], SaveButton::SETTING_BG => '#222222', SaveButton::SETTING_FONT_SIZE => 14, SaveButton::SETTING_FONT_COLOR => '#b58d00', SaveButton::SETTING_BORDER_WIDTH => 1, SaveButton::SETTING_BORDER_COLOR => '#b58d00', SaveButton::SETTING_HOVER_BG => '#222222', SaveButton::SETTING_HOVER_FONT_COLOR => '#ffffff', SaveButton::SETTING_HOVER_BORDER_COLOR => '#b58d00'], $this->isPro() ? [TcfBodyDesign::SETTING_STACKS_PADDING => [5, 5, 5, 5], TcfBodyDesign::SETTING_STACKS_ARROW_COLOR => '#b58d00', TcfBodyDesign::SETTING_STACKS_BG => '#222222', TcfBodyDesign::SETTING_STACKS_ACTIVE_BG => '#2b2b2b', TcfBodyDesign::SETTING_STACKS_HOVER_BG => '#2b2b2b', TcfBodyDesign::SETTING_STACKS_BORDER_WIDTH => 0, TcfBodyDesign::SETTING_STACKS_BORDER_COLOR => '#1c1c1c', TcfBodyDesign::SETTING_STACKS_TITLE_FONT_COLOR => '#ffffff', TcfBodyDesign::SETTING_STACKS_DESCRIPTION_FONT_COLOR => '#a0a0a0'] : [])], 'gold-zen' => ['name' => \__('Gold Zen', RCB_TD), 'description' => \__('Bright appearance with gold-green accent.', RCB_TD), 'needsPro' => \true, 'settings' => \array_merge([BasicLayout::SETTING_TYPE => 'banner', BasicLayout::SETTING_DIALOG_MAX_WIDTH => 400, BasicLayout::SETTING_BORDER_RADIUS => 3, BasicLayout::SETTING_OVERLAY_BG => '#0a0a0a', BasicLayout::SETTING_OVERLAY_BG_ALPHA => 38, BasicLayout::SETTING_OVERLAY_BLUR => 0, Design::SETTING_TEXT_ALIGN => 'left', Design::SETTING_FONT_SIZE => 16, Design::SETTING_FONT_COLOR => '#000302', Design::SETTING_BOX_SHADOW_OFFSET_Y => -1, Design::SETTING_BOX_SHADOW_BLUR_RADIUS => 3, Design::SETTING_BOX_SHADOW_COLOR => '#416a59', HeaderDesign::SETTING_PADDING => [20, 20, 15, 20], HeaderDesign::SETTING_LOGO_MAX_HEIGHT => 70, HeaderDesign::SETTING_LOGO_POSITION => 'above', HeaderDesign::SETTING_FONT_SIZE => 23, HeaderDesign::SETTING_FONT_COLOR => '#000302', HeaderDesign::SETTING_BOTTOM_BORDER_WIDTH => 0, BodyDesign::SETTING_DESCRIPTION_FONT_SIZE => 14, BodyDesign::SETTING_DOTTED_GROUPS_FONT_SIZE => 14, BodyDesign::SETTING_DOTTED_GROUPS_BULLET_COLOR => '#000302', BodyDesign::SETTING_TEACHINGS_SEPARATOR_WIDTH => 150, BodyDesign::SETTING_TEACHINGS_SEPARATOR_COLOR => '#000302', BodyDesign::SETTING_TEACHINGS_FONT_SIZE => 14, BodyDesign::SETTING_TEACHINGS_FONT_COLOR => '#617893', BodyDesign::SETTING_BUTTON_ACCEPT_ALL_BG => '#916704', BodyDesign::SETTING_BUTTON_ACCEPT_ALL_FONT_SIZE => 17, BodyDesign::SETTING_BUTTON_ACCEPT_ALL_BORDER_COLOR => '#ba910b', BodyDesign::SETTING_BUTTON_ACCEPT_ALL_HOVER_BG => '#e5af00', BodyDesign::SETTING_BUTTON_ACCEPT_ALL_HOVER_FONT_COLOR => '#000000', BodyDesign::SETTING_BUTTON_ACCEPT_ALL_HOVER_BORDER_COLOR => '#e5b720', BodyDesign::SETTING_BUTTON_ACCEPT_ESSENTIALS_PADDING => [5, 5, 5, 5], BodyDesign::SETTING_BUTTON_ACCEPT_ESSENTIALS_BG => '#ffffff', BodyDesign::SETTING_BUTTON_ACCEPT_ESSENTIALS_FONT_SIZE => 13, BodyDesign::SETTING_BUTTON_ACCEPT_ESSENTIALS_FONT_COLOR => '#416a59', BodyDesign::SETTING_BUTTON_ACCEPT_ESSENTIALS_BORDER_WIDTH => 1, BodyDesign::SETTING_BUTTON_ACCEPT_ESSENTIALS_BORDER_COLOR => '#416a59', BodyDesign::SETTING_BUTTON_ACCEPT_ESSENTIALS_HOVER_BG => '#ffffff', BodyDesign::SETTING_BUTTON_ACCEPT_ESSENTIALS_HOVER_FONT_COLOR => '#5b8172', BodyDesign::SETTING_BUTTON_ACCEPT_ESSENTIALS_HOVER_BORDER_COLOR => '#5b8172', BodyDesign::SETTING_BUTTON_ACCEPT_INDIVIDUAL_FONT_COLOR => '#916704', BodyDesign::SETTING_BUTTON_ACCEPT_INDIVIDUAL_HOVER_FONT_COLOR => '#000000', FooterDesign::SETTING_BG => '#416a59', FooterDesign::SETTING_PADDING => [15, 20, 17, 20], FooterDesign::SETTING_FONT_COLOR => '#ffffff', FooterDesign::SETTING_HOVER_FONT_COLOR => '#dddddd', FooterDesign::SETTING_TOP_BORDER_WIDTH => 0, Layout::SETTING_DIALOG_MAX_WIDTH => 750, Layout::SETTING_INHERIT_BANNER_MAX_WIDTH => \false, Layout::SETTING_BANNER_MAX_WIDTH => 975, Layout::SETTING_DESCRIPTION_TEXT_ALIGN => 'justify', Group::SETTING_CHECKBOX_BORDER_COLOR => '#416a59', Group::SETTING_CHECKBOX_ACTIVE_BG => '#416a59', Group::SETTING_CHECKBOX_ACTIVE_BORDER_COLOR => '#416a59', Group::SETTING_GROUP_BORDER_RADIUS => 3, Group::SETTING_HEADLINE_COLOR => '#000302', Group::SETTING_LINK_HOVER_COLOR => '#000302', SaveButton::SETTING_PADDING => [2, 2, 2, 2], SaveButton::SETTING_BG => '#ffffff', SaveButton::SETTING_FONT_SIZE => 15, SaveButton::SETTING_FONT_COLOR => '#000302', SaveButton::SETTING_FONT_WEIGHT => 'bold', SaveButton::SETTING_BORDER_COLOR => '#273c75', SaveButton::SETTING_HOVER_BG => '#ffffff', SaveButton::SETTING_HOVER_FONT_COLOR => '#000302', SaveButton::SETTING_HOVER_BORDER_COLOR => '#5b8172'], $this->isPro() ? [TcfBodyDesign::SETTING_STACKS_ARROW_COLOR => '#ba910b'] : [])], 'business-green' => ['name' => \__('Business Green', RCB_TD), 'description' => \__('Professional request to agree to the cookies.', RCB_TD), 'needsPro' => \true, 'settings' => \array_merge([BasicLayout::SETTING_BORDER_RADIUS => 3, BasicLayout::SETTING_OVERLAY_BG => '#0a0a0a', BasicLayout::SETTING_OVERLAY_BLUR => 3, Design::SETTING_FONT_SIZE => 14, Design::SETTING_BOX_SHADOW_ENABLED => \false, Design::SETTING_BOX_SHADOW_OFFSET_Y => -1, Design::SETTING_BOX_SHADOW_BLUR_RADIUS => 9, Design::SETTING_BOX_SHADOW_COLOR => '#2b2b2b', HeaderDesign::SETTING_INHERIT_BG => \false, HeaderDesign::SETTING_BG => '#f4f7f4', HeaderDesign::SETTING_LOGO_MAX_HEIGHT => 53, HeaderDesign::SETTING_LOGO_MARGIN => [5, 20, 5, 5], HeaderDesign::SETTING_FONT_SIZE => 18, HeaderDesign::SETTING_FONT_COLOR => '#576a76', HeaderDesign::SETTING_FONT_WEIGHT => 'bold', HeaderDesign::SETTING_BOTTOM_BORDER_WIDTH => 0, BodyDesign::SETTING_PADDING => [20, 20, 10, 20], BodyDesign::SETTING_DESCRIPTION_INHERIT_FONT_SIZE => \false, BodyDesign::SETTING_DESCRIPTION_FONT_SIZE => 14, BodyDesign::SETTING_DOTTED_GROUPS_INHERIT_FONT_SIZE => \false, BodyDesign::SETTING_DOTTED_GROUPS_FONT_SIZE => 14, BodyDesign::SETTING_DOTTED_GROUPS_BULLET_COLOR => '#566a76', BodyDesign::SETTING_TEACHINGS_SEPARATOR_ACTIVE => \false, BodyDesign::SETTING_TEACHINGS_SEPARATOR_HEIGHT => 3, BodyDesign::SETTING_TEACHINGS_SEPARATOR_COLOR => '#566a76', BodyDesign::SETTING_TEACHINGS_INHERIT_FONT_SIZE => \true, BodyDesign::SETTING_TEACHINGS_FONT_SIZE => 13, BodyDesign::SETTING_TEACHINGS_INHERIT_FONT_COLOR => \true, BodyDesign::SETTING_TEACHINGS_FONT_COLOR => '#000000', BodyDesign::SETTING_BUTTON_ACCEPT_ALL_BG => '#007c63', BodyDesign::SETTING_BUTTON_ACCEPT_ALL_FONT_SIZE => 16, BodyDesign::SETTING_BUTTON_ACCEPT_ALL_HOVER_BG => '#576a76', BodyDesign::SETTING_BUTTON_ACCEPT_ESSENTIALS_BG => '#f4f7f4', BodyDesign::SETTING_BUTTON_ACCEPT_ESSENTIALS_FONT_SIZE => 15, BodyDesign::SETTING_BUTTON_ACCEPT_ESSENTIALS_FONT_COLOR => '#007767', BodyDesign::SETTING_BUTTON_ACCEPT_ESSENTIALS_BORDER_COLOR => '#60b239', BodyDesign::SETTING_BUTTON_ACCEPT_ESSENTIALS_HOVER_BG => '#d7e4ed', BodyDesign::SETTING_BUTTON_ACCEPT_ESSENTIALS_HOVER_FONT_COLOR => '#007c63', BodyDesign::SETTING_BUTTON_ACCEPT_ESSENTIALS_HOVER_BORDER_COLOR => '#59a535', BodyDesign::SETTING_BUTTON_ACCEPT_INDIVIDUAL_PADDING => [5, 5, 0, 5], BodyDesign::SETTING_BUTTON_ACCEPT_INDIVIDUAL_FONT_COLOR => '#007c63', BodyDesign::SETTING_BUTTON_ACCEPT_INDIVIDUAL_HOVER_FONT_COLOR => '#576a76', FooterDesign::SETTING_BG => '#f4f7f4', FooterDesign::SETTING_PADDING => [15, 20, 17, 20], FooterDesign::SETTING_FONT_SIZE => 12, FooterDesign::SETTING_FONT_COLOR => '#000000', FooterDesign::SETTING_HOVER_FONT_COLOR => '#000000', FooterDesign::SETTING_TOP_BORDER_WIDTH => 0, Group::SETTING_CHECKBOX_BG => '#f4f7f4', Group::SETTING_CHECKBOX_BORDER_WIDTH => 2, Group::SETTING_CHECKBOX_BORDER_COLOR => '#576a76', Group::SETTING_CHECKBOX_ACTIVE_BG => '#007767', Group::SETTING_CHECKBOX_ACTIVE_BORDER_COLOR => '#007767', Group::SETTING_GROUP_PADDING => [20, 20, 20, 20], Group::SETTING_GROUP_BORDER_RADIUS => 1, Group::SETTING_GROUP_BORDER_WIDTH => 2, Group::SETTING_HEADLINE_FONT_SIZE => 15, Group::SETTING_HEADLINE_FONT_WEIGHT => 'bold', Group::SETTING_HEADLINE_COLOR => '#576a76', Group::SETTING_DESCRIPTION_FONT_SIZE => 13, Group::SETTING_DESCRIPTION_COLOR => '#000000', Group::SETTING_LINK_COLOR => '#007767', Group::SETTING_LINK_HOVER_COLOR => '#000000', SaveButton::SETTING_BG => '#f4f7f4', SaveButton::SETTING_FONT_SIZE => 15, SaveButton::SETTING_FONT_COLOR => '#007767', SaveButton::SETTING_BORDER_WIDTH => 1, SaveButton::SETTING_BORDER_COLOR => '#007767', SaveButton::SETTING_HOVER_BG => '#d8e4ed', SaveButton::SETTING_HOVER_FONT_COLOR => '#007767', SaveButton::SETTING_HOVER_BORDER_COLOR => '#007767'], $this->isPro() ? [TcfBodyDesign::SETTING_STACKS_ARROW_COLOR => '#007c63'] : [])], 'business-as-usual' => ['name' => \__('Business as usual', RCB_TD), 'description' => \__('Unobtrusive, clear and directly visible to everyone.', RCB_TD), 'needsPro' => \true, 'settings' => \array_merge([BasicLayout::SETTING_DIALOG_BORDER_RADIUS => 0, BasicLayout::SETTING_BORDER_RADIUS => 0, BasicLayout::SETTING_OVERLAY_BG => '#0a0a0a', BasicLayout::SETTING_OVERLAY_BG_ALPHA => 72, BasicLayout::SETTING_OVERLAY_BLUR => 0, Design::SETTING_FONT_SIZE => 14, Design::SETTING_FONT_COLOR => '#3a3a3a', Design::SETTING_BOX_SHADOW_ENABLED => \false, Design::SETTING_BOX_SHADOW_OFFSET_Y => -1, Design::SETTING_BOX_SHADOW_BLUR_RADIUS => 9, Design::SETTING_BOX_SHADOW_COLOR => '#2b2b2b', HeaderDesign::SETTING_LOGO_POSITION => 'above', HeaderDesign::SETTING_FONT_COLOR => '#13293e', HeaderDesign::SETTING_FONT_WEIGHT => 'bolder', HeaderDesign::SETTING_BOTTOM_BORDER_COLOR => '#ebebeb', BodyDesign::SETTING_DESCRIPTION_FONT_SIZE => 14, BodyDesign::SETTING_DOTTED_GROUPS_FONT_SIZE => 14, BodyDesign::SETTING_DOTTED_GROUPS_BULLET_COLOR => '#f5a418', BodyDesign::SETTING_TEACHINGS_SEPARATOR_HEIGHT => 3, BodyDesign::SETTING_TEACHINGS_SEPARATOR_COLOR => '#f5a418', BodyDesign::SETTING_TEACHINGS_INHERIT_FONT_COLOR => \true, BodyDesign::SETTING_TEACHINGS_FONT_COLOR => '#7c7c7c', BodyDesign::SETTING_BUTTON_ACCEPT_ALL_BG => '#13293e', BodyDesign::SETTING_BUTTON_ACCEPT_ALL_HOVER_BG => '#17324f', BodyDesign::SETTING_BUTTON_ACCEPT_ESSENTIALS_PADDING => [5, 5, 5, 5], BodyDesign::SETTING_BUTTON_ACCEPT_ESSENTIALS_BG => '#ffffff', BodyDesign::SETTING_BUTTON_ACCEPT_ESSENTIALS_FONT_SIZE => 14, BodyDesign::SETTING_BUTTON_ACCEPT_ESSENTIALS_FONT_COLOR => '#13293e', BodyDesign::SETTING_BUTTON_ACCEPT_ESSENTIALS_BORDER_WIDTH => 1, BodyDesign::SETTING_BUTTON_ACCEPT_ESSENTIALS_BORDER_COLOR => '#13293e', BodyDesign::SETTING_BUTTON_ACCEPT_ESSENTIALS_HOVER_BG => '#ffffff', BodyDesign::SETTING_BUTTON_ACCEPT_ESSENTIALS_HOVER_FONT_COLOR => '#17324f', BodyDesign::SETTING_BUTTON_ACCEPT_ESSENTIALS_HOVER_BORDER_COLOR => '#17324f', BodyDesign::SETTING_BUTTON_ACCEPT_INDIVIDUAL_FONT_COLOR => '#13293e', BodyDesign::SETTING_BUTTON_ACCEPT_INDIVIDUAL_HOVER_FONT_COLOR => '#17324f', FooterDesign::SETTING_BG => '#f4f4f4', FooterDesign::SETTING_PADDING => [15, 20, 17, 20], FooterDesign::SETTING_FONT_SIZE => 12, FooterDesign::SETTING_FONT_COLOR => '#000000', FooterDesign::SETTING_HOVER_FONT_COLOR => '#6d6d6d', FooterDesign::SETTING_TOP_BORDER_WIDTH => 0, Group::SETTING_CHECKBOX_BG => '#ebebeb', Group::SETTING_CHECKBOX_BORDER_WIDTH => 0, Group::SETTING_CHECKBOX_ACTIVE_BG => '#13293e', Group::SETTING_CHECKBOX_ACTIVE_BORDER_COLOR => '#13293e', Group::SETTING_GROUP_BORDER_RADIUS => 0, Group::SETTING_GROUP_BORDER_COLOR => '#ebebeb', Group::SETTING_HEADLINE_COLOR => '#424242', Group::SETTING_DESCRIPTION_FONT_SIZE => 12, Group::SETTING_DESCRIPTION_COLOR => '#000000', Group::SETTING_LINK_COLOR => '#595959', SaveButton::SETTING_PADDING => [5, 5, 5, 5], SaveButton::SETTING_BG => '#ffffff', SaveButton::SETTING_FONT_SIZE => 14, SaveButton::SETTING_FONT_COLOR => '#13293e', SaveButton::SETTING_BORDER_WIDTH => 1, SaveButton::SETTING_BORDER_COLOR => '#f5a418', SaveButton::SETTING_HOVER_BG => '#ffffff', SaveButton::SETTING_HOVER_FONT_COLOR => '#ffb433', SaveButton::SETTING_HOVER_BORDER_COLOR => '#ffb433'], $this->isPro() ? [TcfBodyDesign::SETTING_STACKS_ARROW_COLOR => '#13293e'] : [])], 'creative-minimal' => ['name' => \__('Creative Minimal', RCB_TD), 'description' => \__('Design as clear and minimalist as possible.', RCB_TD), 'needsPro' => \true, 'settings' => \array_merge([BasicLayout::SETTING_DIALOG_BORDER_RADIUS => 0, BasicLayout::SETTING_BORDER_RADIUS => 0, BasicLayout::SETTING_OVERLAY_BG => '#ffffff', BasicLayout::SETTING_OVERLAY_BLUR => 0, Decision::SETTING_SAVE_BUTTON => 'afterChangeAll', Design::SETTING_COLOR_BG => '#000a1e', Design::SETTING_FONT_COLOR => '#f9f9fa', Design::SETTING_BOX_SHADOW_ENABLED => \false, Design::SETTING_BOX_SHADOW_OFFSET_Y => -1, Design::SETTING_BOX_SHADOW_BLUR_RADIUS => 9, Design::SETTING_BOX_SHADOW_COLOR => '#2b2b2b', HeaderDesign::SETTING_PADDING => [15, 10, 0, 10], HeaderDesign::SETTING_FONT_SIZE => 16, HeaderDesign::SETTING_FONT_COLOR => '#ffffff', HeaderDesign::SETTING_FONT_WEIGHT => 'bold', HeaderDesign::SETTING_BOTTOM_BORDER_WIDTH => 0, HeaderDesign::SETTING_BOTTOM_BORDER_COLOR => '#000a1e', BodyDesign::SETTING_PADDING => [15, 15, 0, 15], BodyDesign::SETTING_DOTTED_GROUPS_FONT_SIZE => 14, BodyDesign::SETTING_DOTTED_GROUPS_BULLET_COLOR => '#f9f9fa', BodyDesign::SETTING_TEACHINGS_SEPARATOR_ACTIVE => \false, BodyDesign::SETTING_TEACHINGS_SEPARATOR_WIDTH => 36, BodyDesign::SETTING_TEACHINGS_SEPARATOR_HEIGHT => 3, BodyDesign::SETTING_TEACHINGS_SEPARATOR_COLOR => '#67bf3d', BodyDesign::SETTING_TEACHINGS_INHERIT_FONT_COLOR => \true, BodyDesign::SETTING_TEACHINGS_FONT_COLOR => '#7c7c7c', BodyDesign::SETTING_BUTTON_ACCEPT_ALL_BG => '#f9f9fa', BodyDesign::SETTING_BUTTON_ACCEPT_ALL_FONT_COLOR => '#000a1e', BodyDesign::SETTING_BUTTON_ACCEPT_ALL_FONT_WEIGHT => 'bolder', BodyDesign::SETTING_BUTTON_ACCEPT_ALL_BORDER_COLOR => '#000a1e', BodyDesign::SETTING_BUTTON_ACCEPT_ALL_HOVER_BG => '#636872', BodyDesign::SETTING_BUTTON_ACCEPT_ALL_HOVER_BORDER_COLOR => '#000a1e', BodyDesign::SETTING_BUTTON_ACCEPT_ESSENTIALS_PADDING => [10, 5, 10, 5], BodyDesign::SETTING_BUTTON_ACCEPT_ESSENTIALS_BG => '#020b1d', BodyDesign::SETTING_BUTTON_ACCEPT_ESSENTIALS_FONT_SIZE => 14, BodyDesign::SETTING_BUTTON_ACCEPT_ESSENTIALS_FONT_COLOR => '#ffffff', BodyDesign::SETTING_BUTTON_ACCEPT_ESSENTIALS_BORDER_WIDTH => 1, BodyDesign::SETTING_BUTTON_ACCEPT_ESSENTIALS_BORDER_COLOR => '#ffffff', BodyDesign::SETTING_BUTTON_ACCEPT_ESSENTIALS_HOVER_BG => '#ffffff', BodyDesign::SETTING_BUTTON_ACCEPT_ESSENTIALS_HOVER_FONT_COLOR => '#020b1d', BodyDesign::SETTING_BUTTON_ACCEPT_ESSENTIALS_HOVER_BORDER_COLOR => '#ffffff', BodyDesign::SETTING_BUTTON_ACCEPT_INDIVIDUAL_FONT_COLOR => '#f9f9fa', BodyDesign::SETTING_BUTTON_ACCEPT_INDIVIDUAL_FONT_WEIGHT => 'bolder', BodyDesign::SETTING_BUTTON_ACCEPT_INDIVIDUAL_HOVER_FONT_COLOR => '#ffffff', FooterDesign::SETTING_INHERIT_BG => \true, FooterDesign::SETTING_BG => '#f4f4f4', FooterDesign::SETTING_PADDING => [0, 20, 15, 20], FooterDesign::SETTING_FONT_COLOR => '#898989', FooterDesign::SETTING_HOVER_FONT_COLOR => '#7c7c7c', FooterDesign::SETTING_TOP_BORDER_WIDTH => 0, Group::SETTING_CHECKBOX_BORDER_WIDTH => 0, Group::SETTING_CHECKBOX_ACTIVE_COLOR => '#000000', Group::SETTING_CHECKBOX_ACTIVE_BG => '#ffffff', Group::SETTING_CHECKBOX_ACTIVE_BORDER_COLOR => '#000a1e', Group::SETTING_GROUP_PADDING => [20, 15, 20, 15], Group::SETTING_GROUP_BORDER_RADIUS => 0, Group::SETTING_GROUP_BORDER_WIDTH => 0, Group::SETTING_HEADLINE_FONT_WEIGHT => 'bolder', Group::SETTING_HEADLINE_COLOR => '#f9f9fa', Group::SETTING_DESCRIPTION_COLOR => '#f9f9fa', Group::SETTING_LINK_COLOR => '#f9f9fa', Group::SETTING_LINK_HOVER_COLOR => '#7c7c7c', SaveButton::SETTING_USE_ACCEPT_ALL => \false, SaveButton::SETTING_TYPE => 'link', SaveButton::SETTING_PADDING => [5, 5, 5, 5], SaveButton::SETTING_BG => '#ffffff', SaveButton::SETTING_FONT_SIZE => 16, SaveButton::SETTING_FONT_COLOR => '#ffffff', SaveButton::SETTING_BORDER_WIDTH => 3, SaveButton::SETTING_BORDER_COLOR => '#60b239', SaveButton::SETTING_HOVER_BG => '#ffffff', SaveButton::SETTING_HOVER_FONT_COLOR => '#ffffff', SaveButton::SETTING_HOVER_BORDER_COLOR => '#59a535'], $this->isPro() ? [TcfBodyDesign::SETTING_STACKS_ARROW_COLOR => '#ffffff', TcfBodyDesign::SETTING_STACKS_BG => '#000a1e', TcfBodyDesign::SETTING_STACKS_ACTIVE_BG => '#000a1e', TcfBodyDesign::SETTING_STACKS_HOVER_BG => '#000719', TcfBodyDesign::SETTING_STACKS_BORDER_WIDTH => 0, TcfBodyDesign::SETTING_STACKS_TITLE_FONT_COLOR => '#ffffff', TcfBodyDesign::SETTING_STACKS_DESCRIPTION_FONT_COLOR => '#828282'] : [])], 'simple-black-white' => ['name' => \__('Simple Black-White', RCB_TD), 'description' => \__('Make it easy with just two colors.', RCB_TD), 'needsPro' => \true, 'settings' => \array_merge([BasicLayout::SETTING_DIALOG_BORDER_RADIUS => 10, BasicLayout::SETTING_BORDER_RADIUS => 0, BasicLayout::SETTING_OVERLAY_BG => '#0a0a0a', BasicLayout::SETTING_OVERLAY_BLUR => 5, Design::SETTING_FONT_SIZE => 14, Design::SETTING_BOX_SHADOW_OFFSET_Y => 4, Design::SETTING_BOX_SHADOW_BLUR_RADIUS => 27, Design::SETTING_BOX_SHADOW_COLOR => '#6b6b6b', HeaderDesign::SETTING_PADDING => [15, 20, 15, 20], HeaderDesign::SETTING_LOGO_MAX_HEIGHT => 47, HeaderDesign::SETTING_LOGO_MARGIN => [5, 5, 5, 0], HeaderDesign::SETTING_FONT_SIZE => 16, HeaderDesign::SETTING_FONT_WEIGHT => 'bold', BodyDesign::SETTING_PADDING => [10, 20, 0, 20], BodyDesign::SETTING_DESCRIPTION_FONT_SIZE => 14, BodyDesign::SETTING_DOTTED_GROUPS_FONT_SIZE => 14, BodyDesign::SETTING_DOTTED_GROUPS_BULLET_COLOR => '#000000', BodyDesign::SETTING_TEACHINGS_SEPARATOR_HEIGHT => 3, BodyDesign::SETTING_TEACHINGS_SEPARATOR_COLOR => '#000000', BodyDesign::SETTING_BUTTON_ACCEPT_ALL_BG => '#000000', BodyDesign::SETTING_BUTTON_ACCEPT_ALL_HOVER_BG => '#282828', BodyDesign::SETTING_BUTTON_ACCEPT_ESSENTIALS_PADDING => [5, 5, 5, 5], BodyDesign::SETTING_BUTTON_ACCEPT_ESSENTIALS_BG => '#ffffff', BodyDesign::SETTING_BUTTON_ACCEPT_ESSENTIALS_FONT_SIZE => 14, BodyDesign::SETTING_BUTTON_ACCEPT_ESSENTIALS_FONT_COLOR => '#000000', BodyDesign::SETTING_BUTTON_ACCEPT_ESSENTIALS_BORDER_WIDTH => 1, BodyDesign::SETTING_BUTTON_ACCEPT_ESSENTIALS_HOVER_BG => '#000000', BodyDesign::SETTING_BUTTON_ACCEPT_ESSENTIALS_HOVER_FONT_COLOR => '#ffffff', BodyDesign::SETTING_BUTTON_ACCEPT_INDIVIDUAL_FONT_COLOR => '#000000', BodyDesign::SETTING_BUTTON_ACCEPT_INDIVIDUAL_HOVER_FONT_COLOR => '#282828', FooterDesign::SETTING_INHERIT_BG => \true, FooterDesign::SETTING_BG => '#f4f4f4', FooterDesign::SETTING_PADDING => [7, 20, 11, 20], FooterDesign::SETTING_FONT_COLOR => '#757575', Group::SETTING_CHECKBOX_BORDER_COLOR => '#000000', Group::SETTING_CHECKBOX_ACTIVE_BG => '#000000', Group::SETTING_CHECKBOX_ACTIVE_BORDER_COLOR => '#000000', Group::SETTING_GROUP_PADDING => [0, 0, 10, 0], Group::SETTING_GROUP_BORDER_RADIUS => 3, Group::SETTING_GROUP_BORDER_WIDTH => 0, SaveButton::SETTING_PADDING => [5, 5, 5, 5], SaveButton::SETTING_BG => '#ffffff', SaveButton::SETTING_FONT_SIZE => 14, SaveButton::SETTING_FONT_COLOR => '#000000', SaveButton::SETTING_BORDER_WIDTH => 3, SaveButton::SETTING_HOVER_BG => '#000000', SaveButton::SETTING_HOVER_FONT_COLOR => '#ffffff'], $this->isPro() ? [TcfBodyDesign::SETTING_STACKS_ARROW_COLOR => '#000000'] : [])]]);
    }
    /**
     * Default values so the templates only override a set of settings.
     */
    public function defaults()
    {
        $sectionArgs = Core::getInstance()->getBanner()->getCustomize()->getSections();
        $defaults = [];
        foreach ($sectionArgs as $sectionId => $section) {
            // Texts should be ignored as they are not really "styles" and template-relevant
            if (\in_array($sectionId, [Texts::SECTION, IndividualTexts::SECTION], \true)) {
                continue;
            }
            foreach ($section['controls'] as $controlId => $control) {
                $setting = isset($control['setting']) ? $control['setting'] : null;
                // Exclude some controls as they are not template-relevant...
                if (\in_array($controlId, [FooterDesign::SETTING_POWERED_BY_LINK, Decision::SETTING_SHOW_CLOSE_ICON], \true)) {
                    continue;
                }
                if (isset($setting)) {
                    $defaults[$controlId] = isset($setting['default']) ? $setting['default'] : \false;
                }
            }
        }
        return $defaults;
    }
    /**
     * Return PHP constant names. This is meant to be so on frontend a PHP code can be
     * generated for a template easily.
     */
    public function constants()
    {
        return \array_merge($this->constantsFromFolder(RCB_INC . 'view/customize/banner/*.php', BasicLayout::class), $this->constantsFromFolder(RCB_INC . 'view/customize/banner/individual/*.php', Group::class), $this->isPro() ? $this->constantsFromFolder(RCB_INC . 'overrides/pro/view/customize/banner/*.php', TcfBodyDesign::class) : []);
    }
    /**
     * Does not support recursive folders.
     *
     * @param string $glob
     * @param string $baseClass
     */
    protected function constantsFromFolder($glob, $baseClass)
    {
        $result = [];
        $classFiles = \glob($glob);
        foreach ($classFiles as $classPath) {
            // Get full qualified name for the class
            $className = \explode('.', \basename($classPath))[0];
            if ($className === 'index') {
                continue;
            }
            $fq = \explode('\\', $baseClass);
            \array_pop($fq);
            \array_push($fq, $className);
            $fq = \join('\\', $fq);
            // Iterate all SETTING_ constants
            $reflection = new ReflectionClass($fq);
            foreach ($reflection->getConstants() as $constant => $value) {
                if (\substr($constant, 0, 8) === 'SETTING_') {
                    $result[$value] = '\\' . $fq . '::' . $constant;
                }
            }
        }
        return $result;
    }
}
