<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit(0);
}

$dbHost = 'localhost:3306';
$dbName = 'gqdcvggs_managements';
$dbUser = 'gqdcvggs';
$dbPass = 'imaors_management.346980*#@-onlyforcpanel;forchange';

try {
    $pdo = new PDO("mysql:host=$dbHost;dbname=$dbName", $dbUser, $dbPass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    echo json_encode(['success' => false, 'error' => 'Database connection failed']);
    exit;
}

$input = json_decode(file_get_contents('php://input'), true);
$action = $input['action'] ?? '';

switch ($action) {
    case 'getSiteData':
        $stmt = $pdo->query("SELECT * FROM site_status ORDER BY site");
        $sites = $stmt->fetchAll(PDO::FETCH_ASSOC);
        
        $data = [];
        foreach ($sites as $site) {
            $data[$site['site']] = [
                'status' => $site['status'],
                'history' => json_decode($site['history'], true)
            ];
        }
        
        echo json_encode(['success' => true, 'data' => $data]);
        break;
        
    case 'saveSiteData':
        $data = $input['data'] ?? [];
        
        foreach ($data as $site => $siteData) {
            $stmt = $pdo->prepare("INSERT INTO site_status (site, status, history, last_update) VALUES (?, ?, ?, NOW()) ON DUPLICATE KEY UPDATE status = VALUES(status), history = VALUES(history), last_update = NOW()");
            $stmt->execute([$site, $siteData['status'], json_encode($siteData['history'])]);
        }
        
        echo json_encode(['success' => true]);
        break;
        
    default:
        echo json_encode(['success' => false, 'error' => 'Invalid action']);
}
?>