<?php
require_once '../db.php';

if($_POST) {
    $titre = $_POST['titre'];
    $description = $_POST['description'];
    $secteurs = $_POST['secteurs'];
    $statut = $_POST['statut'];
    $date_ouverture = $_POST['date_ouverture'];
    $date_fermeture = !empty($_POST['date_fermeture']) ? $_POST['date_fermeture'] : null;
    
    $stmt = $pdo->prepare("INSERT INTO dossiers (titre, description, secteurs, statut, date_ouverture, date_fermeture) VALUES (?, ?, ?, ?, ?, ?)");
    $stmt->execute([$titre, $description, $secteurs, $statut, $date_ouverture, $date_fermeture]);
    
    $dossier_id = $pdo->lastInsertId();
    
    if(!empty($_POST['logs'])) {
        foreach($_POST['logs'] as $log) {
            if(!empty($log['contenu'])) {
                $stmt_log = $pdo->prepare("INSERT INTO logs (dossier_id, type, contenu, date_log) VALUES (?, ?, ?, ?)");
                $stmt_log->execute([$dossier_id, $log['type'], $log['contenu'], $log['date_log']]);
            }
        }
    }
    
    if(isset($_FILES['medias'])) {
        $upload_dir = 'uploads/';
        if(!is_dir($upload_dir)) {
            mkdir($upload_dir, 0777, true);
        }
        
        foreach($_FILES['medias']['name'] as $key => $name) {
            if(!empty($name)) {
                $tmp_name = $_FILES['medias']['tmp_name'][$key];
                $type = $_FILES['medias']['type'][$key];
                $extension = pathinfo($name, PATHINFO_EXTENSION);
                $new_name = uniqid() . '.' . $extension;
                $chemin = $upload_dir . $new_name;
                
                if(move_uploaded_file($tmp_name, $chemin)) {
                    $stmt_media = $pdo->prepare("INSERT INTO medias (dossier_id, nom, type, chemin) VALUES (?, ?, ?, ?)");
                    $stmt_media->execute([$dossier_id, $name, $type, $chemin]);
                }
            }
        }
    }
    
    header('Location: database-directory.php');
    exit;
}
?>

<!DOCTYPE html>
<html lang="en-GB">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>The Lord Court</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Playfair+Display:wght@400;700&family=Inter:wght@300;400&display=swap" rel="stylesheet">
    <style>
        .playfair {
            font-family: 'Playfair Display', serif;
        }
        .inter-light {
            font-family: 'Inter', sans-serif;
            font-weight: 300;
        }
    </style>
</head>
<body class="bg-white">
    <header class="bg-white border-b border-black fixed top-0 left-0 right-0 z-50">
        <div class="max-w-7xl mx-auto px-8 py-6 flex justify-between items-center">
            <h1 class="playfair text-3xl text-black">THE LORD COURT</h1>
            <a href="/" class="inter-light text-black hover:text-gray-600 transition-colors">← Exit</a>
        </div>
    </header>
    <main class="pt-24">
        <section class="max-w-7xl mx-auto px-8 py-20">
            <div class="max-w-6xl">
                <h2 class="playfair text-5xl mb-12 text-black">Case Management</h2>
                
                <div class="flex border-b border-black mb-8">
                    <button onclick="showTab('create')" id="create-tab" class="px-6 py-3 inter-light text-lg border-b-2 border-black bg-black text-white">Create New Case</button>
                    <button onclick="showTab('manage')" id="manage-tab" class="px-6 py-3 inter-light text-lg border-b-2 border-transparent hover:border-gray-300">Manage Cases</button>
                </div>
                
                <div id="create-content" class="tab-content">
                    <form method="POST" enctype="multipart/form-data" class="space-y-8">
                    <div class="grid md:grid-cols-2 gap-8">
                        <div>
                            <label class="inter-light text-lg text-black block mb-2">Case title</label>
                            <input type="text" name="titre" required class="w-full p-4 border border-black inter-light text-lg">
                        </div>
                        <div>
                            <label class="inter-light text-lg text-black block mb-2">Affected sectors</label>
                            <input type="text" name="secteurs" class="w-full p-4 border border-black inter-light text-lg" placeholder="E.g. Cybercrime, Fraud">
                        </div>
                    </div>
                    
                    <div>
                        <label class="inter-light text-lg text-black block mb-2">Case description</label>
                        <textarea name="description" rows="6" class="w-full p-4 border border-black inter-light text-lg"></textarea>
                    </div>
                    
                    <div class="grid md:grid-cols-3 gap-8">
                        <div>
                            <label class="inter-light text-lg text-black block mb-2">Status</label>
                            <select name="statut" class="w-full p-4 border border-black inter-light text-lg">
                                <option value="ouvert">Open</option>
                                <option value="ferme">Closed</option>
                            </select>
                        </div>
                        <div>
                            <label class="inter-light text-lg text-black block mb-2">Opening date</label>
                            <input type="date" name="date_ouverture" required class="w-full p-4 border border-black inter-light text-lg">
                        </div>
                        <div>
                            <label class="inter-light text-lg text-black block mb-2">Closing date</label>
                            <input type="date" name="date_fermeture" class="w-full p-4 border border-black inter-light text-lg">
                        </div>
                    </div>
                    
                    <div>
                        <label class="inter-light text-lg text-black block mb-4">Media files (images/videos)</label>
                        <input type="file" name="medias[]" multiple accept="image/*,video/*" class="w-full p-4 border border-black inter-light text-lg">
                    </div>
                    
                    <div>
                        <h3 class="playfair text-2xl mb-4 text-black">Case logs</h3>
                        <div id="logs-container" class="space-y-4">
                            <div class="log-entry border border-black p-4">
                                <div class="grid md:grid-cols-3 gap-4 mb-4">
                                    <div>
                                        <label class="inter-light text-sm text-black block mb-1">Type</label>
                                        <input type="text" name="logs[0][type]" class="w-full p-2 border border-gray-300 inter-light" placeholder="E.g. Investigation">
                                    </div>
                                    <div>
                                        <label class="inter-light text-sm text-black block mb-1">Date</label>
                                        <input type="datetime-local" name="logs[0][date_log]" class="w-full p-2 border border-gray-300 inter-light">
                                    </div>
                                    <div class="flex items-end">
                                        <button type="button" onclick="removeLog(this)" class="px-4 py-2 bg-red-500 text-white inter-light">Remove</button>
                                    </div>
                                </div>
                                <div>
                                    <label class="inter-light text-sm text-black block mb-1">Content</label>
                                    <textarea name="logs[0][contenu]" rows="3" class="w-full p-2 border border-gray-300 inter-light"></textarea>
                                </div>
                            </div>
                        </div>
                        <button type="button" onclick="addLog()" class="mt-4 px-6 py-3 bg-gray-200 text-black inter-light border border-black">Add log</button>
                    </div>
                    
                    <div class="flex gap-4">
                        <button type="submit" class="px-8 py-4 bg-black text-white inter-light text-lg hover:bg-gray-800 transition-colors">Create case</button>
                        <a href="database-directory.php" class="px-8 py-4 border border-black text-black inter-light text-lg hover:bg-gray-100 transition-colors">Cancel</a>
                    </div>
                                    </form>
                </div>
                
                <div id="manage-content" class="tab-content hidden">
                    <div class="space-y-6">
                        <div class="flex justify-between items-center">
                            <h3 class="playfair text-3xl text-black">All Cases</h3>
                            <div class="flex gap-4">
                                <select id="status-filter" class="p-2 border border-black inter-light">
                                    <option value="">All statuses</option>
                                    <option value="ouvert">Open</option>
                                    <option value="ferme">Closed</option>
                                </select>
                                <input type="text" id="search-cases" placeholder="Search cases..." class="p-2 border border-black inter-light">
                            </div>
                        </div>
                        
                        <div id="cases-list" class="grid md:grid-cols-2 lg:grid-cols-3 gap-4">
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </main>

    <script>
        let logIndex = 1;
        
        function showTab(tabName) {
            document.querySelectorAll('.tab-content').forEach(content => {
                content.classList.add('hidden');
            });
            
            document.querySelectorAll('[id$="-tab"]').forEach(tab => {
                tab.classList.remove('bg-black', 'text-white');
                tab.classList.add('hover:border-gray-300');
                tab.style.borderBottomColor = 'transparent';
            });
            
            document.getElementById(tabName + '-content').classList.remove('hidden');
            document.getElementById(tabName + '-tab').classList.add('bg-black', 'text-white');
            document.getElementById(tabName + '-tab').classList.remove('hover:border-gray-300');
            document.getElementById(tabName + '-tab').style.borderBottomColor = 'black';
            
            if(tabName === 'manage') {
                loadCases();
            }
        }
        
        function loadCases() {
            fetch('get_cases.php')
                .then(response => response.json())
                .then(cases => {
                    displayCases(cases);
                })
                .catch(error => {
                    console.error('Error loading cases:', error);
                });
        }
        
        function displayCases(cases) {
            const container = document.getElementById('cases-list');
            container.innerHTML = '';
            
            cases.forEach(case_item => {
                const caseDiv = document.createElement('div');
                caseDiv.className = 'border border-black p-6 hover:bg-gray-50 transition-colors';
                caseDiv.innerHTML = `
                    <h4 class="playfair text-xl mb-2">${case_item.titre}</h4>
                    <p class="inter-light text-sm text-gray-600 mb-2">Status: ${case_item.statut === 'ouvert' ? 'Open' : 'Closed'}</p>
                    <p class="inter-light text-sm text-gray-600 mb-4">Opened: ${new Date(case_item.date_ouverture).toLocaleDateString('en-GB')}</p>
                    <div class="flex gap-2">
                        <button onclick="editCase('${case_item.id}')" class="px-3 py-1 bg-blue-500 text-white text-sm inter-light">Edit</button>
                        <button onclick="deleteCase('${case_item.id}')" class="px-3 py-1 bg-red-500 text-white text-sm inter-light">Delete</button>
                        <a href="../more-info.php?titre=${encodeURIComponent(case_item.titre)}" class="px-3 py-1 bg-gray-500 text-white text-sm inter-light">View</a>
                    </div>
                `;
                container.appendChild(caseDiv);
            });
        }
        
        function editCase(id) {
            window.location.href = `edit-case.php?id=${id}`;
        }
        
        function deleteCase(id) {
            if(confirm('Are you sure you want to delete this case?')) {
                fetch('delete_case.php', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/x-www-form-urlencoded',
                    },
                    body: `id=${id}`
                })
                .then(response => response.json())
                .then(result => {
                    if(result.success) {
                        loadCases();
                    } else {
                        alert('Error deleting case');
                    }
                });
            }
        }
        
        document.getElementById('search-cases').addEventListener('input', function() {
            const searchTerm = this.value.toLowerCase();
            const cases = document.querySelectorAll('#cases-list > div');
            
            cases.forEach(caseDiv => {
                const title = caseDiv.querySelector('h4').textContent.toLowerCase();
                if(title.includes(searchTerm)) {
                    caseDiv.style.display = 'block';
                } else {
                    caseDiv.style.display = 'none';
                }
            });
        });
        
        document.getElementById('status-filter').addEventListener('change', function() {
            const selectedStatus = this.value;
            loadCases();
        });
        
        function addLog() {
            const container = document.getElementById('logs-container');
            const newLog = document.createElement('div');
            newLog.className = 'log-entry border border-black p-4';
            newLog.innerHTML = `
                <div class="grid md:grid-cols-3 gap-4 mb-4">
                    <div>
                        <label class="inter-light text-sm text-black block mb-1">Type</label>
                        <input type="text" name="logs[${logIndex}][type]" class="w-full p-2 border border-gray-300 inter-light" placeholder="E.g. Investigation">
                    </div>
                    <div>
                        <label class="inter-light text-sm text-black block mb-1">Date</label>
                        <input type="datetime-local" name="logs[${logIndex}][date_log]" class="w-full p-2 border border-gray-300 inter-light">
                    </div>
                    <div class="flex items-end">
                        <button type="button" onclick="removeLog(this)" class="px-4 py-2 bg-red-500 text-white inter-light">Remove</button>
                    </div>
                </div>
                <div>
                    <label class="inter-light text-sm text-black block mb-1">Content</label>
                    <textarea name="logs[${logIndex}][contenu]" rows="3" class="w-full p-2 border border-gray-300 inter-light"></textarea>
                </div>
            `;
            container.appendChild(newLog);
            logIndex++;
        }
        
        function removeLog(button) {
            const entry = button.closest('.log-entry');
            entry.style.transition = 'opacity 0.3s ease';
            entry.style.opacity = '0';
            setTimeout(() => {
                entry.remove();
            }, 300);
        }
        
        document.addEventListener('DOMContentLoaded', function() {
            const form = document.querySelector('form');
            form.addEventListener('submit', function() {
                const submitButton = form.querySelector('button[type="submit"]');
                submitButton.textContent = 'Creating...';
                submitButton.disabled = true;
            });
        });
    </script>
</body>
</html>