<?php
session_start();
require_once 'vendor/autoload.php';
include 'db.php';

\Stripe\Stripe::setApiKey('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');

if (!isset($_SESSION['resident_id'])) {
    http_response_code(403);
    echo json_encode(['error' => 'Non autorisé']);
    exit;
}

$input = json_decode(file_get_contents('php://input'), true);
$resident_id = $_SESSION['resident_id'];

$stmt = $conn->prepare("SELECT * FROM residents WHERE id = ?");
$stmt->bind_param("i", $resident_id);
$stmt->execute();
$resident = $stmt->get_result()->fetch_assoc();

if ($resident['member_'] == 1 && $input['plan'] === 'member') {
    http_response_code(400);
    echo json_encode(['error' => 'Déjà membre']);
    exit;
}

if ($resident['premium_'] == 1 && $input['plan'] === 'premium') {
    http_response_code(400);
    echo json_encode(['error' => 'Déjà membre Vert+']);
    exit;
}

try {
    $customer = null;
    
    if ($resident['stripe_customer_id']) {
        $customer = \Stripe\Customer::retrieve($resident['stripe_customer_id']);
    } else {
        $customer = \Stripe\Customer::create([
            'email' => $resident['email'],
            'name' => $resident['first_name'] . ' ' . $resident['last_name'],
        ]);
        
        $update_stmt = $conn->prepare("UPDATE residents SET stripe_customer_id = ? WHERE id = ?");
        $update_stmt->bind_param("si", $customer->id, $resident_id);
        $update_stmt->execute();
    }

    $price_id = $input['plan'] === 'premium' ? 'price_1S4d4THQanXHoJn0JN6ug3iz' : 'price_1S313NHQanXHoJn0kaCs0yKF';

    $subscription = \Stripe\Subscription::create([
        'customer' => $customer->id,
        'items' => [['price' => $price_id]],
        'payment_behavior' => 'default_incomplete',
        'payment_settings' => ['save_default_payment_method' => 'on_subscription'],
        'expand' => ['latest_invoice.payment_intent'],
        'metadata' => [
            'resident_id' => $resident_id,
            'plan' => $input['plan']
        ]
    ]);

    echo json_encode([
        'subscription_id' => $subscription->id,
        'client_secret' => $subscription->latest_invoice->payment_intent->client_secret,
        'customer_id' => $customer->id
    ]);

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['error' => $e->getMessage()]);
}
?>