<?php
session_start();
include 'db.php';
require_once __DIR__ . '/vendor/autoload.php';


$is_guest = false;
$resident = null;

if (!isset($_SESSION['resident_id']) && !isset($_SESSION['guest_mode'])) {
    header('Location: login.php');
    exit;
}

if (isset($_SESSION['guest_mode'])) {
    $is_guest = true;
} else {
    $resident_id = $_SESSION['resident_id'];
    $stmt = $conn->prepare("SELECT first_name, last_name, address, email FROM residents WHERE id = ?");
    $stmt->bind_param("i", $resident_id);
    $stmt->execute();
    $resident = $stmt->get_result()->fetch_assoc();
    $stmt->close();
}
?>
<!DOCTYPE html>
<html lang="fr" class="h-full">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Générer mon Pass Wallet</title>
  <link rel="icon" type="image/png" href="logo_new.png">
  <script src="https://cdn.tailwindcss.com"></script>
  <script>
    if (window.matchMedia("(prefers-color-scheme: dark)").matches) {
      document.documentElement.classList.add("dark");
    } else {
      document.documentElement.classList.remove("dark");
    }
  </script>
</head>
<body class="flex items-center justify-center min-h-screen bg-gray-100 dark:bg-gray-900 transition-colors">
  <div class="w-full max-w-md p-6 bg-white dark:bg-gray-800 rounded-xl shadow-xl border dark:border-gray-700">
    <?php if ($is_guest): ?>
      <h1 class="text-2xl font-bold mb-4 text-gray-800 dark:text-gray-50">Fonction réservée aux résidents</h1>
      <p class="mb-6 text-gray-600 dark:text-gray-300">Connectez-vous avec un compte résident pour générer un pass Wallet personnalisé.</p>
      <a href="login.php" class="inline-block w-full bg-green-600 hover:bg-green-700 text-white font-semibold py-2 px-4 rounded text-center transition">Se connecter</a>
    <?php else: ?>
      <h1 class="text-2xl font-bold mb-4 text-gray-800 dark:text-gray-50">Confirmez vos informations</h1>
      <form action="generate_pass.php" method="post">
        <div class="space-y-3 mb-4">
          <div>
            <label class="block text-gray-600 dark:text-gray-300 mb-1">Nom</label>
            <input name="name" readonly class="w-full px-3 py-2 border rounded dark:bg-gray-700 dark:text-gray-100" 
              value="<?php echo htmlspecialchars($resident['first_name'] . ' ' . strtoupper($resident['last_name'])); ?>">
          </div>
          <div>
            <label class="block text-gray-600 dark:text-gray-300 mb-1">Adresse</label>
            <input name="address" readonly class="w-full px-3 py-2 border rounded dark:bg-gray-700 dark:text-gray-100"
              value="<?php echo htmlspecialchars($resident['address']); ?>">
          </div>
          <div>
            <label class="block text-gray-600 dark:text-gray-300 mb-1">E-mail</label>
            <input name="email" readonly class="w-full px-3 py-2 border rounded dark:bg-gray-700 dark:text-gray-100"
              value="<?php echo htmlspecialchars($resident['email']); ?>">
          </div>
        </div>
        <button type="submit" class="w-full mt-6 py-2 px-4 bg-black dark:bg-white text-white dark:text-black font-semibold rounded hover:scale-105 transition-transform">
          Générer mon Pass Wallet
        </button>
      </form>
      <p class="mt-8 text-sm text-gray-500 dark:text-gray-400 text-center">Veuillez vérifier vos informations avant de générer votre Pass.</p>
    <?php endif; ?>
  </div>
</body>
</html>
