<?php
session_start();
include 'db.php';

$is_guest = false;
if (!isset($_SESSION['resident_id']) && !isset($_SESSION['guest_mode'])) {
    $_SESSION['guest_mode'] = true;
    $is_guest = true;
} elseif (isset($_SESSION['guest_mode'])) {
    $is_guest = true;
}
?>

<!DOCTYPE html>
<html lang="fr">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Conditions d'utilisation - Vert Chasseur</title>
  <link rel="icon" type="image/png" href="logo_new.png">
  <script src="https://cdn.tailwindcss.com"></script>
  <script>
      tailwind.config = {
          darkMode: 'class',
          theme: {
              extend: {}
          }
      }
  </script>
  <script>
  if (localStorage.theme === 'dark' || (!('theme' in localStorage) && window.matchMedia('(prefers-color-scheme: dark)').matches)) {
    document.documentElement.classList.add('dark');
} else {
    document.documentElement.classList.remove('dark');
}

window.matchMedia('(prefers-color-scheme: dark)').addEventListener('change', (e) => {
    if (!localStorage.theme) {
        if (e.matches) {
            document.documentElement.classList.add('dark');
        } else {
            document.documentElement.classList.remove('dark');
        }
    }
});
  </script>
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600&display=swap" rel="stylesheet">
  <link href="https://fonts.googleapis.com/css2?family=Princess+Sofia&display=swap" rel="stylesheet">
  <style>
    @media (min-width: 768px) {
        body {
            background-image: url('font-homepage.png');
            background-size: cover;
            background-position: center;
            background-attachment: fixed;
            background-repeat: no-repeat;
        }
    }

    @media (max-width: 767px) {
        body {
            background-color: #ffffff !important;
            background-image: none !important;
        }
        .dark body {
            background-color: #000000 !important;
            background-image: none !important;
        }
    }

    body {
        font-family: 'Poppins', sans-serif;
        letter-spacing: -0.01em;
    }

    .txt-chasseur {
        font-family: "Princess Sofia", serif;
        font-weight: 400;
    }
  </style>
</head>

<body class="bg-white dark:bg-black transition-colors duration-300">
  <script>
      if (localStorage.theme === 'dark' || (!('theme' in localStorage) && window.matchMedia('(prefers-color-scheme: dark)').matches)) {
          document.documentElement.classList.add('dark');
      } else {
          document.documentElement.classList.remove('dark');
      }
  </script>

<main class="min-h-screen px-4 py-8 md:py-16">
  <div class="max-w-3xl mx-auto">
    
    <div class="flex items-center gap-4 mb-8 md:mb-12">
      <a href="<?= $is_guest ? 'index.php' : 'resident-dashboard.php' ?>" class="p-2 text-stone-600 dark:text-stone-400 hover:text-stone-800 dark:hover:text-stone-200 transition-colors">
        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
          <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"/>
        </svg>
      </a>
      <h1 class="text-3xl md:text-4xl font-light text-stone-800 dark:text-white tracking-tight">
        Conditions d'utilisation
      </h1>
    </div>

    <div class="bg-white dark:bg-stone-900 rounded-2xl md:rounded-3xl p-6 md:p-8 border border-stone-200 dark:border-stone-800 shadow-lg dark:shadow-stone-900/30 space-y-8">
      
      <section>
        <h2 class="text-2xl font-semibold text-stone-800 dark:text-white mb-4">1. Acceptation des conditions</h2>
        <p class="text-stone-700 dark:text-stone-300 leading-relaxed">
          En accédant et en utilisant l'application Vert Chasseur, tu acceptes de respecter l'intégralité de ces conditions d'utilisation. Si tu n'acceptes pas ces conditions, tu ne dois pas utiliser cette application.
        </p>
      </section>

      <section>
        <h2 class="text-2xl font-semibold text-stone-800 dark:text-white mb-4">2. Description du service</h2>
        <p class="text-stone-700 dark:text-stone-300 leading-relaxed">
          Vert Chasseur est une application mobile et web dédiée à la communauté du quartier d'Uccle. Elle fournit des informations locales, des offres commerciales partenaires, et un système de carte membre. Le service est fourni "en l'état" sans garantie particulière.
        </p>
      </section>

      <section>
        <h2 class="text-2xl font-semibold text-stone-800 dark:text-white mb-4">3. Utilisation autorisée</h2>
        <p class="text-stone-700 dark:text-stone-300 leading-relaxed mb-3">Tu acceptes d'utiliser Vert Chasseur uniquement pour des fins légales et conformément à ces conditions. Tu t'engages à :</p>
        <ul class="list-disc list-inside space-y-2 text-stone-700 dark:text-stone-300">
          <li>Ne pas accéder à l'application de manière non autorisée</li>
          <li>Ne pas transmettre de virus ou code malveillant</li>
          <li>Ne pas usurper l'identité d'une autre personne</li>
          <li>Ne pas tenter de contourner les mesures de sécurité</li>
          <li>Respecter les droits d'auteur et la propriété intellectuelle</li>
        </ul>
      </section>

      <section>
        <h2 class="text-2xl font-semibold text-stone-800 dark:text-white mb-4">4. Compte utilisateur</h2>
        <p class="text-stone-700 dark:text-stone-300 leading-relaxed">
          Tu es responsable du maintien de la confidentialité de tes identifiants de connexion et de toutes les activités qui se déroulent sous ton compte. Tu t'engages à informer immédiatement Vert Chasseur de tout accès non autorisé à ton compte.
        </p>
      </section>

      <section>
        <h2 class="text-2xl font-semibold text-stone-800 dark:text-white mb-4">5. Abonnement et paiement</h2>
        <p class="text-stone-700 dark:text-stone-300 leading-relaxed">
          L'abonnement à la carte membre est payant. En souscrivant, tu autorises le prélèvement automatique sur le moyen de paiement que tu as fourni. L'abonnement peut être annulé à tout moment depuis tes paramètres de compte.
        </p>
      </section>

      <section>
        <h2 class="text-2xl font-semibold text-stone-800 dark:text-white mb-4">6. Limitation de responsabilité</h2>
        <p class="text-stone-700 dark:text-stone-300 leading-relaxed">
          Vert Chasseur n'est pas responsable des dommages indirects, accidentels, spéciaux ou consécutifs résultant de l'utilisation ou de l'impossibilité d'utiliser l'application. Cela inclut la perte de données, la perte de revenus ou les interruptions de service.
        </p>
      </section>

      <section>
        <h2 class="text-2xl font-semibold text-stone-800 dark:text-white mb-4">7. Propriété intellectuelle</h2>
        <p class="text-stone-700 dark:text-stone-300 leading-relaxed">
          Tous les contenus de l'application (textes, images, logos, graphiques, vidéos) sont la propriété exclusive de Vert Chasseur ou de ses partenaires. Toute reproduction, modification ou distribution sans autorisation est interdite.
        </p>
      </section>

      <section>
        <h2 class="text-2xl font-semibold text-stone-800 dark:text-white mb-4">8. Modification des conditions</h2>
        <p class="text-stone-700 dark:text-stone-300 leading-relaxed">
          Vert Chasseur se réserve le droit de modifier ces conditions d'utilisation à tout moment. Les modifications seront communiquées à travers l'application. Ton utilisation continue de l'application après modification constitue une acceptation des nouvelles conditions.
        </p>
      </section>

      <section>
        <h2 class="text-2xl font-semibold text-stone-800 dark:text-white mb-4">9. Résiliation</h2>
        <p class="text-stone-700 dark:text-stone-300 leading-relaxed">
          Vert Chasseur se réserve le droit de suspendre ou de résilier ton accès à l'application en cas de violation des présentes conditions ou de comportement abusif.
        </p>
      </section>

      <section>
        <h2 class="text-2xl font-semibold text-stone-800 dark:text-white mb-4">10. Droit applicable</h2>
        <p class="text-stone-700 dark:text-stone-300 leading-relaxed">
          Ces conditions d'utilisation sont régies par les lois de la Belgique. Tout litige sera de la compétence exclusive des tribunaux belges.
        </p>
      </section>

      <section>
        <h2 class="text-2xl font-semibold text-stone-800 dark:text-white mb-4">11. Contact</h2>
        <p class="text-stone-700 dark:text-stone-300 leading-relaxed">
          Pour toute question concernant ces conditions d'utilisation, tu peux nous contacter à l'adresse e-mail : <span class="font-semibold">msg@aktascorp.com</span>
        </p>
      </section>

      <div class="pt-6 border-t border-stone-200 dark:border-stone-700">
        <p class="text-sm text-stone-500 dark:text-stone-400 text-center">
          Dernière mise à jour : 9 novembre 2025
        </p>
      </div>

    </div>

  </div>
</main>

</body>
</html>